/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataCatalogEncryptionSettingsRequest extends GlueRequest implements
        ToCopyableBuilder<PutDataCatalogEncryptionSettingsRequest.Builder, PutDataCatalogEncryptionSettingsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(PutDataCatalogEncryptionSettingsRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DataCatalogEncryptionSettings> DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD = SdkField
            .<DataCatalogEncryptionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("DataCatalogEncryptionSettings")
            .getter(getter(PutDataCatalogEncryptionSettingsRequest::dataCatalogEncryptionSettings))
            .setter(setter(Builder::dataCatalogEncryptionSettings))
            .constructor(DataCatalogEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogEncryptionSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD));

    private final String catalogId;

    private final DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

    private PutDataCatalogEncryptionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataCatalogEncryptionSettings = builder.dataCatalogEncryptionSettings;
    }

    /**
     * <p>
     * The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used
     * by default.
     * </p>
     * 
     * @return The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID
     *         is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The security configuration to set.
     * </p>
     * 
     * @return The security configuration to set.
     */
    public final DataCatalogEncryptionSettings dataCatalogEncryptionSettings() {
        return dataCatalogEncryptionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalogEncryptionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataCatalogEncryptionSettingsRequest)) {
            return false;
        }
        PutDataCatalogEncryptionSettingsRequest other = (PutDataCatalogEncryptionSettingsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(dataCatalogEncryptionSettings(), other.dataCatalogEncryptionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataCatalogEncryptionSettingsRequest").add("CatalogId", catalogId())
                .add("DataCatalogEncryptionSettings", dataCatalogEncryptionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DataCatalogEncryptionSettings":
            return Optional.ofNullable(clazz.cast(dataCatalogEncryptionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDataCatalogEncryptionSettingsRequest, T> g) {
        return obj -> g.apply((PutDataCatalogEncryptionSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataCatalogEncryptionSettingsRequest> {
        /**
         * <p>
         * The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is
         * used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account
         *        ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The security configuration to set.
         * </p>
         * 
         * @param dataCatalogEncryptionSettings
         *        The security configuration to set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings);

        /**
         * <p>
         * The security configuration to set.
         * </p>
         * This is a convenience that creates an instance of the {@link DataCatalogEncryptionSettings.Builder} avoiding
         * the need to create one manually via {@link DataCatalogEncryptionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCatalogEncryptionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #dataCatalogEncryptionSettings(DataCatalogEncryptionSettings)}
         * .
         * 
         * @param dataCatalogEncryptionSettings
         *        a consumer that will call methods on {@link DataCatalogEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalogEncryptionSettings(DataCatalogEncryptionSettings)
         */
        default Builder dataCatalogEncryptionSettings(
                Consumer<DataCatalogEncryptionSettings.Builder> dataCatalogEncryptionSettings) {
            return dataCatalogEncryptionSettings(DataCatalogEncryptionSettings.builder()
                    .applyMutation(dataCatalogEncryptionSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataCatalogEncryptionSettingsRequest model) {
            super(model);
            catalogId(model.catalogId);
            dataCatalogEncryptionSettings(model.dataCatalogEncryptionSettings);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DataCatalogEncryptionSettings.Builder getDataCatalogEncryptionSettings() {
            return dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.toBuilder() : null;
        }

        @Override
        public final Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        public final void setDataCatalogEncryptionSettings(DataCatalogEncryptionSettings.BuilderImpl dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.build()
                    : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataCatalogEncryptionSettingsRequest build() {
            return new PutDataCatalogEncryptionSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
