/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sampling parameters that are associated with the machine learning transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskRun implements SdkPojo, Serializable, ToCopyableBuilder<TaskRun.Builder, TaskRun> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformId").getter(getter(TaskRun::transformId)).setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> TASK_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskRunId").getter(getter(TaskRun::taskRunId)).setter(setter(Builder::taskRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TaskRun::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(TaskRun::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<TaskRunProperties> PROPERTIES_FIELD = SdkField
            .<TaskRunProperties> builder(MarshallingType.SDK_POJO).memberName("Properties").getter(getter(TaskRun::properties))
            .setter(setter(Builder::properties)).constructor(TaskRunProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorString").getter(getter(TaskRun::errorString)).setter(setter(Builder::errorString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorString").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(TaskRun::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(TaskRun::lastModifiedOn)).setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(TaskRun::completedOn)).setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTime").getter(getter(TaskRun::executionTime)).setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            TASK_RUN_ID_FIELD, STATUS_FIELD, LOG_GROUP_NAME_FIELD, PROPERTIES_FIELD, ERROR_STRING_FIELD, STARTED_ON_FIELD,
            LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transformId;

    private final String taskRunId;

    private final String status;

    private final String logGroupName;

    private final TaskRunProperties properties;

    private final String errorString;

    private final Instant startedOn;

    private final Instant lastModifiedOn;

    private final Instant completedOn;

    private final Integer executionTime;

    private TaskRun(BuilderImpl builder) {
        this.transformId = builder.transformId;
        this.taskRunId = builder.taskRunId;
        this.status = builder.status;
        this.logGroupName = builder.logGroupName;
        this.properties = builder.properties;
        this.errorString = builder.errorString;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
    }

    /**
     * <p>
     * The unique identifier for the transform.
     * </p>
     * 
     * @return The unique identifier for the transform.
     */
    public final String transformId() {
        return transformId;
    }

    /**
     * <p>
     * The unique identifier for this task run.
     * </p>
     * 
     * @return The unique identifier for this task run.
     */
    public final String taskRunId() {
        return taskRunId;
    }

    /**
     * <p>
     * The current status of the requested task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested task run.
     * @see TaskStatusType
     */
    public final TaskStatusType status() {
        return TaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The current status of the requested task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested task run.
     * @see TaskStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The names of the log group for secure logging, associated with this task run.
     * </p>
     * 
     * @return The names of the log group for secure logging, associated with this task run.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Specifies configuration properties associated with this task run.
     * </p>
     * 
     * @return Specifies configuration properties associated with this task run.
     */
    public final TaskRunProperties properties() {
        return properties;
    }

    /**
     * <p>
     * The list of error strings associated with this task run.
     * </p>
     * 
     * @return The list of error strings associated with this task run.
     */
    public final String errorString() {
        return errorString;
    }

    /**
     * <p>
     * The date and time that this task run started.
     * </p>
     * 
     * @return The date and time that this task run started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The last point in time that the requested task run was updated.
     * </p>
     * 
     * @return The last point in time that the requested task run was updated.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * The last point in time that the requested task run was completed.
     * </p>
     * 
     * @return The last point in time that the requested task run was completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The amount of time (in seconds) that the task run consumed resources.
     * </p>
     * 
     * @return The amount of time (in seconds) that the task run consumed resources.
     */
    public final Integer executionTime() {
        return executionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(errorString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(taskRunId(), other.taskRunId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(properties(), other.properties())
                && Objects.equals(errorString(), other.errorString()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(completedOn(), other.completedOn())
                && Objects.equals(executionTime(), other.executionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskRun").add("TransformId", transformId()).add("TaskRunId", taskRunId())
                .add("Status", statusAsString()).add("LogGroupName", logGroupName()).add("Properties", properties())
                .add("ErrorString", errorString()).add("StartedOn", startedOn()).add("LastModifiedOn", lastModifiedOn())
                .add("CompletedOn", completedOn()).add("ExecutionTime", executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "TaskRunId":
            return Optional.ofNullable(clazz.cast(taskRunId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "ErrorString":
            return Optional.ofNullable(clazz.cast(errorString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskRun, T> g) {
        return obj -> g.apply((TaskRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskRun> {
        /**
         * <p>
         * The unique identifier for the transform.
         * </p>
         * 
         * @param transformId
         *        The unique identifier for the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * The unique identifier for this task run.
         * </p>
         * 
         * @param taskRunId
         *        The unique identifier for this task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunId(String taskRunId);

        /**
         * <p>
         * The current status of the requested task run.
         * </p>
         * 
         * @param status
         *        The current status of the requested task run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested task run.
         * </p>
         * 
         * @param status
         *        The current status of the requested task run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(TaskStatusType status);

        /**
         * <p>
         * The names of the log group for secure logging, associated with this task run.
         * </p>
         * 
         * @param logGroupName
         *        The names of the log group for secure logging, associated with this task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Specifies configuration properties associated with this task run.
         * </p>
         * 
         * @param properties
         *        Specifies configuration properties associated with this task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(TaskRunProperties properties);

        /**
         * <p>
         * Specifies configuration properties associated with this task run.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskRunProperties.Builder} avoiding the need to
         * create one manually via {@link TaskRunProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskRunProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #properties(TaskRunProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link TaskRunProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(TaskRunProperties)
         */
        default Builder properties(Consumer<TaskRunProperties.Builder> properties) {
            return properties(TaskRunProperties.builder().applyMutation(properties).build());
        }

        /**
         * <p>
         * The list of error strings associated with this task run.
         * </p>
         * 
         * @param errorString
         *        The list of error strings associated with this task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorString(String errorString);

        /**
         * <p>
         * The date and time that this task run started.
         * </p>
         * 
         * @param startedOn
         *        The date and time that this task run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The last point in time that the requested task run was updated.
         * </p>
         * 
         * @param lastModifiedOn
         *        The last point in time that the requested task run was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * The last point in time that the requested task run was completed.
         * </p>
         * 
         * @param completedOn
         *        The last point in time that the requested task run was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The amount of time (in seconds) that the task run consumed resources.
         * </p>
         * 
         * @param executionTime
         *        The amount of time (in seconds) that the task run consumed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Integer executionTime);
    }

    static final class BuilderImpl implements Builder {
        private String transformId;

        private String taskRunId;

        private String status;

        private String logGroupName;

        private TaskRunProperties properties;

        private String errorString;

        private Instant startedOn;

        private Instant lastModifiedOn;

        private Instant completedOn;

        private Integer executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRun model) {
            transformId(model.transformId);
            taskRunId(model.taskRunId);
            status(model.status);
            logGroupName(model.logGroupName);
            properties(model.properties);
            errorString(model.errorString);
            startedOn(model.startedOn);
            lastModifiedOn(model.lastModifiedOn);
            completedOn(model.completedOn);
            executionTime(model.executionTime);
        }

        public final String getTransformId() {
            return transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getTaskRunId() {
            return taskRunId;
        }

        @Override
        public final Builder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        public final void setTaskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final TaskRunProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        @Override
        public final Builder properties(TaskRunProperties properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(TaskRunProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        public final String getErrorString() {
            return errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final Integer getExecutionTime() {
            return executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public TaskRun build() {
            return new TaskRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
