/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines column statistics supported for integer data columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LongColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<LongColumnStatisticsData.Builder, LongColumnStatisticsData> {
    private static final SdkField<Long> MINIMUM_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MinimumValue").getter(getter(LongColumnStatisticsData::minimumValue))
            .setter(setter(Builder::minimumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()).build();

    private static final SdkField<Long> MAXIMUM_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumValue").getter(getter(LongColumnStatisticsData::maximumValue))
            .setter(setter(Builder::maximumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfNulls").getter(getter(LongColumnStatisticsData::numberOfNulls))
            .setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDistinctValues").getter(getter(LongColumnStatisticsData::numberOfDistinctValues))
            .setter(setter(Builder::numberOfDistinctValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD,
            MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long minimumValue;

    private final Long maximumValue;

    private final Long numberOfNulls;

    private final Long numberOfDistinctValues;

    private LongColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    /**
     * <p>
     * The lowest value in the column.
     * </p>
     * 
     * @return The lowest value in the column.
     */
    public final Long minimumValue() {
        return minimumValue;
    }

    /**
     * <p>
     * The highest value in the column.
     * </p>
     * 
     * @return The highest value in the column.
     */
    public final Long maximumValue() {
        return maximumValue;
    }

    /**
     * <p>
     * The number of null values in the column.
     * </p>
     * 
     * @return The number of null values in the column.
     */
    public final Long numberOfNulls() {
        return numberOfNulls;
    }

    /**
     * <p>
     * The number of distinct values in a column.
     * </p>
     * 
     * @return The number of distinct values in a column.
     */
    public final Long numberOfDistinctValues() {
        return numberOfDistinctValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDistinctValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongColumnStatisticsData)) {
            return false;
        }
        LongColumnStatisticsData other = (LongColumnStatisticsData) obj;
        return Objects.equals(minimumValue(), other.minimumValue()) && Objects.equals(maximumValue(), other.maximumValue())
                && Objects.equals(numberOfNulls(), other.numberOfNulls())
                && Objects.equals(numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LongColumnStatisticsData").add("MinimumValue", minimumValue())
                .add("MaximumValue", maximumValue()).add("NumberOfNulls", numberOfNulls())
                .add("NumberOfDistinctValues", numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumValue":
            return Optional.ofNullable(clazz.cast(minimumValue()));
        case "MaximumValue":
            return Optional.ofNullable(clazz.cast(maximumValue()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        case "NumberOfDistinctValues":
            return Optional.ofNullable(clazz.cast(numberOfDistinctValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LongColumnStatisticsData, T> g) {
        return obj -> g.apply((LongColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LongColumnStatisticsData> {
        /**
         * <p>
         * The lowest value in the column.
         * </p>
         * 
         * @param minimumValue
         *        The lowest value in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumValue(Long minimumValue);

        /**
         * <p>
         * The highest value in the column.
         * </p>
         * 
         * @param maximumValue
         *        The highest value in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumValue(Long maximumValue);

        /**
         * <p>
         * The number of null values in the column.
         * </p>
         * 
         * @param numberOfNulls
         *        The number of null values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);

        /**
         * <p>
         * The number of distinct values in a column.
         * </p>
         * 
         * @param numberOfDistinctValues
         *        The number of distinct values in a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDistinctValues(Long numberOfDistinctValues);
    }

    static final class BuilderImpl implements Builder {
        private Long minimumValue;

        private Long maximumValue;

        private Long numberOfNulls;

        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(LongColumnStatisticsData model) {
            minimumValue(model.minimumValue);
            maximumValue(model.maximumValue);
            numberOfNulls(model.numberOfNulls);
            numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Long getMinimumValue() {
            return minimumValue;
        }

        @Override
        public final Builder minimumValue(Long minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final void setMinimumValue(Long minimumValue) {
            this.minimumValue = minimumValue;
        }

        public final Long getMaximumValue() {
            return maximumValue;
        }

        @Override
        public final Builder maximumValue(Long maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final void setMaximumValue(Long maximumValue) {
            this.maximumValue = maximumValue;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        public final Long getNumberOfDistinctValues() {
            return numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public LongColumnStatisticsData build() {
            return new LongColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
