/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnImportance;
import software.amazon.awssdk.services.glue.model.ColumnImportanceListCopier;
import software.amazon.awssdk.services.glue.model.ConfusionMatrix;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindMatchesMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindMatchesMetrics> {
    private static final SdkField<Double> AREA_UNDER_PR_CURVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AreaUnderPRCurve").getter(FindMatchesMetrics.getter(FindMatchesMetrics::areaUnderPRCurve)).setter(FindMatchesMetrics.setter(Builder::areaUnderPRCurve)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaUnderPRCurve").build()}).build();
    private static final SdkField<Double> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Precision").getter(FindMatchesMetrics.getter(FindMatchesMetrics::precision)).setter(FindMatchesMetrics.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final SdkField<Double> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Recall").getter(FindMatchesMetrics.getter(FindMatchesMetrics::recall)).setter(FindMatchesMetrics.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final SdkField<Double> F1_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("F1").getter(FindMatchesMetrics.getter(FindMatchesMetrics::f1)).setter(FindMatchesMetrics.setter(Builder::f1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1").build()}).build();
    private static final SdkField<ConfusionMatrix> CONFUSION_MATRIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfusionMatrix").getter(FindMatchesMetrics.getter(FindMatchesMetrics::confusionMatrix)).setter(FindMatchesMetrics.setter(Builder::confusionMatrix)).constructor(ConfusionMatrix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfusionMatrix").build()}).build();
    private static final SdkField<List<ColumnImportance>> COLUMN_IMPORTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnImportances").getter(FindMatchesMetrics.getter(FindMatchesMetrics::columnImportances)).setter(FindMatchesMetrics.setter(Builder::columnImportances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnImportances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnImportance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_UNDER_PR_CURVE_FIELD, PRECISION_FIELD, RECALL_FIELD, F1_FIELD, CONFUSION_MATRIX_FIELD, COLUMN_IMPORTANCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double areaUnderPRCurve;
    private final Double precision;
    private final Double recall;
    private final Double f1;
    private final ConfusionMatrix confusionMatrix;
    private final List<ColumnImportance> columnImportances;

    private FindMatchesMetrics(BuilderImpl builder) {
        this.areaUnderPRCurve = builder.areaUnderPRCurve;
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1 = builder.f1;
        this.confusionMatrix = builder.confusionMatrix;
        this.columnImportances = builder.columnImportances;
    }

    public final Double areaUnderPRCurve() {
        return this.areaUnderPRCurve;
    }

    public final Double precision() {
        return this.precision;
    }

    public final Double recall() {
        return this.recall;
    }

    public final Double f1() {
        return this.f1;
    }

    public final ConfusionMatrix confusionMatrix() {
        return this.confusionMatrix;
    }

    public final boolean hasColumnImportances() {
        return this.columnImportances != null && !(this.columnImportances instanceof SdkAutoConstructList);
    }

    public final List<ColumnImportance> columnImportances() {
        return this.columnImportances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.areaUnderPRCurve());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        hashCode = 31 * hashCode + Objects.hashCode(this.f1());
        hashCode = 31 * hashCode + Objects.hashCode(this.confusionMatrix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnImportances() ? this.columnImportances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindMatchesMetrics)) {
            return false;
        }
        FindMatchesMetrics other = (FindMatchesMetrics)obj;
        return Objects.equals(this.areaUnderPRCurve(), other.areaUnderPRCurve()) && Objects.equals(this.precision(), other.precision()) && Objects.equals(this.recall(), other.recall()) && Objects.equals(this.f1(), other.f1()) && Objects.equals(this.confusionMatrix(), other.confusionMatrix()) && this.hasColumnImportances() == other.hasColumnImportances() && Objects.equals(this.columnImportances(), other.columnImportances());
    }

    public final String toString() {
        return ToString.builder((String)"FindMatchesMetrics").add("AreaUnderPRCurve", (Object)this.areaUnderPRCurve()).add("Precision", (Object)this.precision()).add("Recall", (Object)this.recall()).add("F1", (Object)this.f1()).add("ConfusionMatrix", (Object)this.confusionMatrix()).add("ColumnImportances", this.hasColumnImportances() ? this.columnImportances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreaUnderPRCurve": {
                return Optional.ofNullable(clazz.cast(this.areaUnderPRCurve()));
            }
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
            case "F1": {
                return Optional.ofNullable(clazz.cast(this.f1()));
            }
            case "ConfusionMatrix": {
                return Optional.ofNullable(clazz.cast(this.confusionMatrix()));
            }
            case "ColumnImportances": {
                return Optional.ofNullable(clazz.cast(this.columnImportances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindMatchesMetrics, T> g) {
        return obj -> g.apply((FindMatchesMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double areaUnderPRCurve;
        private Double precision;
        private Double recall;
        private Double f1;
        private ConfusionMatrix confusionMatrix;
        private List<ColumnImportance> columnImportances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindMatchesMetrics model) {
            this.areaUnderPRCurve(model.areaUnderPRCurve);
            this.precision(model.precision);
            this.recall(model.recall);
            this.f1(model.f1);
            this.confusionMatrix(model.confusionMatrix);
            this.columnImportances(model.columnImportances);
        }

        public final Double getAreaUnderPRCurve() {
            return this.areaUnderPRCurve;
        }

        @Override
        public final Builder areaUnderPRCurve(Double areaUnderPRCurve) {
            this.areaUnderPRCurve = areaUnderPRCurve;
            return this;
        }

        public final void setAreaUnderPRCurve(Double areaUnderPRCurve) {
            this.areaUnderPRCurve = areaUnderPRCurve;
        }

        public final Double getPrecision() {
            return this.precision;
        }

        @Override
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        public final Double getRecall() {
            return this.recall;
        }

        @Override
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        public final Double getF1() {
            return this.f1;
        }

        @Override
        public final Builder f1(Double f1) {
            this.f1 = f1;
            return this;
        }

        public final void setF1(Double f1) {
            this.f1 = f1;
        }

        public final ConfusionMatrix.Builder getConfusionMatrix() {
            return this.confusionMatrix != null ? this.confusionMatrix.toBuilder() : null;
        }

        @Override
        public final Builder confusionMatrix(ConfusionMatrix confusionMatrix) {
            this.confusionMatrix = confusionMatrix;
            return this;
        }

        public final void setConfusionMatrix(ConfusionMatrix.BuilderImpl confusionMatrix) {
            this.confusionMatrix = confusionMatrix != null ? confusionMatrix.build() : null;
        }

        public final List<ColumnImportance.Builder> getColumnImportances() {
            List<ColumnImportance.Builder> result = ColumnImportanceListCopier.copyToBuilder(this.columnImportances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder columnImportances(Collection<ColumnImportance> columnImportances) {
            this.columnImportances = ColumnImportanceListCopier.copy(columnImportances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnImportances(ColumnImportance ... columnImportances) {
            this.columnImportances(Arrays.asList(columnImportances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnImportances(Consumer<ColumnImportance.Builder> ... columnImportances) {
            this.columnImportances(Stream.of(columnImportances).map(c -> (ColumnImportance)((ColumnImportance.Builder)ColumnImportance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnImportances(Collection<ColumnImportance.BuilderImpl> columnImportances) {
            this.columnImportances = ColumnImportanceListCopier.copyFromBuilder(columnImportances);
        }

        public FindMatchesMetrics build() {
            return new FindMatchesMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindMatchesMetrics> {
        public Builder areaUnderPRCurve(Double var1);

        public Builder precision(Double var1);

        public Builder recall(Double var1);

        public Builder f1(Double var1);

        public Builder confusionMatrix(ConfusionMatrix var1);

        default public Builder confusionMatrix(Consumer<ConfusionMatrix.Builder> confusionMatrix) {
            return this.confusionMatrix((ConfusionMatrix)((ConfusionMatrix.Builder)ConfusionMatrix.builder().applyMutation(confusionMatrix)).build());
        }

        public Builder columnImportances(Collection<ColumnImportance> var1);

        public Builder columnImportances(ColumnImportance ... var1);

        public Builder columnImportances(Consumer<ColumnImportance.Builder> ... var1);
    }
}

