/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SchemaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetSchemaResponse> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(GetSchemaResponse.getter(GetSchemaResponse::registryName)).setter(GetSchemaResponse.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryArn").getter(GetSchemaResponse.getter(GetSchemaResponse::registryArn)).setter(GetSchemaResponse.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(GetSchemaResponse.getter(GetSchemaResponse::schemaName)).setter(GetSchemaResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(GetSchemaResponse.getter(GetSchemaResponse::schemaArn)).setter(GetSchemaResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetSchemaResponse.getter(GetSchemaResponse::description)).setter(GetSchemaResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(GetSchemaResponse.getter(GetSchemaResponse::dataFormatAsString)).setter(GetSchemaResponse.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> COMPATIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compatibility").getter(GetSchemaResponse.getter(GetSchemaResponse::compatibilityAsString)).setter(GetSchemaResponse.setter(Builder::compatibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compatibility").build()}).build();
    private static final SdkField<Long> SCHEMA_CHECKPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SchemaCheckpoint").getter(GetSchemaResponse.getter(GetSchemaResponse::schemaCheckpoint)).setter(GetSchemaResponse.setter(Builder::schemaCheckpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaCheckpoint").build()}).build();
    private static final SdkField<Long> LATEST_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LatestSchemaVersion").getter(GetSchemaResponse.getter(GetSchemaResponse::latestSchemaVersion)).setter(GetSchemaResponse.setter(Builder::latestSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSchemaVersion").build()}).build();
    private static final SdkField<Long> NEXT_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NextSchemaVersion").getter(GetSchemaResponse.getter(GetSchemaResponse::nextSchemaVersion)).setter(GetSchemaResponse.setter(Builder::nextSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSchemaVersion").build()}).build();
    private static final SdkField<String> SCHEMA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaStatus").getter(GetSchemaResponse.getter(GetSchemaResponse::schemaStatusAsString)).setter(GetSchemaResponse.setter(Builder::schemaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaStatus").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(GetSchemaResponse.getter(GetSchemaResponse::createdTime)).setter(GetSchemaResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedTime").getter(GetSchemaResponse.getter(GetSchemaResponse::updatedTime)).setter(GetSchemaResponse.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD, REGISTRY_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_ARN_FIELD, DESCRIPTION_FIELD, DATA_FORMAT_FIELD, COMPATIBILITY_FIELD, SCHEMA_CHECKPOINT_FIELD, LATEST_SCHEMA_VERSION_FIELD, NEXT_SCHEMA_VERSION_FIELD, SCHEMA_STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD));
    private final String registryName;
    private final String registryArn;
    private final String schemaName;
    private final String schemaArn;
    private final String description;
    private final String dataFormat;
    private final String compatibility;
    private final Long schemaCheckpoint;
    private final Long latestSchemaVersion;
    private final Long nextSchemaVersion;
    private final String schemaStatus;
    private final String createdTime;
    private final String updatedTime;

    private GetSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.registryName = builder.registryName;
        this.registryArn = builder.registryArn;
        this.schemaName = builder.schemaName;
        this.schemaArn = builder.schemaArn;
        this.description = builder.description;
        this.dataFormat = builder.dataFormat;
        this.compatibility = builder.compatibility;
        this.schemaCheckpoint = builder.schemaCheckpoint;
        this.latestSchemaVersion = builder.latestSchemaVersion;
        this.nextSchemaVersion = builder.nextSchemaVersion;
        this.schemaStatus = builder.schemaStatus;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    public final String registryName() {
        return this.registryName;
    }

    public final String registryArn() {
        return this.registryArn;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String description() {
        return this.description;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final Compatibility compatibility() {
        return Compatibility.fromValue(this.compatibility);
    }

    public final String compatibilityAsString() {
        return this.compatibility;
    }

    public final Long schemaCheckpoint() {
        return this.schemaCheckpoint;
    }

    public final Long latestSchemaVersion() {
        return this.latestSchemaVersion;
    }

    public final Long nextSchemaVersion() {
        return this.nextSchemaVersion;
    }

    public final SchemaStatus schemaStatus() {
        return SchemaStatus.fromValue(this.schemaStatus);
    }

    public final String schemaStatusAsString() {
        return this.schemaStatus;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String updatedTime() {
        return this.updatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaResponse)) {
            return false;
        }
        GetSchemaResponse other = (GetSchemaResponse)((Object)obj);
        return Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.registryArn(), other.registryArn()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.compatibilityAsString(), other.compatibilityAsString()) && Objects.equals(this.schemaCheckpoint(), other.schemaCheckpoint()) && Objects.equals(this.latestSchemaVersion(), other.latestSchemaVersion()) && Objects.equals(this.nextSchemaVersion(), other.nextSchemaVersion()) && Objects.equals(this.schemaStatusAsString(), other.schemaStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.updatedTime(), other.updatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaResponse").add("RegistryName", (Object)this.registryName()).add("RegistryArn", (Object)this.registryArn()).add("SchemaName", (Object)this.schemaName()).add("SchemaArn", (Object)this.schemaArn()).add("Description", (Object)this.description()).add("DataFormat", (Object)this.dataFormatAsString()).add("Compatibility", (Object)this.compatibilityAsString()).add("SchemaCheckpoint", (Object)this.schemaCheckpoint()).add("LatestSchemaVersion", (Object)this.latestSchemaVersion()).add("NextSchemaVersion", (Object)this.nextSchemaVersion()).add("SchemaStatus", (Object)this.schemaStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("UpdatedTime", (Object)this.updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "RegistryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "Compatibility": {
                return Optional.ofNullable(clazz.cast(this.compatibilityAsString()));
            }
            case "SchemaCheckpoint": {
                return Optional.ofNullable(clazz.cast(this.schemaCheckpoint()));
            }
            case "LatestSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.latestSchemaVersion()));
            }
            case "NextSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.nextSchemaVersion()));
            }
            case "SchemaStatus": {
                return Optional.ofNullable(clazz.cast(this.schemaStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaResponse, T> g) {
        return obj -> g.apply((GetSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String registryName;
        private String registryArn;
        private String schemaName;
        private String schemaArn;
        private String description;
        private String dataFormat;
        private String compatibility;
        private Long schemaCheckpoint;
        private Long latestSchemaVersion;
        private Long nextSchemaVersion;
        private String schemaStatus;
        private String createdTime;
        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaResponse model) {
            super(model);
            this.registryName(model.registryName);
            this.registryArn(model.registryArn);
            this.schemaName(model.schemaName);
            this.schemaArn(model.schemaArn);
            this.description(model.description);
            this.dataFormat(model.dataFormat);
            this.compatibility(model.compatibility);
            this.schemaCheckpoint(model.schemaCheckpoint);
            this.latestSchemaVersion(model.latestSchemaVersion);
            this.nextSchemaVersion(model.nextSchemaVersion);
            this.schemaStatus(model.schemaStatus);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final Builder compatibility(String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        @Override
        public final Builder compatibility(Compatibility compatibility) {
            this.compatibility(compatibility == null ? null : compatibility.toString());
            return this;
        }

        public final void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        public final Long getSchemaCheckpoint() {
            return this.schemaCheckpoint;
        }

        @Override
        public final Builder schemaCheckpoint(Long schemaCheckpoint) {
            this.schemaCheckpoint = schemaCheckpoint;
            return this;
        }

        public final void setSchemaCheckpoint(Long schemaCheckpoint) {
            this.schemaCheckpoint = schemaCheckpoint;
        }

        public final Long getLatestSchemaVersion() {
            return this.latestSchemaVersion;
        }

        @Override
        public final Builder latestSchemaVersion(Long latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
            return this;
        }

        public final void setLatestSchemaVersion(Long latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
        }

        public final Long getNextSchemaVersion() {
            return this.nextSchemaVersion;
        }

        @Override
        public final Builder nextSchemaVersion(Long nextSchemaVersion) {
            this.nextSchemaVersion = nextSchemaVersion;
            return this;
        }

        public final void setNextSchemaVersion(Long nextSchemaVersion) {
            this.nextSchemaVersion = nextSchemaVersion;
        }

        public final String getSchemaStatus() {
            return this.schemaStatus;
        }

        @Override
        public final Builder schemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
            return this;
        }

        @Override
        public final Builder schemaStatus(SchemaStatus schemaStatus) {
            this.schemaStatus(schemaStatus == null ? null : schemaStatus.toString());
            return this;
        }

        public final void setSchemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final String getUpdatedTime() {
            return this.updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public GetSchemaResponse build() {
            return new GetSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaResponse> {
        public Builder registryName(String var1);

        public Builder registryArn(String var1);

        public Builder schemaName(String var1);

        public Builder schemaArn(String var1);

        public Builder description(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder compatibility(String var1);

        public Builder compatibility(Compatibility var1);

        public Builder schemaCheckpoint(Long var1);

        public Builder latestSchemaVersion(Long var1);

        public Builder nextSchemaVersion(Long var1);

        public Builder schemaStatus(String var1);

        public Builder schemaStatus(SchemaStatus var1);

        public Builder createdTime(String var1);

        public Builder updatedTime(String var1);
    }
}

