/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Classifiers are triggered during a crawl task. A classifier checks whether a given file is in a format it can handle.
 * If it is, the classifier creates a schema in the form of a <code>StructType</code> object that matches that data
 * format.
 * </p>
 * <p>
 * You can use the standard classifiers that Glue provides, or you can write your own classifiers to best categorize
 * your data sources and specify the appropriate schemas to use for them. A classifier can be a <code>grok</code>
 * classifier, an <code>XML</code> classifier, a <code>JSON</code> classifier, or a custom <code>CSV</code> classifier,
 * as specified in one of the fields in the <code>Classifier</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Classifier implements SdkPojo, Serializable, ToCopyableBuilder<Classifier.Builder, Classifier> {
    private static final SdkField<GrokClassifier> GROK_CLASSIFIER_FIELD = SdkField
            .<GrokClassifier> builder(MarshallingType.SDK_POJO).memberName("GrokClassifier")
            .getter(getter(Classifier::grokClassifier)).setter(setter(Builder::grokClassifier))
            .constructor(GrokClassifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()).build();

    private static final SdkField<XMLClassifier> XML_CLASSIFIER_FIELD = SdkField
            .<XMLClassifier> builder(MarshallingType.SDK_POJO).memberName("XMLClassifier")
            .getter(getter(Classifier::xmlClassifier)).setter(setter(Builder::xmlClassifier)).constructor(XMLClassifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()).build();

    private static final SdkField<JsonClassifier> JSON_CLASSIFIER_FIELD = SdkField
            .<JsonClassifier> builder(MarshallingType.SDK_POJO).memberName("JsonClassifier")
            .getter(getter(Classifier::jsonClassifier)).setter(setter(Builder::jsonClassifier))
            .constructor(JsonClassifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()).build();

    private static final SdkField<CsvClassifier> CSV_CLASSIFIER_FIELD = SdkField
            .<CsvClassifier> builder(MarshallingType.SDK_POJO).memberName("CsvClassifier")
            .getter(getter(Classifier::csvClassifier)).setter(setter(Builder::csvClassifier)).constructor(CsvClassifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD,
            XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrokClassifier grokClassifier;

    private final XMLClassifier xmlClassifier;

    private final JsonClassifier jsonClassifier;

    private final CsvClassifier csvClassifier;

    private Classifier(BuilderImpl builder) {
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    /**
     * <p>
     * A classifier that uses <code>grok</code>.
     * </p>
     * 
     * @return A classifier that uses <code>grok</code>.
     */
    public final GrokClassifier grokClassifier() {
        return grokClassifier;
    }

    /**
     * <p>
     * A classifier for XML content.
     * </p>
     * 
     * @return A classifier for XML content.
     */
    public final XMLClassifier xmlClassifier() {
        return xmlClassifier;
    }

    /**
     * <p>
     * A classifier for JSON content.
     * </p>
     * 
     * @return A classifier for JSON content.
     */
    public final JsonClassifier jsonClassifier() {
        return jsonClassifier;
    }

    /**
     * <p>
     * A classifier for comma-separated values (CSV).
     * </p>
     * 
     * @return A classifier for comma-separated values (CSV).
     */
    public final CsvClassifier csvClassifier() {
        return csvClassifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(csvClassifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Classifier)) {
            return false;
        }
        Classifier other = (Classifier) obj;
        return Objects.equals(grokClassifier(), other.grokClassifier()) && Objects.equals(xmlClassifier(), other.xmlClassifier())
                && Objects.equals(jsonClassifier(), other.jsonClassifier())
                && Objects.equals(csvClassifier(), other.csvClassifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Classifier").add("GrokClassifier", grokClassifier()).add("XMLClassifier", xmlClassifier())
                .add("JsonClassifier", jsonClassifier()).add("CsvClassifier", csvClassifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrokClassifier":
            return Optional.ofNullable(clazz.cast(grokClassifier()));
        case "XMLClassifier":
            return Optional.ofNullable(clazz.cast(xmlClassifier()));
        case "JsonClassifier":
            return Optional.ofNullable(clazz.cast(jsonClassifier()));
        case "CsvClassifier":
            return Optional.ofNullable(clazz.cast(csvClassifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Classifier, T> g) {
        return obj -> g.apply((Classifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Classifier> {
        /**
         * <p>
         * A classifier that uses <code>grok</code>.
         * </p>
         * 
         * @param grokClassifier
         *        A classifier that uses <code>grok</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grokClassifier(GrokClassifier grokClassifier);

        /**
         * <p>
         * A classifier that uses <code>grok</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link GrokClassifier.Builder} avoiding the need to
         * create one manually via {@link GrokClassifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrokClassifier.Builder#build()} is called immediately and its
         * result is passed to {@link #grokClassifier(GrokClassifier)}.
         * 
         * @param grokClassifier
         *        a consumer that will call methods on {@link GrokClassifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grokClassifier(GrokClassifier)
         */
        default Builder grokClassifier(Consumer<GrokClassifier.Builder> grokClassifier) {
            return grokClassifier(GrokClassifier.builder().applyMutation(grokClassifier).build());
        }

        /**
         * <p>
         * A classifier for XML content.
         * </p>
         * 
         * @param xmlClassifier
         *        A classifier for XML content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xmlClassifier(XMLClassifier xmlClassifier);

        /**
         * <p>
         * A classifier for XML content.
         * </p>
         * This is a convenience that creates an instance of the {@link XMLClassifier.Builder} avoiding the need to
         * create one manually via {@link XMLClassifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link XMLClassifier.Builder#build()} is called immediately and its
         * result is passed to {@link #xmlClassifier(XMLClassifier)}.
         * 
         * @param xmlClassifier
         *        a consumer that will call methods on {@link XMLClassifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xmlClassifier(XMLClassifier)
         */
        default Builder xmlClassifier(Consumer<XMLClassifier.Builder> xmlClassifier) {
            return xmlClassifier(XMLClassifier.builder().applyMutation(xmlClassifier).build());
        }

        /**
         * <p>
         * A classifier for JSON content.
         * </p>
         * 
         * @param jsonClassifier
         *        A classifier for JSON content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonClassifier(JsonClassifier jsonClassifier);

        /**
         * <p>
         * A classifier for JSON content.
         * </p>
         * This is a convenience that creates an instance of the {@link JsonClassifier.Builder} avoiding the need to
         * create one manually via {@link JsonClassifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link JsonClassifier.Builder#build()} is called immediately and its
         * result is passed to {@link #jsonClassifier(JsonClassifier)}.
         * 
         * @param jsonClassifier
         *        a consumer that will call methods on {@link JsonClassifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonClassifier(JsonClassifier)
         */
        default Builder jsonClassifier(Consumer<JsonClassifier.Builder> jsonClassifier) {
            return jsonClassifier(JsonClassifier.builder().applyMutation(jsonClassifier).build());
        }

        /**
         * <p>
         * A classifier for comma-separated values (CSV).
         * </p>
         * 
         * @param csvClassifier
         *        A classifier for comma-separated values (CSV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvClassifier(CsvClassifier csvClassifier);

        /**
         * <p>
         * A classifier for comma-separated values (CSV).
         * </p>
         * This is a convenience that creates an instance of the {@link CsvClassifier.Builder} avoiding the need to
         * create one manually via {@link CsvClassifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link CsvClassifier.Builder#build()} is called immediately and its
         * result is passed to {@link #csvClassifier(CsvClassifier)}.
         * 
         * @param csvClassifier
         *        a consumer that will call methods on {@link CsvClassifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvClassifier(CsvClassifier)
         */
        default Builder csvClassifier(Consumer<CsvClassifier.Builder> csvClassifier) {
            return csvClassifier(CsvClassifier.builder().applyMutation(csvClassifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrokClassifier grokClassifier;

        private XMLClassifier xmlClassifier;

        private JsonClassifier jsonClassifier;

        private CsvClassifier csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Classifier model) {
            grokClassifier(model.grokClassifier);
            xmlClassifier(model.xmlClassifier);
            jsonClassifier(model.jsonClassifier);
            csvClassifier(model.csvClassifier);
        }

        public final GrokClassifier.Builder getGrokClassifier() {
            return grokClassifier != null ? grokClassifier.toBuilder() : null;
        }

        @Override
        public final Builder grokClassifier(GrokClassifier grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final void setGrokClassifier(GrokClassifier.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        public final XMLClassifier.Builder getXmlClassifier() {
            return xmlClassifier != null ? xmlClassifier.toBuilder() : null;
        }

        @Override
        public final Builder xmlClassifier(XMLClassifier xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final void setXmlClassifier(XMLClassifier.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        public final JsonClassifier.Builder getJsonClassifier() {
            return jsonClassifier != null ? jsonClassifier.toBuilder() : null;
        }

        @Override
        public final Builder jsonClassifier(JsonClassifier jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final void setJsonClassifier(JsonClassifier.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        public final CsvClassifier.Builder getCsvClassifier() {
            return csvClassifier != null ? csvClassifier.toBuilder() : null;
        }

        @Override
        public final Builder csvClassifier(CsvClassifier csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        public final void setCsvClassifier(CsvClassifier.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        public Classifier build() {
            return new Classifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
