/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSchemaRequest extends GlueRequest implements
        ToCopyableBuilder<CreateSchemaRequest.Builder, CreateSchemaRequest> {
    private static final SdkField<RegistryId> REGISTRY_ID_FIELD = SdkField.<RegistryId> builder(MarshallingType.SDK_POJO)
            .memberName("RegistryId").getter(getter(CreateSchemaRequest::registryId)).setter(setter(Builder::registryId))
            .constructor(RegistryId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(CreateSchemaRequest::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(CreateSchemaRequest::dataFormatAsString)).setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> COMPATIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compatibility").getter(getter(CreateSchemaRequest::compatibilityAsString))
            .setter(setter(Builder::compatibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compatibility").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSchemaRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSchemaRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaDefinition").getter(getter(CreateSchemaRequest::schemaDefinition))
            .setter(setter(Builder::schemaDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            SCHEMA_NAME_FIELD, DATA_FORMAT_FIELD, COMPATIBILITY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SCHEMA_DEFINITION_FIELD));

    private final RegistryId registryId;

    private final String schemaName;

    private final String dataFormat;

    private final String compatibility;

    private final String description;

    private final Map<String, String> tags;

    private final String schemaDefinition;

    private CreateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.schemaName = builder.schemaName;
        this.dataFormat = builder.dataFormat;
        this.compatibility = builder.compatibility;
        this.description = builder.description;
        this.tags = builder.tags;
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * This is a wrapper shape to contain the registry identity fields. If this is not provided, the default registry
     * will be used. The ARN format for the same will be:
     * <code>arn:aws:glue:us-east-2:&lt;customer id&gt;:registry/default-registry:random-5-letter-id</code>.
     * </p>
     * 
     * @return This is a wrapper shape to contain the registry identity fields. If this is not provided, the default
     *         registry will be used. The ARN format for the same will be:
     *         <code>arn:aws:glue:us-east-2:&lt;customer id&gt;:registry/default-registry:random-5-letter-id</code>.
     */
    public final RegistryId registryId() {
        return registryId;
    }

    /**
     * <p>
     * Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore,
     * dollar sign, or hash mark. No whitespace.
     * </p>
     * 
     * @return Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen,
     *         underscore, dollar sign, or hash mark. No whitespace.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
     *         supported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
     *         supported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The compatibility mode of the schema. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not
     * know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without
     * undergoing a compatibility check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this choice
     * to prevent future versioning of a schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the current
     * and one previous schema version. This means that for instance, a new schema version cannot drop data fields or
     * change the type of these fields, so they can't be read by readers using the previous version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all previous
     * schema versions. You can use this choice when you need to delete fields or add optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema
     * version, but not necessarily later versions. You can use this choice when you need to add fields or delete
     * optional fields, but only check compatibility against the last schema version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new
     * registered schema. You can use this choice when you need to add fields or delete optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the previous
     * or next version of the schema, but not necessarily earlier or later versions. You can use this choice when you
     * need to add or remove optional fields, but only check compatibility against the last schema version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all
     * previous schema versions. You can use this choice when you need to add or remove optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibility}
     * will return {@link Compatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibilityAsString}.
     * </p>
     * 
     * @return The compatibility mode of the schema. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do
     *         not know the compatibility mode that you want to apply to schemas. Any new version added will be accepted
     *         without undergoing a compatibility check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this
     *         choice to prevent future versioning of a schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
     *         current and one previous schema version. This means that for instance, a new schema version cannot drop
     *         data fields or change the type of these fields, so they can't be read by readers using the previous
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
     *         previous schema versions. You can use this choice when you need to delete fields or add optional fields,
     *         and check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next
     *         schema version, but not necessarily later versions. You can use this choice when you need to add fields
     *         or delete optional fields, but only check compatibility against the last schema version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any
     *         new registered schema. You can use this choice when you need to add fields or delete optional fields, and
     *         check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the
     *         previous or next version of the schema, but not necessarily earlier or later versions. You can use this
     *         choice when you need to add or remove optional fields, but only check compatibility against the last
     *         schema version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using
     *         all previous schema versions. You can use this choice when you need to add or remove optional fields, and
     *         check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     * @see Compatibility
     */
    public final Compatibility compatibility() {
        return Compatibility.fromValue(compatibility);
    }

    /**
     * <p>
     * The compatibility mode of the schema. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not
     * know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without
     * undergoing a compatibility check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this choice
     * to prevent future versioning of a schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the current
     * and one previous schema version. This means that for instance, a new schema version cannot drop data fields or
     * change the type of these fields, so they can't be read by readers using the previous version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all previous
     * schema versions. You can use this choice when you need to delete fields or add optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema
     * version, but not necessarily later versions. You can use this choice when you need to add fields or delete
     * optional fields, but only check compatibility against the last schema version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new
     * registered schema. You can use this choice when you need to add fields or delete optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the previous
     * or next version of the schema, but not necessarily earlier or later versions. You can use this choice when you
     * need to add or remove optional fields, but only check compatibility against the last schema version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all
     * previous schema versions. You can use this choice when you need to add or remove optional fields, and check
     * compatibility against all previous schema versions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibility}
     * will return {@link Compatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibilityAsString}.
     * </p>
     * 
     * @return The compatibility mode of the schema. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do
     *         not know the compatibility mode that you want to apply to schemas. Any new version added will be accepted
     *         without undergoing a compatibility check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this
     *         choice to prevent future versioning of a schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
     *         current and one previous schema version. This means that for instance, a new schema version cannot drop
     *         data fields or change the type of these fields, so they can't be read by readers using the previous
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
     *         previous schema versions. You can use this choice when you need to delete fields or add optional fields,
     *         and check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next
     *         schema version, but not necessarily later versions. You can use this choice when you need to add fields
     *         or delete optional fields, but only check compatibility against the last schema version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any
     *         new registered schema. You can use this choice when you need to add fields or delete optional fields, and
     *         check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the
     *         previous or next version of the schema, but not necessarily earlier or later versions. You can use this
     *         choice when you need to add or remove optional fields, but only check compatibility against the last
     *         schema version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using
     *         all previous schema versions. You can use this choice when you need to add or remove optional fields, and
     *         check compatibility against all previous schema versions.
     *         </p>
     *         </li>
     * @see Compatibility
     */
    public final String compatibilityAsString() {
        return compatibility;
    }

    /**
     * <p>
     * An optional description of the schema. If description is not provided, there will not be any automatic default
     * value for this.
     * </p>
     * 
     * @return An optional description of the schema. If description is not provided, there will not be any automatic
     *         default value for this.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API. If
     * specified, follows the Amazon Web Services tags-on-create pattern.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or
     *         API. If specified, follows the Amazon Web Services tags-on-create pattern.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.
     * </p>
     * 
     * @return The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.
     */
    public final String schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaRequest)) {
            return false;
        }
        CreateSchemaRequest other = (CreateSchemaRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(compatibilityAsString(), other.compatibilityAsString())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSchemaRequest").add("RegistryId", registryId()).add("SchemaName", schemaName())
                .add("DataFormat", dataFormatAsString()).add("Compatibility", compatibilityAsString())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "Compatibility":
            return Optional.ofNullable(clazz.cast(compatibilityAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SchemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaRequest, T> g) {
        return obj -> g.apply((CreateSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSchemaRequest> {
        /**
         * <p>
         * This is a wrapper shape to contain the registry identity fields. If this is not provided, the default
         * registry will be used. The ARN format for the same will be:
         * <code>arn:aws:glue:us-east-2:&lt;customer id&gt;:registry/default-registry:random-5-letter-id</code>.
         * </p>
         * 
         * @param registryId
         *        This is a wrapper shape to contain the registry identity fields. If this is not provided, the default
         *        registry will be used. The ARN format for the same will be:
         *        <code>arn:aws:glue:us-east-2:&lt;customer id&gt;:registry/default-registry:random-5-letter-id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(RegistryId registryId);

        /**
         * <p>
         * This is a wrapper shape to contain the registry identity fields. If this is not provided, the default
         * registry will be used. The ARN format for the same will be:
         * <code>arn:aws:glue:us-east-2:&lt;customer id&gt;:registry/default-registry:random-5-letter-id</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link RegistryId.Builder} avoiding the need to create
         * one manually via {@link RegistryId#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryId.Builder#build()} is called immediately and its result
         * is passed to {@link #registryId(RegistryId)}.
         * 
         * @param registryId
         *        a consumer that will call methods on {@link RegistryId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryId(RegistryId)
         */
        default Builder registryId(Consumer<RegistryId.Builder> registryId) {
            return registryId(RegistryId.builder().applyMutation(registryId).build());
        }

        /**
         * <p>
         * Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen,
         * underscore, dollar sign, or hash mark. No whitespace.
         * </p>
         * 
         * @param schemaName
         *        Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen,
         *        underscore, dollar sign, or hash mark. No whitespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
         *        supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
         *        supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The compatibility mode of the schema. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not
         * know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without
         * undergoing a compatibility check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this
         * choice to prevent future versioning of a schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
         * current and one previous schema version. This means that for instance, a new schema version cannot drop data
         * fields or change the type of these fields, so they can't be read by readers using the previous version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
         * previous schema versions. You can use this choice when you need to delete fields or add optional fields, and
         * check compatibility against all previous schema versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema
         * version, but not necessarily later versions. You can use this choice when you need to add fields or delete
         * optional fields, but only check compatibility against the last schema version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new
         * registered schema. You can use this choice when you need to add fields or delete optional fields, and check
         * compatibility against all previous schema versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the
         * previous or next version of the schema, but not necessarily earlier or later versions. You can use this
         * choice when you need to add or remove optional fields, but only check compatibility against the last schema
         * version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all
         * previous schema versions. You can use this choice when you need to add or remove optional fields, and check
         * compatibility against all previous schema versions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param compatibility
         *        The compatibility mode of the schema. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you
         *        do not know the compatibility mode that you want to apply to schemas. Any new version added will be
         *        accepted without undergoing a compatibility check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use
         *        this choice to prevent future versioning of a schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
         *        current and one previous schema version. This means that for instance, a new schema version cannot
         *        drop data fields or change the type of these fields, so they can't be read by readers using the
         *        previous version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
         *        previous schema versions. You can use this choice when you need to delete fields or add optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next
         *        schema version, but not necessarily later versions. You can use this choice when you need to add
         *        fields or delete optional fields, but only check compatibility against the last schema version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of
         *        any new registered schema. You can use this choice when you need to add fields or delete optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using
         *        the previous or next version of the schema, but not necessarily earlier or later versions. You can use
         *        this choice when you need to add or remove optional fields, but only check compatibility against the
         *        last schema version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers
         *        using all previous schema versions. You can use this choice when you need to add or remove optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         * @see Compatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compatibility
         */
        Builder compatibility(String compatibility);

        /**
         * <p>
         * The compatibility mode of the schema. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not
         * know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without
         * undergoing a compatibility check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this
         * choice to prevent future versioning of a schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
         * current and one previous schema version. This means that for instance, a new schema version cannot drop data
         * fields or change the type of these fields, so they can't be read by readers using the previous version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
         * previous schema versions. You can use this choice when you need to delete fields or add optional fields, and
         * check compatibility against all previous schema versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema
         * version, but not necessarily later versions. You can use this choice when you need to add fields or delete
         * optional fields, but only check compatibility against the last schema version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new
         * registered schema. You can use this choice when you need to add fields or delete optional fields, and check
         * compatibility against all previous schema versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the
         * previous or next version of the schema, but not necessarily earlier or later versions. You can use this
         * choice when you need to add or remove optional fields, but only check compatibility against the last schema
         * version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all
         * previous schema versions. You can use this choice when you need to add or remove optional fields, and check
         * compatibility against all previous schema versions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param compatibility
         *        The compatibility mode of the schema. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you
         *        do not know the compatibility mode that you want to apply to schemas. Any new version added will be
         *        accepted without undergoing a compatibility check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use
         *        this choice to prevent future versioning of a schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the
         *        current and one previous schema version. This means that for instance, a new schema version cannot
         *        drop data fields or change the type of these fields, so they can't be read by readers using the
         *        previous version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all
         *        previous schema versions. You can use this choice when you need to delete fields or add optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next
         *        schema version, but not necessarily later versions. You can use this choice when you need to add
         *        fields or delete optional fields, but only check compatibility against the last schema version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of
         *        any new registered schema. You can use this choice when you need to add fields or delete optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using
         *        the previous or next version of the schema, but not necessarily earlier or later versions. You can use
         *        this choice when you need to add or remove optional fields, but only check compatibility against the
         *        last schema version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers
         *        using all previous schema versions. You can use this choice when you need to add or remove optional
         *        fields, and check compatibility against all previous schema versions.
         *        </p>
         *        </li>
         * @see Compatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compatibility
         */
        Builder compatibility(Compatibility compatibility);

        /**
         * <p>
         * An optional description of the schema. If description is not provided, there will not be any automatic
         * default value for this.
         * </p>
         * 
         * @param description
         *        An optional description of the schema. If description is not provided, there will not be any automatic
         *        default value for this.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API.
         * If specified, follows the Amazon Web Services tags-on-create pattern.
         * </p>
         * 
         * @param tags
         *        Amazon Web Services tags that contain a key value pair and may be searched by console, command line,
         *        or API. If specified, follows the Amazon Web Services tags-on-create pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.
         * </p>
         * 
         * @param schemaDefinition
         *        The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(String schemaDefinition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private RegistryId registryId;

        private String schemaName;

        private String dataFormat;

        private String compatibility;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaRequest model) {
            super(model);
            registryId(model.registryId);
            schemaName(model.schemaName);
            dataFormat(model.dataFormat);
            compatibility(model.compatibility);
            description(model.description);
            tags(model.tags);
            schemaDefinition(model.schemaDefinition);
        }

        public final RegistryId.Builder getRegistryId() {
            return registryId != null ? registryId.toBuilder() : null;
        }

        @Override
        public final Builder registryId(RegistryId registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(RegistryId.BuilderImpl registryId) {
            this.registryId = registryId != null ? registryId.build() : null;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getCompatibility() {
            return compatibility;
        }

        @Override
        public final Builder compatibility(String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        @Override
        public final Builder compatibility(Compatibility compatibility) {
            this.compatibility(compatibility == null ? null : compatibility.toString());
            return this;
        }

        public final void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getSchemaDefinition() {
            return schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSchemaRequest build() {
            return new CreateSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
