/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon DynamoDB table to crawl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamoDBTarget implements SdkPojo, Serializable, ToCopyableBuilder<DynamoDBTarget.Builder, DynamoDBTarget> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(DynamoDBTarget::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Boolean> SCAN_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("scanAll").getter(getter(DynamoDBTarget::scanAll)).setter(setter(Builder::scanAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanAll").build()).build();

    private static final SdkField<Double> SCAN_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("scanRate").getter(getter(DynamoDBTarget::scanRate)).setter(setter(Builder::scanRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SCAN_ALL_FIELD,
            SCAN_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final Boolean scanAll;

    private final Double scanRate;

    private DynamoDBTarget(BuilderImpl builder) {
        this.path = builder.path;
        this.scanAll = builder.scanAll;
        this.scanRate = builder.scanRate;
    }

    /**
     * <p>
     * The name of the DynamoDB table to crawl.
     * </p>
     * 
     * @return The name of the DynamoDB table to crawl.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a
     * long time when the table is not a high throughput table.
     * </p>
     * <p>
     * A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the
     * records. If no value is specified, the value defaults to <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can
     *         take a long time when the table is not a high throughput table.</p>
     *         <p>
     *         A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to
     *         sample the records. If no value is specified, the value defaults to <code>true</code>.
     */
    public final Boolean scanAll() {
        return scanAll;
    }

    /**
     * <p>
     * The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a term
     * defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can be
     * performed on that table per second.
     * </p>
     * <p>
     * The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a value,
     * and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max configured
     * Read Capacity Unit (for tables using on-demand mode).
     * </p>
     * 
     * @return The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a
     *         term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that
     *         can be performed on that table per second.</p>
     *         <p>
     *         The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide
     *         a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of
     *         the max configured Read Capacity Unit (for tables using on-demand mode).
     */
    public final Double scanRate() {
        return scanRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(scanAll());
        hashCode = 31 * hashCode + Objects.hashCode(scanRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBTarget)) {
            return false;
        }
        DynamoDBTarget other = (DynamoDBTarget) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(scanAll(), other.scanAll())
                && Objects.equals(scanRate(), other.scanRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamoDBTarget").add("Path", path()).add("ScanAll", scanAll()).add("ScanRate", scanRate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "scanAll":
            return Optional.ofNullable(clazz.cast(scanAll()));
        case "scanRate":
            return Optional.ofNullable(clazz.cast(scanRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBTarget, T> g) {
        return obj -> g.apply((DynamoDBTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamoDBTarget> {
        /**
         * <p>
         * The name of the DynamoDB table to crawl.
         * </p>
         * 
         * @param path
         *        The name of the DynamoDB table to crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can
         * take a long time when the table is not a high throughput table.
         * </p>
         * <p>
         * A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample
         * the records. If no value is specified, the value defaults to <code>true</code>.
         * </p>
         * 
         * @param scanAll
         *        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records
         *        can take a long time when the table is not a high throughput table.</p>
         *        <p>
         *        A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to
         *        sample the records. If no value is specified, the value defaults to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanAll(Boolean scanAll);

        /**
         * <p>
         * The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a
         * term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can
         * be performed on that table per second.
         * </p>
         * <p>
         * The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a
         * value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max
         * configured Read Capacity Unit (for tables using on-demand mode).
         * </p>
         * 
         * @param scanRate
         *        The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units
         *        is a term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of
         *        reads that can be performed on that table per second.</p>
         *        <p>
         *        The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not
         *        provide a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or
         *        0.25 of the max configured Read Capacity Unit (for tables using on-demand mode).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanRate(Double scanRate);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private Boolean scanAll;

        private Double scanRate;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBTarget model) {
            path(model.path);
            scanAll(model.scanAll);
            scanRate(model.scanRate);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Boolean getScanAll() {
            return scanAll;
        }

        @Override
        public final Builder scanAll(Boolean scanAll) {
            this.scanAll = scanAll;
            return this;
        }

        public final void setScanAll(Boolean scanAll) {
            this.scanAll = scanAll;
        }

        public final Double getScanRate() {
            return scanRate;
        }

        @Override
        public final Builder scanRate(Double scanRate) {
            this.scanRate = scanRate;
            return this;
        }

        public final void setScanRate(Double scanRate) {
            this.scanRate = scanRate;
        }

        @Override
        public DynamoDBTarget build() {
            return new DynamoDBTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
