/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionRequest extends GlueRequest implements
        ToCopyableBuilder<GetConnectionRequest.Builder, GetConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetConnectionRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConnectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> HIDE_PASSWORD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HidePassword").getter(getter(GetConnectionRequest::hidePassword)).setter(setter(Builder::hidePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HidePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NAME_FIELD,
            HIDE_PASSWORD_FIELD));

    private final String catalogId;

    private final String name;

    private final Boolean hidePassword;

    private GetConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.hidePassword = builder.hidePassword;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services account
     * ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
     *         account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the connection definition to retrieve.
     * </p>
     * 
     * @return The name of the connection definition to retrieve.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console
     * uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller
     * might not have permission to use the KMS key to decrypt the password, but it does have permission to access the
     * rest of the connection properties.
     * </p>
     * 
     * @return Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue
     *         console uses this flag to retrieve the connection, and does not display the password. Set this parameter
     *         when the caller might not have permission to use the KMS key to decrypt the password, but it does have
     *         permission to access the rest of the connection properties.
     */
    public final Boolean hidePassword() {
        return hidePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hidePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionRequest)) {
            return false;
        }
        GetConnectionRequest other = (GetConnectionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(name(), other.name())
                && Objects.equals(hidePassword(), other.hidePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionRequest").add("CatalogId", catalogId()).add("Name", name())
                .add("HidePassword", hidePassword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "HidePassword":
            return Optional.ofNullable(clazz.cast(hidePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionRequest, T> g) {
        return obj -> g.apply((GetConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectionRequest> {
        /**
         * <p>
         * The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
         * account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web
         *        Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the connection definition to retrieve.
         * </p>
         * 
         * @param name
         *        The name of the connection definition to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue
         * console uses this flag to retrieve the connection, and does not display the password. Set this parameter when
         * the caller might not have permission to use the KMS key to decrypt the password, but it does have permission
         * to access the rest of the connection properties.
         * </p>
         * 
         * @param hidePassword
         *        Allows you to retrieve the connection metadata without returning the password. For instance, the AWS
         *        Glue console uses this flag to retrieve the connection, and does not display the password. Set this
         *        parameter when the caller might not have permission to use the KMS key to decrypt the password, but it
         *        does have permission to access the rest of the connection properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hidePassword(Boolean hidePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String name;

        private Boolean hidePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionRequest model) {
            super(model);
            catalogId(model.catalogId);
            name(model.name);
            hidePassword(model.hidePassword);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getHidePassword() {
            return hidePassword;
        }

        @Override
        public final Builder hidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
            return this;
        }

        public final void setHidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectionRequest build() {
            return new GetConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
