/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobRunsResponse extends GlueResponse implements
        ToCopyableBuilder<GetJobRunsResponse.Builder, GetJobRunsResponse> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField
            .<List<JobRun>> builder(MarshallingType.LIST)
            .memberName("JobRuns")
            .getter(getter(GetJobRunsResponse::jobRuns))
            .setter(setter(Builder::jobRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetJobRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JobRun> jobRuns;

    private final String nextToken;

    private GetJobRunsResponse(BuilderImpl builder) {
        super(builder);
        this.jobRuns = builder.jobRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the JobRuns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobRuns() {
        return jobRuns != null && !(jobRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job-run metadata objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of job-run metadata objects.
     */
    public final List<JobRun> jobRuns() {
        return jobRuns;
    }

    /**
     * <p>
     * A continuation token, if not all requested job runs have been returned.
     * </p>
     * 
     * @return A continuation token, if not all requested job runs have been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobRuns() ? jobRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunsResponse)) {
            return false;
        }
        GetJobRunsResponse other = (GetJobRunsResponse) obj;
        return hasJobRuns() == other.hasJobRuns() && Objects.equals(jobRuns(), other.jobRuns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobRunsResponse").add("JobRuns", hasJobRuns() ? jobRuns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobRuns":
            return Optional.ofNullable(clazz.cast(jobRuns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunsResponse, T> g) {
        return obj -> g.apply((GetJobRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobRunsResponse> {
        /**
         * <p>
         * A list of job-run metadata objects.
         * </p>
         * 
         * @param jobRuns
         *        A list of job-run metadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(Collection<JobRun> jobRuns);

        /**
         * <p>
         * A list of job-run metadata objects.
         * </p>
         * 
         * @param jobRuns
         *        A list of job-run metadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(JobRun... jobRuns);

        /**
         * <p>
         * A list of job-run metadata objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobRun>.Builder} avoiding the need to
         * create one manually via {@link List<JobRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRuns(List<JobRun>)}.
         * 
         * @param jobRuns
         *        a consumer that will call methods on {@link List<JobRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRuns(List<JobRun>)
         */
        Builder jobRuns(Consumer<JobRun.Builder>... jobRuns);

        /**
         * <p>
         * A continuation token, if not all requested job runs have been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all requested job runs have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunsResponse model) {
            super(model);
            jobRuns(model.jobRuns);
            nextToken(model.nextToken);
        }

        public final List<JobRun.Builder> getJobRuns() {
            List<JobRun.Builder> result = JobRunListCopier.copyToBuilder(this.jobRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun... jobRuns) {
            jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder>... jobRuns) {
            jobRuns(Stream.of(jobRuns).map(c -> JobRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetJobRunsResponse build() {
            return new GetJobRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
