/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A descriptor for a partition index in a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionIndexDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<PartitionIndexDescriptor.Builder, PartitionIndexDescriptor> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(PartitionIndexDescriptor::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEYS_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(PartitionIndexDescriptor::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(PartitionIndexDescriptor::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<List<BackfillError>> BACKFILL_ERRORS_FIELD = SdkField
            .<List<BackfillError>> builder(MarshallingType.LIST)
            .memberName("BackfillErrors")
            .getter(getter(PartitionIndexDescriptor::backfillErrors))
            .setter(setter(Builder::backfillErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackfillError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackfillError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, KEYS_FIELD,
            INDEX_STATUS_FIELD, BACKFILL_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final List<KeySchemaElement> keys;

    private final String indexStatus;

    private final List<BackfillError> backfillErrors;

    private PartitionIndexDescriptor(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keys = builder.keys;
        this.indexStatus = builder.indexStatus;
        this.backfillErrors = builder.backfillErrors;
    }

    /**
     * <p>
     * The name of the partition index.
     * </p>
     * 
     * @return The name of the partition index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
     */
    public final List<KeySchemaElement> keys() {
        return keys;
    }

    /**
     * <p>
     * The status of the partition index.
     * </p>
     * <p>
     * The possible statuses are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The index creation succeeds.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: The index creation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The index is deleted from the list of indexes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link PartitionIndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The status of the partition index. </p>
     *         <p>
     *         The possible statuses are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot
     *         be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The index creation succeeds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: The index creation fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The index is deleted from the list of indexes.
     *         </p>
     *         </li>
     * @see PartitionIndexStatus
     */
    public final PartitionIndexStatus indexStatus() {
        return PartitionIndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * The status of the partition index.
     * </p>
     * <p>
     * The possible statuses are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The index creation succeeds.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: The index creation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The index is deleted from the list of indexes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link PartitionIndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The status of the partition index. </p>
     *         <p>
     *         The possible statuses are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot
     *         be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The index creation succeeds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: The index creation fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The index is deleted from the list of indexes.
     *         </p>
     *         </li>
     * @see PartitionIndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * Returns true if the BackfillErrors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBackfillErrors() {
        return backfillErrors != null && !(backfillErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that can occur when registering partition indexes for an existing table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackfillErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of errors that can occur when registering partition indexes for an existing table.
     */
    public final List<BackfillError> backfillErrors() {
        return backfillErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackfillErrors() ? backfillErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndexDescriptor)) {
            return false;
        }
        PartitionIndexDescriptor other = (PartitionIndexDescriptor) obj;
        return Objects.equals(indexName(), other.indexName()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && hasBackfillErrors() == other.hasBackfillErrors() && Objects.equals(backfillErrors(), other.backfillErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartitionIndexDescriptor").add("IndexName", indexName()).add("Keys", hasKeys() ? keys() : null)
                .add("IndexStatus", indexStatusAsString()).add("BackfillErrors", hasBackfillErrors() ? backfillErrors() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "BackfillErrors":
            return Optional.ofNullable(clazz.cast(backfillErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionIndexDescriptor, T> g) {
        return obj -> g.apply((PartitionIndexDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionIndexDescriptor> {
        /**
         * <p>
         * The name of the partition index.
         * </p>
         * 
         * @param indexName
         *        The name of the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * 
         * @param keys
         *        A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<KeySchemaElement> keys);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * 
         * @param keys
         *        A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(KeySchemaElement... keys);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeySchemaElement>.Builder} avoiding the
         * need to create one manually via {@link List<KeySchemaElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeySchemaElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #keys(List<KeySchemaElement>)}.
         * 
         * @param keys
         *        a consumer that will call methods on {@link List<KeySchemaElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keys(List<KeySchemaElement>)
         */
        Builder keys(Consumer<KeySchemaElement.Builder>... keys);

        /**
         * <p>
         * The status of the partition index.
         * </p>
         * <p>
         * The possible statuses are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be
         * deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The index creation succeeds.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: The index creation fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The index is deleted from the list of indexes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The status of the partition index. </p>
         *        <p>
         *        The possible statuses are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The index is being created. When an index is in a CREATING state, the index or its table
         *        cannot be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The index creation succeeds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: The index creation fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The index is deleted from the list of indexes.
         *        </p>
         *        </li>
         * @see PartitionIndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionIndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The status of the partition index.
         * </p>
         * <p>
         * The possible statuses are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be
         * deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The index creation succeeds.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: The index creation fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The index is deleted from the list of indexes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The status of the partition index. </p>
         *        <p>
         *        The possible statuses are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The index is being created. When an index is in a CREATING state, the index or its table
         *        cannot be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The index creation succeeds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: The index creation fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The index is deleted from the list of indexes.
         *        </p>
         *        </li>
         * @see PartitionIndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionIndexStatus
         */
        Builder indexStatus(PartitionIndexStatus indexStatus);

        /**
         * <p>
         * A list of errors that can occur when registering partition indexes for an existing table.
         * </p>
         * 
         * @param backfillErrors
         *        A list of errors that can occur when registering partition indexes for an existing table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfillErrors(Collection<BackfillError> backfillErrors);

        /**
         * <p>
         * A list of errors that can occur when registering partition indexes for an existing table.
         * </p>
         * 
         * @param backfillErrors
         *        A list of errors that can occur when registering partition indexes for an existing table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfillErrors(BackfillError... backfillErrors);

        /**
         * <p>
         * A list of errors that can occur when registering partition indexes for an existing table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackfillError>.Builder} avoiding the need
         * to create one manually via {@link List<BackfillError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackfillError>.Builder#build()} is called immediately and
         * its result is passed to {@link #backfillErrors(List<BackfillError>)}.
         * 
         * @param backfillErrors
         *        a consumer that will call methods on {@link List<BackfillError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backfillErrors(List<BackfillError>)
         */
        Builder backfillErrors(Consumer<BackfillError.Builder>... backfillErrors);
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private List<KeySchemaElement> keys = DefaultSdkAutoConstructList.getInstance();

        private String indexStatus;

        private List<BackfillError> backfillErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionIndexDescriptor model) {
            indexName(model.indexName);
            keys(model.keys);
            indexStatus(model.indexStatus);
            backfillErrors(model.backfillErrors);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final List<KeySchemaElement.Builder> getKeys() {
            List<KeySchemaElement.Builder> result = KeySchemaElementListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder keys(Collection<KeySchemaElement> keys) {
            this.keys = KeySchemaElementListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(KeySchemaElement... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<KeySchemaElement.Builder>... keys) {
            keys(Stream.of(keys).map(c -> KeySchemaElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeys(Collection<KeySchemaElement.BuilderImpl> keys) {
            this.keys = KeySchemaElementListCopier.copyFromBuilder(keys);
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(PartitionIndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final List<BackfillError.Builder> getBackfillErrors() {
            List<BackfillError.Builder> result = BackfillErrorsCopier.copyToBuilder(this.backfillErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder backfillErrors(Collection<BackfillError> backfillErrors) {
            this.backfillErrors = BackfillErrorsCopier.copy(backfillErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backfillErrors(BackfillError... backfillErrors) {
            backfillErrors(Arrays.asList(backfillErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backfillErrors(Consumer<BackfillError.Builder>... backfillErrors) {
            backfillErrors(Stream.of(backfillErrors).map(c -> BackfillError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBackfillErrors(Collection<BackfillError.BuilderImpl> backfillErrors) {
            this.backfillErrors = BackfillErrorsCopier.copyFromBuilder(backfillErrors);
        }

        @Override
        public PartitionIndexDescriptor build() {
            return new PartitionIndexDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
