/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the physical storage of table data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageDescriptor.Builder, StorageDescriptor> {
    private static final SdkField<List<Column>> COLUMNS_FIELD = SdkField
            .<List<Column>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(StorageDescriptor::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Column> builder(MarshallingType.SDK_POJO)
                                            .constructor(Column::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(StorageDescriptor::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(StorageDescriptor::inputFormat)).setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(StorageDescriptor::outputFormat)).setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<Boolean> COMPRESSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Compressed").getter(getter(StorageDescriptor::compressed)).setter(setter(Builder::compressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compressed").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BUCKETS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBuckets").getter(getter(StorageDescriptor::numberOfBuckets))
            .setter(setter(Builder::numberOfBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBuckets").build()).build();

    private static final SdkField<SerDeInfo> SERDE_INFO_FIELD = SdkField.<SerDeInfo> builder(MarshallingType.SDK_POJO)
            .memberName("SerdeInfo").getter(getter(StorageDescriptor::serdeInfo)).setter(setter(Builder::serdeInfo))
            .constructor(SerDeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerdeInfo").build()).build();

    private static final SdkField<List<String>> BUCKET_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BucketColumns")
            .getter(getter(StorageDescriptor::bucketColumns))
            .setter(setter(Builder::bucketColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Order>> SORT_COLUMNS_FIELD = SdkField
            .<List<Order>> builder(MarshallingType.LIST)
            .memberName("SortColumns")
            .getter(getter(StorageDescriptor::sortColumns))
            .setter(setter(Builder::sortColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Order> builder(MarshallingType.SDK_POJO)
                                            .constructor(Order::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(StorageDescriptor::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SkewedInfo> SKEWED_INFO_FIELD = SdkField.<SkewedInfo> builder(MarshallingType.SDK_POJO)
            .memberName("SkewedInfo").getter(getter(StorageDescriptor::skewedInfo)).setter(setter(Builder::skewedInfo))
            .constructor(SkewedInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedInfo").build()).build();

    private static final SdkField<Boolean> STORED_AS_SUB_DIRECTORIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StoredAsSubDirectories").getter(getter(StorageDescriptor::storedAsSubDirectories))
            .setter(setter(Builder::storedAsSubDirectories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredAsSubDirectories").build())
            .build();

    private static final SdkField<SchemaReference> SCHEMA_REFERENCE_FIELD = SdkField
            .<SchemaReference> builder(MarshallingType.SDK_POJO).memberName("SchemaReference")
            .getter(getter(StorageDescriptor::schemaReference)).setter(setter(Builder::schemaReference))
            .constructor(SchemaReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, LOCATION_FIELD,
            INPUT_FORMAT_FIELD, OUTPUT_FORMAT_FIELD, COMPRESSED_FIELD, NUMBER_OF_BUCKETS_FIELD, SERDE_INFO_FIELD,
            BUCKET_COLUMNS_FIELD, SORT_COLUMNS_FIELD, PARAMETERS_FIELD, SKEWED_INFO_FIELD, STORED_AS_SUB_DIRECTORIES_FIELD,
            SCHEMA_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Column> columns;

    private final String location;

    private final String inputFormat;

    private final String outputFormat;

    private final Boolean compressed;

    private final Integer numberOfBuckets;

    private final SerDeInfo serdeInfo;

    private final List<String> bucketColumns;

    private final List<Order> sortColumns;

    private final Map<String, String> parameters;

    private final SkewedInfo skewedInfo;

    private final Boolean storedAsSubDirectories;

    private final SchemaReference schemaReference;

    private StorageDescriptor(BuilderImpl builder) {
        this.columns = builder.columns;
        this.location = builder.location;
        this.inputFormat = builder.inputFormat;
        this.outputFormat = builder.outputFormat;
        this.compressed = builder.compressed;
        this.numberOfBuckets = builder.numberOfBuckets;
        this.serdeInfo = builder.serdeInfo;
        this.bucketColumns = builder.bucketColumns;
        this.sortColumns = builder.sortColumns;
        this.parameters = builder.parameters;
        this.skewedInfo = builder.skewedInfo;
        this.storedAsSubDirectories = builder.storedAsSubDirectories;
        this.schemaReference = builder.schemaReference;
    }

    /**
     * Returns true if the Columns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the <code>Columns</code> in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the <code>Columns</code> in the table.
     */
    public final List<Column> columns() {
        return columns;
    }

    /**
     * <p>
     * The physical location of the table. By default, this takes the form of the warehouse location, followed by the
     * database location in the warehouse, followed by the table name.
     * </p>
     * 
     * @return The physical location of the table. By default, this takes the form of the warehouse location, followed
     *         by the database location in the warehouse, followed by the table name.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a custom
     * format.
     * </p>
     * 
     * @return The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a
     *         custom format.
     */
    public final String inputFormat() {
        return inputFormat;
    }

    /**
     * <p>
     * The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code>, or
     * a custom format.
     * </p>
     * 
     * @return The output format: <code>SequenceFileOutputFormat</code> (binary), or
     *         <code>IgnoreKeyTextOutputFormat</code>, or a custom format.
     */
    public final String outputFormat() {
        return outputFormat;
    }

    /**
     * <p>
     * <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
     * </p>
     * 
     * @return <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
     */
    public final Boolean compressed() {
        return compressed;
    }

    /**
     * <p>
     * Must be specified if the table contains any dimension columns.
     * </p>
     * 
     * @return Must be specified if the table contains any dimension columns.
     */
    public final Integer numberOfBuckets() {
        return numberOfBuckets;
    }

    /**
     * <p>
     * The serialization/deserialization (SerDe) information.
     * </p>
     * 
     * @return The serialization/deserialization (SerDe) information.
     */
    public final SerDeInfo serdeInfo() {
        return serdeInfo;
    }

    /**
     * Returns true if the BucketColumns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBucketColumns() {
        return bucketColumns != null && !(bucketColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBucketColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    public final List<String> bucketColumns() {
        return bucketColumns;
    }

    /**
     * Returns true if the SortColumns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSortColumns() {
        return sortColumns != null && !(sortColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list specifying the sort order of each bucket in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSortColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list specifying the sort order of each bucket in the table.
     */
    public final List<Order> sortColumns() {
        return sortColumns;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The user-supplied properties in key-value form.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user-supplied properties in key-value form.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The information about values that appear frequently in a column (skewed values).
     * </p>
     * 
     * @return The information about values that appear frequently in a column (skewed values).
     */
    public final SkewedInfo skewedInfo() {
        return skewedInfo;
    }

    /**
     * <p>
     * <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
     * </p>
     * 
     * @return <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
     */
    public final Boolean storedAsSubDirectories() {
        return storedAsSubDirectories;
    }

    /**
     * <p>
     * An object that references a schema stored in the Glue Schema Registry.
     * </p>
     * <p>
     * When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference.
     * </p>
     * 
     * @return An object that references a schema stored in the Glue Schema Registry.</p>
     *         <p>
     *         When creating a table, you can pass an empty list of columns for the schema, and instead use a schema
     *         reference.
     */
    public final SchemaReference schemaReference() {
        return schemaReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(compressed());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(serdeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasBucketColumns() ? bucketColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSortColumns() ? sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(skewedInfo());
        hashCode = 31 * hashCode + Objects.hashCode(storedAsSubDirectories());
        hashCode = 31 * hashCode + Objects.hashCode(schemaReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageDescriptor)) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor) obj;
        return hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns())
                && Objects.equals(location(), other.location()) && Objects.equals(inputFormat(), other.inputFormat())
                && Objects.equals(outputFormat(), other.outputFormat()) && Objects.equals(compressed(), other.compressed())
                && Objects.equals(numberOfBuckets(), other.numberOfBuckets()) && Objects.equals(serdeInfo(), other.serdeInfo())
                && hasBucketColumns() == other.hasBucketColumns() && Objects.equals(bucketColumns(), other.bucketColumns())
                && hasSortColumns() == other.hasSortColumns() && Objects.equals(sortColumns(), other.sortColumns())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(skewedInfo(), other.skewedInfo())
                && Objects.equals(storedAsSubDirectories(), other.storedAsSubDirectories())
                && Objects.equals(schemaReference(), other.schemaReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageDescriptor").add("Columns", hasColumns() ? columns() : null).add("Location", location())
                .add("InputFormat", inputFormat()).add("OutputFormat", outputFormat()).add("Compressed", compressed())
                .add("NumberOfBuckets", numberOfBuckets()).add("SerdeInfo", serdeInfo())
                .add("BucketColumns", hasBucketColumns() ? bucketColumns() : null)
                .add("SortColumns", hasSortColumns() ? sortColumns() : null)
                .add("Parameters", hasParameters() ? parameters() : null).add("SkewedInfo", skewedInfo())
                .add("StoredAsSubDirectories", storedAsSubDirectories()).add("SchemaReference", schemaReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormat()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormat()));
        case "Compressed":
            return Optional.ofNullable(clazz.cast(compressed()));
        case "NumberOfBuckets":
            return Optional.ofNullable(clazz.cast(numberOfBuckets()));
        case "SerdeInfo":
            return Optional.ofNullable(clazz.cast(serdeInfo()));
        case "BucketColumns":
            return Optional.ofNullable(clazz.cast(bucketColumns()));
        case "SortColumns":
            return Optional.ofNullable(clazz.cast(sortColumns()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "SkewedInfo":
            return Optional.ofNullable(clazz.cast(skewedInfo()));
        case "StoredAsSubDirectories":
            return Optional.ofNullable(clazz.cast(storedAsSubDirectories()));
        case "SchemaReference":
            return Optional.ofNullable(clazz.cast(schemaReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageDescriptor, T> g) {
        return obj -> g.apply((StorageDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageDescriptor> {
        /**
         * <p>
         * A list of the <code>Columns</code> in the table.
         * </p>
         * 
         * @param columns
         *        A list of the <code>Columns</code> in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<Column> columns);

        /**
         * <p>
         * A list of the <code>Columns</code> in the table.
         * </p>
         * 
         * @param columns
         *        A list of the <code>Columns</code> in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Column... columns);

        /**
         * <p>
         * A list of the <code>Columns</code> in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Column>.Builder} avoiding the need to
         * create one manually via {@link List<Column>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Column>.Builder#build()} is called immediately and its
         * result is passed to {@link #columns(List<Column>)}.
         * 
         * @param columns
         *        a consumer that will call methods on {@link List<Column>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(List<Column>)
         */
        Builder columns(Consumer<Column.Builder>... columns);

        /**
         * <p>
         * The physical location of the table. By default, this takes the form of the warehouse location, followed by
         * the database location in the warehouse, followed by the table name.
         * </p>
         * 
         * @param location
         *        The physical location of the table. By default, this takes the form of the warehouse location,
         *        followed by the database location in the warehouse, followed by the table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a custom
         * format.
         * </p>
         * 
         * @param inputFormat
         *        The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a
         *        custom format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code>,
         * or a custom format.
         * </p>
         * 
         * @param outputFormat
         *        The output format: <code>SequenceFileOutputFormat</code> (binary), or
         *        <code>IgnoreKeyTextOutputFormat</code>, or a custom format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
         * </p>
         * 
         * @param compressed
         *        <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compressed(Boolean compressed);

        /**
         * <p>
         * Must be specified if the table contains any dimension columns.
         * </p>
         * 
         * @param numberOfBuckets
         *        Must be specified if the table contains any dimension columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBuckets(Integer numberOfBuckets);

        /**
         * <p>
         * The serialization/deserialization (SerDe) information.
         * </p>
         * 
         * @param serdeInfo
         *        The serialization/deserialization (SerDe) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serdeInfo(SerDeInfo serdeInfo);

        /**
         * <p>
         * The serialization/deserialization (SerDe) information.
         * </p>
         * This is a convenience that creates an instance of the {@link SerDeInfo.Builder} avoiding the need to create
         * one manually via {@link SerDeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link SerDeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #serdeInfo(SerDeInfo)}.
         * 
         * @param serdeInfo
         *        a consumer that will call methods on {@link SerDeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serdeInfo(SerDeInfo)
         */
        default Builder serdeInfo(Consumer<SerDeInfo.Builder> serdeInfo) {
            return serdeInfo(SerDeInfo.builder().applyMutation(serdeInfo).build());
        }

        /**
         * <p>
         * A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
         * </p>
         * 
         * @param bucketColumns
         *        A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketColumns(Collection<String> bucketColumns);

        /**
         * <p>
         * A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
         * </p>
         * 
         * @param bucketColumns
         *        A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketColumns(String... bucketColumns);

        /**
         * <p>
         * A list specifying the sort order of each bucket in the table.
         * </p>
         * 
         * @param sortColumns
         *        A list specifying the sort order of each bucket in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(Collection<Order> sortColumns);

        /**
         * <p>
         * A list specifying the sort order of each bucket in the table.
         * </p>
         * 
         * @param sortColumns
         *        A list specifying the sort order of each bucket in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(Order... sortColumns);

        /**
         * <p>
         * A list specifying the sort order of each bucket in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Order>.Builder} avoiding the need to create
         * one manually via {@link List<Order>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Order>.Builder#build()} is called immediately and its result
         * is passed to {@link #sortColumns(List<Order>)}.
         * 
         * @param sortColumns
         *        a consumer that will call methods on {@link List<Order>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortColumns(List<Order>)
         */
        Builder sortColumns(Consumer<Order.Builder>... sortColumns);

        /**
         * <p>
         * The user-supplied properties in key-value form.
         * </p>
         * 
         * @param parameters
         *        The user-supplied properties in key-value form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The information about values that appear frequently in a column (skewed values).
         * </p>
         * 
         * @param skewedInfo
         *        The information about values that appear frequently in a column (skewed values).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedInfo(SkewedInfo skewedInfo);

        /**
         * <p>
         * The information about values that appear frequently in a column (skewed values).
         * </p>
         * This is a convenience that creates an instance of the {@link SkewedInfo.Builder} avoiding the need to create
         * one manually via {@link SkewedInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link SkewedInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #skewedInfo(SkewedInfo)}.
         * 
         * @param skewedInfo
         *        a consumer that will call methods on {@link SkewedInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skewedInfo(SkewedInfo)
         */
        default Builder skewedInfo(Consumer<SkewedInfo.Builder> skewedInfo) {
            return skewedInfo(SkewedInfo.builder().applyMutation(skewedInfo).build());
        }

        /**
         * <p>
         * <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
         * </p>
         * 
         * @param storedAsSubDirectories
         *        <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedAsSubDirectories(Boolean storedAsSubDirectories);

        /**
         * <p>
         * An object that references a schema stored in the Glue Schema Registry.
         * </p>
         * <p>
         * When creating a table, you can pass an empty list of columns for the schema, and instead use a schema
         * reference.
         * </p>
         * 
         * @param schemaReference
         *        An object that references a schema stored in the Glue Schema Registry.</p>
         *        <p>
         *        When creating a table, you can pass an empty list of columns for the schema, and instead use a schema
         *        reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaReference(SchemaReference schemaReference);

        /**
         * <p>
         * An object that references a schema stored in the Glue Schema Registry.
         * </p>
         * <p>
         * When creating a table, you can pass an empty list of columns for the schema, and instead use a schema
         * reference.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaReference.Builder} avoiding the need to
         * create one manually via {@link SchemaReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaReference.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaReference(SchemaReference)}.
         * 
         * @param schemaReference
         *        a consumer that will call methods on {@link SchemaReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaReference(SchemaReference)
         */
        default Builder schemaReference(Consumer<SchemaReference.Builder> schemaReference) {
            return schemaReference(SchemaReference.builder().applyMutation(schemaReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Column> columns = DefaultSdkAutoConstructList.getInstance();

        private String location;

        private String inputFormat;

        private String outputFormat;

        private Boolean compressed;

        private Integer numberOfBuckets;

        private SerDeInfo serdeInfo;

        private List<String> bucketColumns = DefaultSdkAutoConstructList.getInstance();

        private List<Order> sortColumns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private SkewedInfo skewedInfo;

        private Boolean storedAsSubDirectories;

        private SchemaReference schemaReference;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageDescriptor model) {
            columns(model.columns);
            location(model.location);
            inputFormat(model.inputFormat);
            outputFormat(model.outputFormat);
            compressed(model.compressed);
            numberOfBuckets(model.numberOfBuckets);
            serdeInfo(model.serdeInfo);
            bucketColumns(model.bucketColumns);
            sortColumns(model.sortColumns);
            parameters(model.parameters);
            skewedInfo(model.skewedInfo);
            storedAsSubDirectories(model.storedAsSubDirectories);
            schemaReference(model.schemaReference);
        }

        public final List<Column.Builder> getColumns() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Column... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<Column.Builder>... columns) {
            columns(Stream.of(columns).map(c -> Column.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final Boolean getCompressed() {
            return compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        public final Integer getNumberOfBuckets() {
            return numberOfBuckets;
        }

        @Override
        public final Builder numberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
            return this;
        }

        public final void setNumberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
        }

        public final SerDeInfo.Builder getSerdeInfo() {
            return serdeInfo != null ? serdeInfo.toBuilder() : null;
        }

        @Override
        public final Builder serdeInfo(SerDeInfo serdeInfo) {
            this.serdeInfo = serdeInfo;
            return this;
        }

        public final void setSerdeInfo(SerDeInfo.BuilderImpl serdeInfo) {
            this.serdeInfo = serdeInfo != null ? serdeInfo.build() : null;
        }

        public final Collection<String> getBucketColumns() {
            if (bucketColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return bucketColumns;
        }

        @Override
        public final Builder bucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketColumns(String... bucketColumns) {
            bucketColumns(Arrays.asList(bucketColumns));
            return this;
        }

        public final void setBucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
        }

        public final List<Order.Builder> getSortColumns() {
            List<Order.Builder> result = OrderListCopier.copyToBuilder(this.sortColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sortColumns(Collection<Order> sortColumns) {
            this.sortColumns = OrderListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(Order... sortColumns) {
            sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(Consumer<Order.Builder>... sortColumns) {
            sortColumns(Stream.of(sortColumns).map(c -> Order.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortColumns(Collection<Order.BuilderImpl> sortColumns) {
            this.sortColumns = OrderListCopier.copyFromBuilder(sortColumns);
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final SkewedInfo.Builder getSkewedInfo() {
            return skewedInfo != null ? skewedInfo.toBuilder() : null;
        }

        @Override
        public final Builder skewedInfo(SkewedInfo skewedInfo) {
            this.skewedInfo = skewedInfo;
            return this;
        }

        public final void setSkewedInfo(SkewedInfo.BuilderImpl skewedInfo) {
            this.skewedInfo = skewedInfo != null ? skewedInfo.build() : null;
        }

        public final Boolean getStoredAsSubDirectories() {
            return storedAsSubDirectories;
        }

        @Override
        public final Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        public final void setStoredAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
        }

        public final SchemaReference.Builder getSchemaReference() {
            return schemaReference != null ? schemaReference.toBuilder() : null;
        }

        @Override
        public final Builder schemaReference(SchemaReference schemaReference) {
            this.schemaReference = schemaReference;
            return this;
        }

        public final void setSchemaReference(SchemaReference.BuilderImpl schemaReference) {
            this.schemaReference = schemaReference != null ? schemaReference.build() : null;
        }

        @Override
        public StorageDescriptor build() {
            return new StorageDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
