/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateConnectionRequest.Builder, UpdateConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateConnectionRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConnectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ConnectionInput> CONNECTION_INPUT_FIELD = SdkField
            .<ConnectionInput> builder(MarshallingType.SDK_POJO).memberName("ConnectionInput")
            .getter(getter(UpdateConnectionRequest::connectionInput)).setter(setter(Builder::connectionInput))
            .constructor(ConnectionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NAME_FIELD,
            CONNECTION_INPUT_FIELD));

    private final String catalogId;

    private final String name;

    private final ConnectionInput connectionInput;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.connectionInput = builder.connectionInput;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services account
     * ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
     *         account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the connection definition to update.
     * </p>
     * 
     * @return The name of the connection definition to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A <code>ConnectionInput</code> object that redefines the connection in question.
     * </p>
     * 
     * @return A <code>ConnectionInput</code> object that redefines the connection in question.
     */
    public final ConnectionInput connectionInput() {
        return connectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(name(), other.name())
                && Objects.equals(connectionInput(), other.connectionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionRequest").add("CatalogId", catalogId()).add("Name", name())
                .add("ConnectionInput", connectionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ConnectionInput":
            return Optional.ofNullable(clazz.cast(connectionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectionRequest> {
        /**
         * <p>
         * The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
         * account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web
         *        Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the connection definition to update.
         * </p>
         * 
         * @param name
         *        The name of the connection definition to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <code>ConnectionInput</code> object that redefines the connection in question.
         * </p>
         * 
         * @param connectionInput
         *        A <code>ConnectionInput</code> object that redefines the connection in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionInput(ConnectionInput connectionInput);

        /**
         * <p>
         * A <code>ConnectionInput</code> object that redefines the connection in question.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionInput.Builder} avoiding the need to
         * create one manually via {@link ConnectionInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionInput.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionInput(ConnectionInput)}.
         * 
         * @param connectionInput
         *        a consumer that will call methods on {@link ConnectionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionInput(ConnectionInput)
         */
        default Builder connectionInput(Consumer<ConnectionInput.Builder> connectionInput) {
            return connectionInput(ConnectionInput.builder().applyMutation(connectionInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String name;

        private ConnectionInput connectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            super(model);
            catalogId(model.catalogId);
            name(model.name);
            connectionInput(model.connectionInput);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConnectionInput.Builder getConnectionInput() {
            return connectionInput != null ? connectionInput.toBuilder() : null;
        }

        @Override
        public final Builder connectionInput(ConnectionInput connectionInput) {
            this.connectionInput = connectionInput;
            return this;
        }

        public final void setConnectionInput(ConnectionInput.BuilderImpl connectionInput) {
            this.connectionInput = connectionInput != null ? connectionInput.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
