/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workflow graph represents the complete workflow containing all the Glue components present in the workflow and all
 * the directed connections between them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowGraph implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowGraph.Builder, WorkflowGraph> {
    private static final SdkField<List<Node>> NODES_FIELD = SdkField
            .<List<Node>> builder(MarshallingType.LIST)
            .memberName("Nodes")
            .getter(getter(WorkflowGraph::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Node> builder(MarshallingType.SDK_POJO)
                                            .constructor(Node::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField
            .<List<Edge>> builder(MarshallingType.LIST)
            .memberName("Edges")
            .getter(getter(WorkflowGraph::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Edge> builder(MarshallingType.SDK_POJO)
                                            .constructor(Edge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODES_FIELD, EDGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Node> nodes;

    private final List<Edge> edges;

    private WorkflowGraph(BuilderImpl builder) {
        this.nodes = builder.nodes;
        this.edges = builder.edges;
    }

    /**
     * Returns true if the Nodes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the the Glue components belong to the workflow represented as nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the the Glue components belong to the workflow represented as nodes.
     */
    public final List<Node> nodes() {
        return nodes;
    }

    /**
     * Returns true if the Edges property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the directed connections between the nodes belonging to the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEdges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the directed connections between the nodes belonging to the workflow.
     */
    public final List<Edge> edges() {
        return edges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEdges() ? edges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowGraph)) {
            return false;
        }
        WorkflowGraph other = (WorkflowGraph) obj;
        return hasNodes() == other.hasNodes() && Objects.equals(nodes(), other.nodes()) && hasEdges() == other.hasEdges()
                && Objects.equals(edges(), other.edges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowGraph").add("Nodes", hasNodes() ? nodes() : null)
                .add("Edges", hasEdges() ? edges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowGraph, T> g) {
        return obj -> g.apply((WorkflowGraph) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowGraph> {
        /**
         * <p>
         * A list of the the Glue components belong to the workflow represented as nodes.
         * </p>
         * 
         * @param nodes
         *        A list of the the Glue components belong to the workflow represented as nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<Node> nodes);

        /**
         * <p>
         * A list of the the Glue components belong to the workflow represented as nodes.
         * </p>
         * 
         * @param nodes
         *        A list of the the Glue components belong to the workflow represented as nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Node... nodes);

        /**
         * <p>
         * A list of the the Glue components belong to the workflow represented as nodes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Node>.Builder} avoiding the need to create
         * one manually via {@link List<Node>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Node>.Builder#build()} is called immediately and its result
         * is passed to {@link #nodes(List<Node>)}.
         * 
         * @param nodes
         *        a consumer that will call methods on {@link List<Node>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodes(List<Node>)
         */
        Builder nodes(Consumer<Node.Builder>... nodes);

        /**
         * <p>
         * A list of all the directed connections between the nodes belonging to the workflow.
         * </p>
         * 
         * @param edges
         *        A list of all the directed connections between the nodes belonging to the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<Edge> edges);

        /**
         * <p>
         * A list of all the directed connections between the nodes belonging to the workflow.
         * </p>
         * 
         * @param edges
         *        A list of all the directed connections between the nodes belonging to the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Edge... edges);

        /**
         * <p>
         * A list of all the directed connections between the nodes belonging to the workflow.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Edge>.Builder} avoiding the need to create
         * one manually via {@link List<Edge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Edge>.Builder#build()} is called immediately and its result
         * is passed to {@link #edges(List<Edge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on {@link List<Edge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(List<Edge>)
         */
        Builder edges(Consumer<Edge.Builder>... edges);
    }

    static final class BuilderImpl implements Builder {
        private List<Node> nodes = DefaultSdkAutoConstructList.getInstance();

        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowGraph model) {
            nodes(model.nodes);
            edges(model.edges);
        }

        public final List<Node.Builder> getNodes() {
            List<Node.Builder> result = NodeListCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<Node.Builder>... nodes) {
            nodes(Stream.of(nodes).map(c -> Node.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodes(Collection<Node.BuilderImpl> nodes) {
            this.nodes = NodeListCopier.copyFromBuilder(nodes);
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> Edge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        public WorkflowGraph build() {
            return new WorkflowGraph(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
