/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Workflow run statistics provides statistics about the workflow run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowRunStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowRunStatistics.Builder, WorkflowRunStatistics> {
    private static final SdkField<Integer> TOTAL_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalActions").getter(getter(WorkflowRunStatistics::totalActions)).setter(setter(Builder::totalActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActions").build()).build();

    private static final SdkField<Integer> TIMEOUT_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutActions").getter(getter(WorkflowRunStatistics::timeoutActions))
            .setter(setter(Builder::timeoutActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutActions").build()).build();

    private static final SdkField<Integer> FAILED_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedActions").getter(getter(WorkflowRunStatistics::failedActions))
            .setter(setter(Builder::failedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedActions").build()).build();

    private static final SdkField<Integer> STOPPED_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StoppedActions").getter(getter(WorkflowRunStatistics::stoppedActions))
            .setter(setter(Builder::stoppedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build()).build();

    private static final SdkField<Integer> SUCCEEDED_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SucceededActions").getter(getter(WorkflowRunStatistics::succeededActions))
            .setter(setter(Builder::succeededActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SucceededActions").build()).build();

    private static final SdkField<Integer> RUNNING_ACTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RunningActions").getter(getter(WorkflowRunStatistics::runningActions))
            .setter(setter(Builder::runningActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningActions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACTIONS_FIELD,
            TIMEOUT_ACTIONS_FIELD, FAILED_ACTIONS_FIELD, STOPPED_ACTIONS_FIELD, SUCCEEDED_ACTIONS_FIELD, RUNNING_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalActions;

    private final Integer timeoutActions;

    private final Integer failedActions;

    private final Integer stoppedActions;

    private final Integer succeededActions;

    private final Integer runningActions;

    private WorkflowRunStatistics(BuilderImpl builder) {
        this.totalActions = builder.totalActions;
        this.timeoutActions = builder.timeoutActions;
        this.failedActions = builder.failedActions;
        this.stoppedActions = builder.stoppedActions;
        this.succeededActions = builder.succeededActions;
        this.runningActions = builder.runningActions;
    }

    /**
     * <p>
     * Total number of Actions in the workflow run.
     * </p>
     * 
     * @return Total number of Actions in the workflow run.
     */
    public final Integer totalActions() {
        return totalActions;
    }

    /**
     * <p>
     * Total number of Actions that timed out.
     * </p>
     * 
     * @return Total number of Actions that timed out.
     */
    public final Integer timeoutActions() {
        return timeoutActions;
    }

    /**
     * <p>
     * Total number of Actions that have failed.
     * </p>
     * 
     * @return Total number of Actions that have failed.
     */
    public final Integer failedActions() {
        return failedActions;
    }

    /**
     * <p>
     * Total number of Actions that have stopped.
     * </p>
     * 
     * @return Total number of Actions that have stopped.
     */
    public final Integer stoppedActions() {
        return stoppedActions;
    }

    /**
     * <p>
     * Total number of Actions that have succeeded.
     * </p>
     * 
     * @return Total number of Actions that have succeeded.
     */
    public final Integer succeededActions() {
        return succeededActions;
    }

    /**
     * <p>
     * Total number Actions in running state.
     * </p>
     * 
     * @return Total number Actions in running state.
     */
    public final Integer runningActions() {
        return runningActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalActions());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutActions());
        hashCode = 31 * hashCode + Objects.hashCode(failedActions());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedActions());
        hashCode = 31 * hashCode + Objects.hashCode(succeededActions());
        hashCode = 31 * hashCode + Objects.hashCode(runningActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRunStatistics)) {
            return false;
        }
        WorkflowRunStatistics other = (WorkflowRunStatistics) obj;
        return Objects.equals(totalActions(), other.totalActions()) && Objects.equals(timeoutActions(), other.timeoutActions())
                && Objects.equals(failedActions(), other.failedActions())
                && Objects.equals(stoppedActions(), other.stoppedActions())
                && Objects.equals(succeededActions(), other.succeededActions())
                && Objects.equals(runningActions(), other.runningActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowRunStatistics").add("TotalActions", totalActions())
                .add("TimeoutActions", timeoutActions()).add("FailedActions", failedActions())
                .add("StoppedActions", stoppedActions()).add("SucceededActions", succeededActions())
                .add("RunningActions", runningActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalActions":
            return Optional.ofNullable(clazz.cast(totalActions()));
        case "TimeoutActions":
            return Optional.ofNullable(clazz.cast(timeoutActions()));
        case "FailedActions":
            return Optional.ofNullable(clazz.cast(failedActions()));
        case "StoppedActions":
            return Optional.ofNullable(clazz.cast(stoppedActions()));
        case "SucceededActions":
            return Optional.ofNullable(clazz.cast(succeededActions()));
        case "RunningActions":
            return Optional.ofNullable(clazz.cast(runningActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowRunStatistics, T> g) {
        return obj -> g.apply((WorkflowRunStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowRunStatistics> {
        /**
         * <p>
         * Total number of Actions in the workflow run.
         * </p>
         * 
         * @param totalActions
         *        Total number of Actions in the workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActions(Integer totalActions);

        /**
         * <p>
         * Total number of Actions that timed out.
         * </p>
         * 
         * @param timeoutActions
         *        Total number of Actions that timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutActions(Integer timeoutActions);

        /**
         * <p>
         * Total number of Actions that have failed.
         * </p>
         * 
         * @param failedActions
         *        Total number of Actions that have failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedActions(Integer failedActions);

        /**
         * <p>
         * Total number of Actions that have stopped.
         * </p>
         * 
         * @param stoppedActions
         *        Total number of Actions that have stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedActions(Integer stoppedActions);

        /**
         * <p>
         * Total number of Actions that have succeeded.
         * </p>
         * 
         * @param succeededActions
         *        Total number of Actions that have succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededActions(Integer succeededActions);

        /**
         * <p>
         * Total number Actions in running state.
         * </p>
         * 
         * @param runningActions
         *        Total number Actions in running state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningActions(Integer runningActions);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalActions;

        private Integer timeoutActions;

        private Integer failedActions;

        private Integer stoppedActions;

        private Integer succeededActions;

        private Integer runningActions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowRunStatistics model) {
            totalActions(model.totalActions);
            timeoutActions(model.timeoutActions);
            failedActions(model.failedActions);
            stoppedActions(model.stoppedActions);
            succeededActions(model.succeededActions);
            runningActions(model.runningActions);
        }

        public final Integer getTotalActions() {
            return totalActions;
        }

        @Override
        public final Builder totalActions(Integer totalActions) {
            this.totalActions = totalActions;
            return this;
        }

        public final void setTotalActions(Integer totalActions) {
            this.totalActions = totalActions;
        }

        public final Integer getTimeoutActions() {
            return timeoutActions;
        }

        @Override
        public final Builder timeoutActions(Integer timeoutActions) {
            this.timeoutActions = timeoutActions;
            return this;
        }

        public final void setTimeoutActions(Integer timeoutActions) {
            this.timeoutActions = timeoutActions;
        }

        public final Integer getFailedActions() {
            return failedActions;
        }

        @Override
        public final Builder failedActions(Integer failedActions) {
            this.failedActions = failedActions;
            return this;
        }

        public final void setFailedActions(Integer failedActions) {
            this.failedActions = failedActions;
        }

        public final Integer getStoppedActions() {
            return stoppedActions;
        }

        @Override
        public final Builder stoppedActions(Integer stoppedActions) {
            this.stoppedActions = stoppedActions;
            return this;
        }

        public final void setStoppedActions(Integer stoppedActions) {
            this.stoppedActions = stoppedActions;
        }

        public final Integer getSucceededActions() {
            return succeededActions;
        }

        @Override
        public final Builder succeededActions(Integer succeededActions) {
            this.succeededActions = succeededActions;
            return this;
        }

        public final void setSucceededActions(Integer succeededActions) {
            this.succeededActions = succeededActions;
        }

        public final Integer getRunningActions() {
            return runningActions;
        }

        @Override
        public final Builder runningActions(Integer runningActions) {
            this.runningActions = runningActions;
            return this;
        }

        public final void setRunningActions(Integer runningActions) {
            this.runningActions = runningActions;
        }

        @Override
        public WorkflowRunStatistics build() {
            return new WorkflowRunStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
