/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an action to be initiated by a trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(Action::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Arguments")
            .getter(getter(Action::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(Action::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(Action::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField
            .<NotificationProperty> builder(MarshallingType.SDK_POJO).memberName("NotificationProperty")
            .getter(getter(Action::notificationProperty)).setter(setter(Builder::notificationProperty))
            .constructor(NotificationProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build())
            .build();

    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerName").getter(getter(Action::crawlerName)).setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            ARGUMENTS_FIELD, TIMEOUT_FIELD, SECURITY_CONFIGURATION_FIELD, NOTIFICATION_PROPERTY_FIELD, CRAWLER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final Map<String, String> arguments;

    private final Integer timeout;

    private final String securityConfiguration;

    private final NotificationProperty notificationProperty;

    private final String crawlerName;

    private Action(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.arguments = builder.arguments;
        this.timeout = builder.timeout;
        this.securityConfiguration = builder.securityConfiguration;
        this.notificationProperty = builder.notificationProperty;
        this.crawlerName = builder.crawlerName;
    }

    /**
     * <p>
     * The name of a job to be run.
     * </p>
     * 
     * @return The name of a job to be run.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arguments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the
     * job definition itself.
     * </p>
     * <p>
     * You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue itself
     * consumes.
     * </p>
     * <p>
     * For information about how to specify and consume your own Job arguments, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in
     * Python</a> topic in the developer guide.
     * </p>
     * <p>
     * For information about the key-value pairs that Glue consumes to set up your job, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters
     * Used by Glue</a> topic in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArguments} method.
     * </p>
     * 
     * @return The job arguments used when this trigger fires. For this job run, they replace the default arguments set
     *         in the job definition itself.</p>
     *         <p>
     *         You can specify arguments here that your own job-execution script consumes, as well as arguments that
     *         Glue itself consumes.
     *         </p>
     *         <p>
     *         For information about how to specify and consume your own Job arguments, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue
     *         APIs in Python</a> topic in the developer guide.
     *         </p>
     *         <p>
     *         For information about the key-value pairs that Glue consumes to set up your job, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
     *         Parameters Used by Glue</a> topic in the developer guide.
     */
    public final Map<String, String> arguments() {
        return arguments;
    }

    /**
     * <p>
     * The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources before
     * it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This overrides
     * the timeout value set in the parent job.
     * </p>
     * 
     * @return The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources
     *         before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     *         This overrides the timeout value set in the parent job.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used with this action.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used with this action.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * Specifies configuration properties of a job run notification.
     * </p>
     * 
     * @return Specifies configuration properties of a job run notification.
     */
    public final NotificationProperty notificationProperty() {
        return notificationProperty;
    }

    /**
     * <p>
     * The name of the crawler to be used with this action.
     * </p>
     * 
     * @return The name of the crawler to be used with this action.
     */
    public final String crawlerName() {
        return crawlerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasArguments() ? arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(jobName(), other.jobName()) && hasArguments() == other.hasArguments()
                && Objects.equals(arguments(), other.arguments()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(notificationProperty(), other.notificationProperty())
                && Objects.equals(crawlerName(), other.crawlerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("JobName", jobName()).add("Arguments", hasArguments() ? arguments() : null)
                .add("Timeout", timeout()).add("SecurityConfiguration", securityConfiguration())
                .add("NotificationProperty", notificationProperty()).add("CrawlerName", crawlerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "NotificationProperty":
            return Optional.ofNullable(clazz.cast(notificationProperty()));
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The name of a job to be run.
         * </p>
         * 
         * @param jobName
         *        The name of a job to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job arguments used when this trigger fires. For this job run, they replace the default arguments set in
         * the job definition itself.
         * </p>
         * <p>
         * You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue
         * itself consumes.
         * </p>
         * <p>
         * For information about how to specify and consume your own Job arguments, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs
         * in Python</a> topic in the developer guide.
         * </p>
         * <p>
         * For information about the key-value pairs that Glue consumes to set up your job, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         * Parameters Used by Glue</a> topic in the developer guide.
         * </p>
         * 
         * @param arguments
         *        The job arguments used when this trigger fires. For this job run, they replace the default arguments
         *        set in the job definition itself.</p>
         *        <p>
         *        You can specify arguments here that your own job-execution script consumes, as well as arguments that
         *        Glue itself consumes.
         *        </p>
         *        <p>
         *        For information about how to specify and consume your own Job arguments, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling
         *        Glue APIs in Python</a> topic in the developer guide.
         *        </p>
         *        <p>
         *        For information about the key-value pairs that Glue consumes to set up your job, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         *        Parameters Used by Glue</a> topic in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);

        /**
         * <p>
         * The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources
         * before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This
         * overrides the timeout value set in the parent job.
         * </p>
         * 
         * @param timeout
         *        The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume
         *        resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes
         *        (48 hours). This overrides the timeout value set in the parent job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used with this action.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used with this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * Specifies configuration properties of a job run notification.
         * </p>
         * 
         * @param notificationProperty
         *        Specifies configuration properties of a job run notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationProperty(NotificationProperty notificationProperty);

        /**
         * <p>
         * Specifies configuration properties of a job run notification.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationProperty.Builder} avoiding the need
         * to create one manually via {@link NotificationProperty#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationProperty(NotificationProperty)}.
         * 
         * @param notificationProperty
         *        a consumer that will call methods on {@link NotificationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationProperty(NotificationProperty)
         */
        default Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return notificationProperty(NotificationProperty.builder().applyMutation(notificationProperty).build());
        }

        /**
         * <p>
         * The name of the crawler to be used with this action.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler to be used with this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeout;

        private String securityConfiguration;

        private NotificationProperty notificationProperty;

        private String crawlerName;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            jobName(model.jobName);
            arguments(model.arguments);
            timeout(model.timeout);
            securityConfiguration(model.securityConfiguration);
            notificationProperty(model.notificationProperty);
            crawlerName(model.crawlerName);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        @Override
        @Transient
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        @Transient
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return notificationProperty != null ? notificationProperty.toBuilder() : null;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        @Override
        @Transient
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
