/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that is used to specify a connection to create or update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionInput implements SdkPojo, Serializable, ToCopyableBuilder<ConnectionInput.Builder, ConnectionInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConnectionInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectionInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(ConnectionInput::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchCriteria")
            .getter(getter(ConnectionInput::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ConnectionProperties")
            .getter(getter(ConnectionInput::connectionPropertiesAsStrings))
            .setter(setter(Builder::connectionPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("PhysicalConnectionRequirements")
            .getter(getter(ConnectionInput::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String connectionType;

    private final List<String> matchCriteria;

    private final Map<String, String> connectionProperties;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private ConnectionInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connection.
     * </p>
     * 
     * @return The description of the connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the connection. Currently, these types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud
     * environment (Amazon VPC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data
     * stores that are not natively supported by Glue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, these types are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
     *         Cloud environment (Amazon VPC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     *         Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write
     *         to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         SFTP is not supported.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the connection. Currently, these types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud
     * environment (Amazon VPC).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data
     * stores that are not natively supported by Glue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, these types are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
     *         Cloud environment (Amazon VPC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     *         Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write
     *         to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         SFTP is not supported.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of criteria that can be used in selecting this connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchCriteria} method.
     * </p>
     * 
     * @return A list of criteria that can be used in selecting this connection.
     */
    public final List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(connectionProperties);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public final Map<String, String> connectionPropertiesAsStrings() {
        return connectionProperties;
    }

    /**
     * <p>
     * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
     * that are needed to successfully make this connection.
     * </p>
     * 
     * @return A map of physical connection requirements, such as virtual private cloud (VPC) and
     *         <code>SecurityGroup</code>, that are needed to successfully make this connection.
     */
    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchCriteria() ? matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInput)) {
            return false;
        }
        ConnectionInput other = (ConnectionInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(matchCriteria(), other.matchCriteria())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionInput").add("Name", name()).add("Description", description())
                .add("ConnectionType", connectionTypeAsString())
                .add("MatchCriteria", hasMatchCriteria() ? matchCriteria() : null)
                .add("ConnectionProperties", hasConnectionProperties() ? connectionPropertiesAsStrings() : null)
                .add("PhysicalConnectionRequirements", physicalConnectionRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionProperties":
            return Optional.ofNullable(clazz.cast(connectionPropertiesAsStrings()));
        case "PhysicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionInput, T> g) {
        return obj -> g.apply((ConnectionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionInput> {
        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param name
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connection.
         * </p>
         * 
         * @param description
         *        The description of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the connection. Currently, these types are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
         * Cloud environment (Amazon VPC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
         * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to
         * data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * </ul>
         * <p>
         * SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, these types are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual
         *        Private Cloud environment (Amazon VPC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon
         *        Web Services Marketplace to read from and write to data stores that are not natively supported by
         *        Glue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and
         *        write to data stores that are not natively supported by Glue.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the connection. Currently, these types are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
         * Cloud environment (Amazon VPC).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
         * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to
         * data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * </ul>
         * <p>
         * SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, these types are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual
         *        Private Cloud environment (Amazon VPC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon
         *        Web Services Marketplace to read from and write to data stores that are not natively supported by
         *        Glue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and
         *        write to data stores that are not natively supported by Glue.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties);

        /**
         * <p>
         * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>
         * , that are needed to successfully make this connection.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        A map of physical connection requirements, such as virtual private cloud (VPC) and
         *        <code>SecurityGroup</code>, that are needed to successfully make this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>
         * , that are needed to successfully make this connection.
         * </p>
         * This is a convenience that creates an instance of the {@link PhysicalConnectionRequirements.Builder} avoiding
         * the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String connectionType;

        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInput model) {
            name(model.name);
            description(model.description);
            connectionType(model.connectionType);
            matchCriteria(model.matchCriteria);
            connectionPropertiesWithStrings(model.connectionProperties);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        @Transient
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        @Transient
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        @Transient
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        @Transient
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        @Override
        public ConnectionInput build() {
            return new ConnectionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
