/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMappingRequest extends GlueRequest implements
        ToCopyableBuilder<GetMappingRequest.Builder, GetMappingRequest> {
    private static final SdkField<CatalogEntry> SOURCE_FIELD = SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(GetMappingRequest::source)).setter(setter(Builder::source))
            .constructor(CatalogEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<CatalogEntry>> SINKS_FIELD = SdkField
            .<List<CatalogEntry>> builder(MarshallingType.LIST)
            .memberName("Sinks")
            .getter(getter(GetMappingRequest::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(CatalogEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(GetMappingRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, SINKS_FIELD,
            LOCATION_FIELD));

    private final CatalogEntry source;

    private final List<CatalogEntry> sinks;

    private final Location location;

    private GetMappingRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
    }

    /**
     * <p>
     * Specifies the source table.
     * </p>
     * 
     * @return Specifies the source table.
     */
    public final CatalogEntry source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sinks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSinks} method.
     * </p>
     * 
     * @return A list of target tables.
     */
    public final List<CatalogEntry> sinks() {
        return sinks;
    }

    /**
     * <p>
     * Parameters for the mapping.
     * </p>
     * 
     * @return Parameters for the mapping.
     */
    public final Location location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasSinks() ? sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingRequest)) {
            return false;
        }
        GetMappingRequest other = (GetMappingRequest) obj;
        return Objects.equals(source(), other.source()) && hasSinks() == other.hasSinks()
                && Objects.equals(sinks(), other.sinks()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMappingRequest").add("Source", source()).add("Sinks", hasSinks() ? sinks() : null)
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMappingRequest, T> g) {
        return obj -> g.apply((GetMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMappingRequest> {
        /**
         * <p>
         * Specifies the source table.
         * </p>
         * 
         * @param source
         *        Specifies the source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CatalogEntry source);

        /**
         * <p>
         * Specifies the source table.
         * </p>
         * This is a convenience that creates an instance of the {@link CatalogEntry.Builder} avoiding the need to
         * create one manually via {@link CatalogEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link CatalogEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #source(CatalogEntry)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CatalogEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CatalogEntry)
         */
        default Builder source(Consumer<CatalogEntry.Builder> source) {
            return source(CatalogEntry.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * A list of target tables.
         * </p>
         * 
         * @param sinks
         *        A list of target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<CatalogEntry> sinks);

        /**
         * <p>
         * A list of target tables.
         * </p>
         * 
         * @param sinks
         *        A list of target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(CatalogEntry... sinks);

        /**
         * <p>
         * A list of target tables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CatalogEntry>.Builder} avoiding the need to
         * create one manually via {@link List<CatalogEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CatalogEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #sinks(List<CatalogEntry>)}.
         * 
         * @param sinks
         *        a consumer that will call methods on {@link List<CatalogEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sinks(List<CatalogEntry>)
         */
        Builder sinks(Consumer<CatalogEntry.Builder>... sinks);

        /**
         * <p>
         * Parameters for the mapping.
         * </p>
         * 
         * @param location
         *        Parameters for the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Parameters for the mapping.
         * </p>
         * This is a convenience that creates an instance of the {@link Location.Builder} avoiding the need to create
         * one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private CatalogEntry source;

        private List<CatalogEntry> sinks = DefaultSdkAutoConstructList.getInstance();

        private Location location;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMappingRequest model) {
            super(model);
            source(model.source);
            sinks(model.sinks);
            location(model.location);
        }

        public final CatalogEntry.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final List<CatalogEntry.Builder> getSinks() {
            List<CatalogEntry.Builder> result = CatalogEntriesCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        @Override
        @Transient
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sinks(CatalogEntry... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder>... sinks) {
            sinks(Stream.of(sinks).map(c -> CatalogEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMappingRequest build() {
            return new GetMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
