/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlTaskRunsRequest extends GlueRequest implements
        ToCopyableBuilder<GetMlTaskRunsRequest.Builder, GetMlTaskRunsRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformId").getter(getter(GetMlTaskRunsRequest::transformId)).setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMlTaskRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetMlTaskRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<TaskRunFilterCriteria> FILTER_FIELD = SdkField
            .<TaskRunFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(GetMlTaskRunsRequest::filter)).setter(setter(Builder::filter))
            .constructor(TaskRunFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<TaskRunSortCriteria> SORT_FIELD = SdkField
            .<TaskRunSortCriteria> builder(MarshallingType.SDK_POJO).memberName("Sort")
            .getter(getter(GetMlTaskRunsRequest::sort)).setter(setter(Builder::sort)).constructor(TaskRunSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, SORT_FIELD));

    private final String transformId;

    private final String nextToken;

    private final Integer maxResults;

    private final TaskRunFilterCriteria filter;

    private final TaskRunSortCriteria sort;

    private GetMlTaskRunsRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * The unique identifier of the machine learning transform.
     * </p>
     * 
     * @return The unique identifier of the machine learning transform.
     */
    public final String transformId() {
        return transformId;
    }

    /**
     * <p>
     * A token for pagination of the results. The default is empty.
     * </p>
     * 
     * @return A token for pagination of the results. The default is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.
     * </p>
     * 
     * @return The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.
     */
    public final TaskRunFilterCriteria filter() {
        return filter;
    }

    /**
     * <p>
     * The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.
     * </p>
     * 
     * @return The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.
     */
    public final TaskRunSortCriteria sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTaskRunsRequest)) {
            return false;
        }
        GetMlTaskRunsRequest other = (GetMlTaskRunsRequest) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filter(), other.filter())
                && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlTaskRunsRequest").add("TransformId", transformId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filter", filter()).add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTaskRunsRequest, T> g) {
        return obj -> g.apply((GetMlTaskRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMlTaskRunsRequest> {
        /**
         * <p>
         * The unique identifier of the machine learning transform.
         * </p>
         * 
         * @param transformId
         *        The unique identifier of the machine learning transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * A token for pagination of the results. The default is empty.
         * </p>
         * 
         * @param nextToken
         *        A token for pagination of the results. The default is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.
         * </p>
         * 
         * @param filter
         *        The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(TaskRunFilterCriteria filter);

        /**
         * <p>
         * The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskRunFilterCriteria.Builder} avoiding the need
         * to create one manually via {@link TaskRunFilterCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskRunFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(TaskRunFilterCriteria)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link TaskRunFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(TaskRunFilterCriteria)
         */
        default Builder filter(Consumer<TaskRunFilterCriteria.Builder> filter) {
            return filter(TaskRunFilterCriteria.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.
         * </p>
         * 
         * @param sort
         *        The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(TaskRunSortCriteria sort);

        /**
         * <p>
         * The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskRunSortCriteria.Builder} avoiding the need
         * to create one manually via {@link TaskRunSortCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskRunSortCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #sort(TaskRunSortCriteria)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link TaskRunSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(TaskRunSortCriteria)
         */
        default Builder sort(Consumer<TaskRunSortCriteria.Builder> sort) {
            return sort(TaskRunSortCriteria.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String transformId;

        private String nextToken;

        private Integer maxResults;

        private TaskRunFilterCriteria filter;

        private TaskRunSortCriteria sort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTaskRunsRequest model) {
            super(model);
            transformId(model.transformId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filter(model.filter);
            sort(model.sort);
        }

        public final String getTransformId() {
            return transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        @Transient
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TaskRunFilterCriteria.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(TaskRunFilterCriteria.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(TaskRunFilterCriteria filter) {
            this.filter = filter;
            return this;
        }

        public final TaskRunSortCriteria.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(TaskRunSortCriteria.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        @Transient
        public final Builder sort(TaskRunSortCriteria sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMlTaskRunsRequest build() {
            return new GetMlTaskRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
