/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableRequest extends GlueRequest implements ToCopyableBuilder<GetTableRequest.Builder, GetTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetTableRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(GetTableRequest::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("QueryAsOfTime").getter(getter(GetTableRequest::queryAsOfTime)).setter(setter(Builder::queryAsOfTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, NAME_FIELD, TRANSACTION_ID_FIELD, QUERY_AS_OF_TIME_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String name;

    private final String transactionId;

    private final Instant queryAsOfTime;

    private GetTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
     *         ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database in the catalog in which the table resides. For Hive compatibility, this name is entirely
     * lowercase.
     * </p>
     * 
     * @return The name of the database in the catalog in which the table resides. For Hive compatibility, this name is
     *         entirely lowercase.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table for which to retrieve the definition. For Hive compatibility, this name is entirely
     * lowercase.
     * </p>
     * 
     * @return The name of the table for which to retrieve the definition. For Hive compatibility, this name is entirely
     *         lowercase.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The transaction ID at which to read the table contents.
     * </p>
     * 
     * @return The transaction ID at which to read the table contents.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The time as of when to read the table contents. If not set, the most recent transaction commit time will be used.
     * Cannot be specified along with <code>TransactionId</code>.
     * </p>
     * 
     * @return The time as of when to read the table contents. If not set, the most recent transaction commit time will
     *         be used. Cannot be specified along with <code>TransactionId</code>.
     */
    public final Instant queryAsOfTime() {
        return queryAsOfTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(queryAsOfTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableRequest)) {
            return false;
        }
        GetTableRequest other = (GetTableRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(name(), other.name()) && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(queryAsOfTime(), other.queryAsOfTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("Name", name()).add("TransactionId", transactionId()).add("QueryAsOfTime", queryAsOfTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "QueryAsOfTime":
            return Optional.ofNullable(clazz.cast(queryAsOfTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableRequest, T> g) {
        return obj -> g.apply((GetTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTableRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID
         * is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database in the catalog in which the table resides. For Hive compatibility, this name is
         * entirely lowercase.
         * </p>
         * 
         * @param databaseName
         *        The name of the database in the catalog in which the table resides. For Hive compatibility, this name
         *        is entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table for which to retrieve the definition. For Hive compatibility, this name is entirely
         * lowercase.
         * </p>
         * 
         * @param name
         *        The name of the table for which to retrieve the definition. For Hive compatibility, this name is
         *        entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The transaction ID at which to read the table contents.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID at which to read the table contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The time as of when to read the table contents. If not set, the most recent transaction commit time will be
         * used. Cannot be specified along with <code>TransactionId</code>.
         * </p>
         * 
         * @param queryAsOfTime
         *        The time as of when to read the table contents. If not set, the most recent transaction commit time
         *        will be used. Cannot be specified along with <code>TransactionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAsOfTime(Instant queryAsOfTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String name;

        private String transactionId;

        private Instant queryAsOfTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            name(model.name);
            transactionId(model.transactionId);
            queryAsOfTime(model.queryAsOfTime);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        @Transient
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        @Transient
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableRequest build() {
            return new GetTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
