/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.JobNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobNames").getter(ListJobsResponse.getter(ListJobsResponse::jobNames)).setter(ListJobsResponse.setter(Builder::jobNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJobsResponse.getter(ListJobsResponse::nextToken)).setter(ListJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> jobNames;
    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobNames = builder.jobNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobNames() {
        return this.jobNames != null && !(this.jobNames instanceof SdkAutoConstructList);
    }

    public final List<String> jobNames() {
        return this.jobNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobNames() ? this.jobNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        return this.hasJobNames() == other.hasJobNames() && Objects.equals(this.jobNames(), other.jobNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobsResponse").add("JobNames", this.hasJobNames() ? this.jobNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobNames": {
                return Optional.ofNullable(clazz.cast(this.jobNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            this.jobNames(model.jobNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getJobNames() {
            if (this.jobNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobNames;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        @Override
        @Transient
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobNames(String ... jobNames) {
            this.jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobNames(Collection<String> var1);

        public Builder jobNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

