/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableRequest extends GlueRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(CreateTableRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<TableInput> TABLE_INPUT_FIELD = SdkField.<TableInput> builder(MarshallingType.SDK_POJO)
            .memberName("TableInput").getter(getter(CreateTableRequest::tableInput)).setter(setter(Builder::tableInput))
            .constructor(TableInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInput").build()).build();

    private static final SdkField<List<PartitionIndex>> PARTITION_INDEXES_FIELD = SdkField
            .<List<PartitionIndex>> builder(MarshallingType.LIST)
            .memberName("PartitionIndexes")
            .getter(getter(CreateTableRequest::partitionIndexes))
            .setter(setter(Builder::partitionIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(CreateTableRequest::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_INPUT_FIELD, PARTITION_INDEXES_FIELD, TRANSACTION_ID_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final TableInput tableInput;

    private final List<PartitionIndex> partitionIndexes;

    private final String transactionId;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
        this.partitionIndexes = builder.partitionIndexes;
        this.transactionId = builder.transactionId;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the Amazon Web
     * Services account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the Amazon Web
     *         Services account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The catalog database in which to create the new table. For Hive compatibility, this name is entirely lowercase.
     * </p>
     * 
     * @return The catalog database in which to create the new table. For Hive compatibility, this name is entirely
     *         lowercase.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The <code>TableInput</code> object that defines the metadata table to create in the catalog.
     * </p>
     * 
     * @return The <code>TableInput</code> object that defines the metadata table to create in the catalog.
     */
    public final TableInput tableInput() {
        return tableInput;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionIndexes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionIndexes() {
        return partitionIndexes != null && !(partitionIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionIndexes} method.
     * </p>
     * 
     * @return A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
     */
    public final List<PartitionIndex> partitionIndexes() {
        return partitionIndexes;
    }

    /**
     * <p>
     * The ID of the transaction.
     * </p>
     * 
     * @return The ID of the transaction.
     */
    public final String transactionId() {
        return transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableInput());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionIndexes() ? partitionIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableInput(), other.tableInput()) && hasPartitionIndexes() == other.hasPartitionIndexes()
                && Objects.equals(partitionIndexes(), other.partitionIndexes())
                && Objects.equals(transactionId(), other.transactionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTableRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableInput", tableInput()).add("PartitionIndexes", hasPartitionIndexes() ? partitionIndexes() : null)
                .add("TransactionId", transactionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableInput":
            return Optional.ofNullable(clazz.cast(tableInput()));
        case "PartitionIndexes":
            return Optional.ofNullable(clazz.cast(partitionIndexes()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the Amazon Web
         * Services account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the Amazon
         *        Web Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The catalog database in which to create the new table. For Hive compatibility, this name is entirely
         * lowercase.
         * </p>
         * 
         * @param databaseName
         *        The catalog database in which to create the new table. For Hive compatibility, this name is entirely
         *        lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The <code>TableInput</code> object that defines the metadata table to create in the catalog.
         * </p>
         * 
         * @param tableInput
         *        The <code>TableInput</code> object that defines the metadata table to create in the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableInput(TableInput tableInput);

        /**
         * <p>
         * The <code>TableInput</code> object that defines the metadata table to create in the catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableInput.Builder} avoiding the need to
         * create one manually via {@link TableInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableInput.Builder#build()} is called immediately and its result
         * is passed to {@link #tableInput(TableInput)}.
         * 
         * @param tableInput
         *        a consumer that will call methods on {@link TableInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableInput(TableInput)
         */
        default Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return tableInput(TableInput.builder().applyMutation(tableInput).build());
        }

        /**
         * <p>
         * A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
         * </p>
         * 
         * @param partitionIndexes
         *        A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIndexes(Collection<PartitionIndex> partitionIndexes);

        /**
         * <p>
         * A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
         * </p>
         * 
         * @param partitionIndexes
         *        A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIndexes(PartitionIndex... partitionIndexes);

        /**
         * <p>
         * A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PartitionIndex>.Builder} avoiding
         * the need to create one manually via {@link List<PartitionIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionIndex>.Builder#build()} is called immediately and
         * its result is passed to {@link #partitionIndexes(List<PartitionIndex>)}.
         * 
         * @param partitionIndexes
         *        a consumer that will call methods on {@link List<PartitionIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionIndexes(List<PartitionIndex>)
         */
        Builder partitionIndexes(Consumer<PartitionIndex.Builder>... partitionIndexes);

        /**
         * <p>
         * The ID of the transaction.
         * </p>
         * 
         * @param transactionId
         *        The ID of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private TableInput tableInput;

        private List<PartitionIndex> partitionIndexes = DefaultSdkAutoConstructList.getInstance();

        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableInput(model.tableInput);
            partitionIndexes(model.partitionIndexes);
            transactionId(model.transactionId);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final TableInput.Builder getTableInput() {
            return tableInput != null ? tableInput.toBuilder() : null;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final List<PartitionIndex.Builder> getPartitionIndexes() {
            List<PartitionIndex.Builder> result = PartitionIndexListCopier.copyToBuilder(this.partitionIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionIndexes(Collection<PartitionIndex.BuilderImpl> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copyFromBuilder(partitionIndexes);
        }

        @Override
        public final Builder partitionIndexes(Collection<PartitionIndex> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copy(partitionIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(PartitionIndex... partitionIndexes) {
            partitionIndexes(Arrays.asList(partitionIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(Consumer<PartitionIndex.Builder>... partitionIndexes) {
            partitionIndexes(Stream.of(partitionIndexes).map(c -> PartitionIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
