/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a Job node present in the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobNodeDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobNodeDetails.Builder, JobNodeDetails> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField
            .<List<JobRun>> builder(MarshallingType.LIST)
            .memberName("JobRuns")
            .getter(getter(JobNodeDetails::jobRuns))
            .setter(setter(Builder::jobRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<JobRun> jobRuns;

    private JobNodeDetails(BuilderImpl builder) {
        this.jobRuns = builder.jobRuns;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobRuns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobRuns() {
        return jobRuns != null && !(jobRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for the job runs represented by the job node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobRuns} method.
     * </p>
     * 
     * @return The information for the job runs represented by the job node.
     */
    public final List<JobRun> jobRuns() {
        return jobRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJobRuns() ? jobRuns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobNodeDetails)) {
            return false;
        }
        JobNodeDetails other = (JobNodeDetails) obj;
        return hasJobRuns() == other.hasJobRuns() && Objects.equals(jobRuns(), other.jobRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobNodeDetails").add("JobRuns", hasJobRuns() ? jobRuns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobRuns":
            return Optional.ofNullable(clazz.cast(jobRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobNodeDetails, T> g) {
        return obj -> g.apply((JobNodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobNodeDetails> {
        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * 
         * @param jobRuns
         *        The information for the job runs represented by the job node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(Collection<JobRun> jobRuns);

        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * 
         * @param jobRuns
         *        The information for the job runs represented by the job node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(JobRun... jobRuns);

        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<JobRun>.Builder} avoiding the need
         * to create one manually via {@link List<JobRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRuns(List<JobRun>)}.
         * 
         * @param jobRuns
         *        a consumer that will call methods on {@link List<JobRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRuns(List<JobRun>)
         */
        Builder jobRuns(Consumer<JobRun.Builder>... jobRuns);
    }

    static final class BuilderImpl implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobNodeDetails model) {
            jobRuns(model.jobRuns);
        }

        public final List<JobRun.Builder> getJobRuns() {
            List<JobRun.Builder> result = JobRunListCopier.copyToBuilder(this.jobRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun... jobRuns) {
            jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder>... jobRuns) {
            jobRuns(Stream.of(jobRuns).map(c -> JobRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public JobNodeDetails build() {
            return new JobNodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
