/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The code execution output in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatementOutput implements SdkPojo, Serializable, ToCopyableBuilder<StatementOutput.Builder, StatementOutput> {
    private static final SdkField<StatementOutputData> DATA_FIELD = SdkField
            .<StatementOutputData> builder(MarshallingType.SDK_POJO).memberName("Data").getter(getter(StatementOutput::data))
            .setter(setter(Builder::data)).constructor(StatementOutputData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final SdkField<Integer> EXECUTION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionCount").getter(getter(StatementOutput::executionCount)).setter(setter(Builder::executionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionCount").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StatementOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorName").getter(getter(StatementOutput::errorName)).setter(setter(Builder::errorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorName").build()).build();

    private static final SdkField<String> ERROR_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorValue").getter(getter(StatementOutput::errorValue)).setter(setter(Builder::errorValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorValue").build()).build();

    private static final SdkField<List<String>> TRACEBACK_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Traceback")
            .getter(getter(StatementOutput::traceback))
            .setter(setter(Builder::traceback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traceback").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD,
            EXECUTION_COUNT_FIELD, STATUS_FIELD, ERROR_NAME_FIELD, ERROR_VALUE_FIELD, TRACEBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatementOutputData data;

    private final Integer executionCount;

    private final String status;

    private final String errorName;

    private final String errorValue;

    private final List<String> traceback;

    private StatementOutput(BuilderImpl builder) {
        this.data = builder.data;
        this.executionCount = builder.executionCount;
        this.status = builder.status;
        this.errorName = builder.errorName;
        this.errorValue = builder.errorValue;
        this.traceback = builder.traceback;
    }

    /**
     * <p>
     * The code execution output.
     * </p>
     * 
     * @return The code execution output.
     */
    public final StatementOutputData data() {
        return data;
    }

    /**
     * <p>
     * The execution count of the output.
     * </p>
     * 
     * @return The execution count of the output.
     */
    public final Integer executionCount() {
        return executionCount;
    }

    /**
     * <p>
     * The status of the code execution output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the code execution output.
     * @see StatementState
     */
    public final StatementState status() {
        return StatementState.fromValue(status);
    }

    /**
     * <p>
     * The status of the code execution output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the code execution output.
     * @see StatementState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the error in the output.
     * </p>
     * 
     * @return The name of the error in the output.
     */
    public final String errorName() {
        return errorName;
    }

    /**
     * <p>
     * The error value of the output.
     * </p>
     * 
     * @return The error value of the output.
     */
    public final String errorValue() {
        return errorValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traceback property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraceback() {
        return traceback != null && !(traceback instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The traceback of the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraceback} method.
     * </p>
     * 
     * @return The traceback of the output.
     */
    public final List<String> traceback() {
        return traceback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(executionCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorName());
        hashCode = 31 * hashCode + Objects.hashCode(errorValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTraceback() ? traceback() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementOutput)) {
            return false;
        }
        StatementOutput other = (StatementOutput) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(executionCount(), other.executionCount())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorName(), other.errorName())
                && Objects.equals(errorValue(), other.errorValue()) && hasTraceback() == other.hasTraceback()
                && Objects.equals(traceback(), other.traceback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatementOutput").add("Data", data()).add("ExecutionCount", executionCount())
                .add("Status", statusAsString()).add("ErrorName", errorName()).add("ErrorValue", errorValue())
                .add("Traceback", hasTraceback() ? traceback() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "ExecutionCount":
            return Optional.ofNullable(clazz.cast(executionCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorName":
            return Optional.ofNullable(clazz.cast(errorName()));
        case "ErrorValue":
            return Optional.ofNullable(clazz.cast(errorValue()));
        case "Traceback":
            return Optional.ofNullable(clazz.cast(traceback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatementOutput, T> g) {
        return obj -> g.apply((StatementOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatementOutput> {
        /**
         * <p>
         * The code execution output.
         * </p>
         * 
         * @param data
         *        The code execution output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(StatementOutputData data);

        /**
         * <p>
         * The code execution output.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatementOutputData.Builder} avoiding the
         * need to create one manually via {@link StatementOutputData#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatementOutputData.Builder#build()} is called immediately and
         * its result is passed to {@link #data(StatementOutputData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link StatementOutputData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(StatementOutputData)
         */
        default Builder data(Consumer<StatementOutputData.Builder> data) {
            return data(StatementOutputData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The execution count of the output.
         * </p>
         * 
         * @param executionCount
         *        The execution count of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionCount(Integer executionCount);

        /**
         * <p>
         * The status of the code execution output.
         * </p>
         * 
         * @param status
         *        The status of the code execution output.
         * @see StatementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementState
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the code execution output.
         * </p>
         * 
         * @param status
         *        The status of the code execution output.
         * @see StatementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementState
         */
        Builder status(StatementState status);

        /**
         * <p>
         * The name of the error in the output.
         * </p>
         * 
         * @param errorName
         *        The name of the error in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorName(String errorName);

        /**
         * <p>
         * The error value of the output.
         * </p>
         * 
         * @param errorValue
         *        The error value of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorValue(String errorValue);

        /**
         * <p>
         * The traceback of the output.
         * </p>
         * 
         * @param traceback
         *        The traceback of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceback(Collection<String> traceback);

        /**
         * <p>
         * The traceback of the output.
         * </p>
         * 
         * @param traceback
         *        The traceback of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceback(String... traceback);
    }

    static final class BuilderImpl implements Builder {
        private StatementOutputData data;

        private Integer executionCount;

        private String status;

        private String errorName;

        private String errorValue;

        private List<String> traceback = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatementOutput model) {
            data(model.data);
            executionCount(model.executionCount);
            status(model.status);
            errorName(model.errorName);
            errorValue(model.errorValue);
            traceback(model.traceback);
        }

        public final StatementOutputData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(StatementOutputData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(StatementOutputData data) {
            this.data = data;
            return this;
        }

        public final Integer getExecutionCount() {
            return executionCount;
        }

        public final void setExecutionCount(Integer executionCount) {
            this.executionCount = executionCount;
        }

        @Override
        public final Builder executionCount(Integer executionCount) {
            this.executionCount = executionCount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatementState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorName() {
            return errorName;
        }

        public final void setErrorName(String errorName) {
            this.errorName = errorName;
        }

        @Override
        public final Builder errorName(String errorName) {
            this.errorName = errorName;
            return this;
        }

        public final String getErrorValue() {
            return errorValue;
        }

        public final void setErrorValue(String errorValue) {
            this.errorValue = errorValue;
        }

        @Override
        public final Builder errorValue(String errorValue) {
            this.errorValue = errorValue;
            return this;
        }

        public final Collection<String> getTraceback() {
            if (traceback instanceof SdkAutoConstructList) {
                return null;
            }
            return traceback;
        }

        public final void setTraceback(Collection<String> traceback) {
            this.traceback = OrchestrationStringListCopier.copy(traceback);
        }

        @Override
        public final Builder traceback(Collection<String> traceback) {
            this.traceback = OrchestrationStringListCopier.copy(traceback);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceback(String... traceback) {
            traceback(Arrays.asList(traceback));
            return this;
        }

        @Override
        public StatementOutput build() {
            return new StatementOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
