/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that maps data property keys in the data source to data property keys in the data target. You
 * can rename keys, modify the data types for keys, and choose which keys to drop from the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyMapping implements SdkPojo, Serializable, ToCopyableBuilder<ApplyMapping.Builder, ApplyMapping> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ApplyMapping::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(ApplyMapping::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Mapping>> MAPPING_FIELD = SdkField
            .<List<Mapping>> builder(MarshallingType.LIST)
            .memberName("Mapping")
            .getter(getter(ApplyMapping::mapping))
            .setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Mapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(Mapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            MAPPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<Mapping> mapping;

    private ApplyMapping(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.mapping = builder.mapping;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Mapping property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapping() {
        return mapping != null && !(mapping instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the mapping of data property keys in the data source to data property keys in the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapping} method.
     * </p>
     * 
     * @return Specifies the mapping of data property keys in the data source to data property keys in the data target.
     */
    public final List<Mapping> mapping() {
        return mapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMapping() ? mapping() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyMapping)) {
            return false;
        }
        ApplyMapping other = (ApplyMapping) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasMapping() == other.hasMapping()
                && Objects.equals(mapping(), other.mapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyMapping").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Mapping", hasMapping() ? mapping() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyMapping, T> g) {
        return obj -> g.apply((ApplyMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplyMapping> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Specifies the mapping of data property keys in the data source to data property keys in the data target.
         * </p>
         * 
         * @param mapping
         *        Specifies the mapping of data property keys in the data source to data property keys in the data
         *        target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Collection<Mapping> mapping);

        /**
         * <p>
         * Specifies the mapping of data property keys in the data source to data property keys in the data target.
         * </p>
         * 
         * @param mapping
         *        Specifies the mapping of data property keys in the data source to data property keys in the data
         *        target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Mapping... mapping);

        /**
         * <p>
         * Specifies the mapping of data property keys in the data source to data property keys in the data target.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Mapping>.Builder} avoiding the need
         * to create one manually via {@link List<Mapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Mapping>.Builder#build()} is called immediately and its
         * result is passed to {@link #mapping(List<Mapping>)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link List<Mapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(List<Mapping>)
         */
        Builder mapping(Consumer<Mapping.Builder>... mapping);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<Mapping> mapping = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyMapping model) {
            name(model.name);
            inputs(model.inputs);
            mapping(model.mapping);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final List<Mapping.Builder> getMapping() {
            List<Mapping.Builder> result = MappingsCopier.copyToBuilder(this.mapping);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapping(Collection<Mapping.BuilderImpl> mapping) {
            this.mapping = MappingsCopier.copyFromBuilder(mapping);
        }

        @Override
        public final Builder mapping(Collection<Mapping> mapping) {
            this.mapping = MappingsCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Mapping... mapping) {
            mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<Mapping.Builder>... mapping) {
            mapping(Stream.of(mapping).map(c -> Mapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ApplyMapping build() {
            return new ApplyMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
