/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCustomEntityTypesResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetCustomEntityTypesResponse.Builder, BatchGetCustomEntityTypesResponse> {
    private static final SdkField<List<CustomEntityType>> CUSTOM_ENTITY_TYPES_FIELD = SdkField
            .<List<CustomEntityType>> builder(MarshallingType.LIST)
            .memberName("CustomEntityTypes")
            .getter(getter(BatchGetCustomEntityTypesResponse::customEntityTypes))
            .setter(setter(Builder::customEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomEntityType> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomEntityType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CUSTOM_ENTITY_TYPES_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomEntityTypesNotFound")
            .getter(getter(BatchGetCustomEntityTypesResponse::customEntityTypesNotFound))
            .setter(setter(Builder::customEntityTypesNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypesNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ENTITY_TYPES_FIELD,
            CUSTOM_ENTITY_TYPES_NOT_FOUND_FIELD));

    private final List<CustomEntityType> customEntityTypes;

    private final List<String> customEntityTypesNotFound;

    private BatchGetCustomEntityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.customEntityTypes = builder.customEntityTypes;
        this.customEntityTypesNotFound = builder.customEntityTypesNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomEntityTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomEntityTypes() {
        return customEntityTypes != null && !(customEntityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>CustomEntityType</code> objects representing the custom patterns that have been created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomEntityTypes} method.
     * </p>
     * 
     * @return A list of <code>CustomEntityType</code> objects representing the custom patterns that have been created.
     */
    public final List<CustomEntityType> customEntityTypes() {
        return customEntityTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomEntityTypesNotFound property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomEntityTypesNotFound() {
        return customEntityTypesNotFound != null && !(customEntityTypesNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the names of custom patterns that were not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomEntityTypesNotFound} method.
     * </p>
     * 
     * @return A list of the names of custom patterns that were not found.
     */
    public final List<String> customEntityTypesNotFound() {
        return customEntityTypesNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEntityTypes() ? customEntityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEntityTypesNotFound() ? customEntityTypesNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCustomEntityTypesResponse)) {
            return false;
        }
        BatchGetCustomEntityTypesResponse other = (BatchGetCustomEntityTypesResponse) obj;
        return hasCustomEntityTypes() == other.hasCustomEntityTypes()
                && Objects.equals(customEntityTypes(), other.customEntityTypes())
                && hasCustomEntityTypesNotFound() == other.hasCustomEntityTypesNotFound()
                && Objects.equals(customEntityTypesNotFound(), other.customEntityTypesNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCustomEntityTypesResponse")
                .add("CustomEntityTypes", hasCustomEntityTypes() ? customEntityTypes() : null)
                .add("CustomEntityTypesNotFound", hasCustomEntityTypesNotFound() ? customEntityTypesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomEntityTypes":
            return Optional.ofNullable(clazz.cast(customEntityTypes()));
        case "CustomEntityTypesNotFound":
            return Optional.ofNullable(clazz.cast(customEntityTypesNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCustomEntityTypesResponse, T> g) {
        return obj -> g.apply((BatchGetCustomEntityTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCustomEntityTypesResponse> {
        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing the custom patterns that have been created.
         * </p>
         * 
         * @param customEntityTypes
         *        A list of <code>CustomEntityType</code> objects representing the custom patterns that have been
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes);

        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing the custom patterns that have been created.
         * </p>
         * 
         * @param customEntityTypes
         *        A list of <code>CustomEntityType</code> objects representing the custom patterns that have been
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypes(CustomEntityType... customEntityTypes);

        /**
         * <p>
         * A list of <code>CustomEntityType</code> objects representing the custom patterns that have been created.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CustomEntityType>.Builder} avoiding
         * the need to create one manually via {@link List<CustomEntityType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomEntityType>.Builder#build()} is called immediately and
         * its result is passed to {@link #customEntityTypes(List<CustomEntityType>)}.
         * 
         * @param customEntityTypes
         *        a consumer that will call methods on {@link List<CustomEntityType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customEntityTypes(List<CustomEntityType>)
         */
        Builder customEntityTypes(Consumer<CustomEntityType.Builder>... customEntityTypes);

        /**
         * <p>
         * A list of the names of custom patterns that were not found.
         * </p>
         * 
         * @param customEntityTypesNotFound
         *        A list of the names of custom patterns that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypesNotFound(Collection<String> customEntityTypesNotFound);

        /**
         * <p>
         * A list of the names of custom patterns that were not found.
         * </p>
         * 
         * @param customEntityTypesNotFound
         *        A list of the names of custom patterns that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityTypesNotFound(String... customEntityTypesNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<CustomEntityType> customEntityTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> customEntityTypesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCustomEntityTypesResponse model) {
            super(model);
            customEntityTypes(model.customEntityTypes);
            customEntityTypesNotFound(model.customEntityTypesNotFound);
        }

        public final List<CustomEntityType.Builder> getCustomEntityTypes() {
            List<CustomEntityType.Builder> result = CustomEntityTypesCopier.copyToBuilder(this.customEntityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomEntityTypes(Collection<CustomEntityType.BuilderImpl> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copyFromBuilder(customEntityTypes);
        }

        @Override
        public final Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copy(customEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(CustomEntityType... customEntityTypes) {
            customEntityTypes(Arrays.asList(customEntityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(Consumer<CustomEntityType.Builder>... customEntityTypes) {
            customEntityTypes(Stream.of(customEntityTypes).map(c -> CustomEntityType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCustomEntityTypesNotFound() {
            if (customEntityTypesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return customEntityTypesNotFound;
        }

        public final void setCustomEntityTypesNotFound(Collection<String> customEntityTypesNotFound) {
            this.customEntityTypesNotFound = CustomEntityTypeNamesCopier.copy(customEntityTypesNotFound);
        }

        @Override
        public final Builder customEntityTypesNotFound(Collection<String> customEntityTypesNotFound) {
            this.customEntityTypesNotFound = CustomEntityTypeNamesCopier.copy(customEntityTypesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypesNotFound(String... customEntityTypesNotFound) {
            customEntityTypesNotFound(Arrays.asList(customEntityTypesNotFound));
            return this;
        }

        @Override
        public BatchGetCustomEntityTypesResponse build() {
            return new BatchGetCustomEntityTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
