/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Apache Kafka data store in the Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogKafkaSource implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogKafkaSource.Builder, CatalogKafkaSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CatalogKafkaSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WindowSize").getter(getter(CatalogKafkaSource::windowSize)).setter(setter(Builder::windowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()).build();

    private static final SdkField<Boolean> DETECT_SCHEMA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetectSchema").getter(getter(CatalogKafkaSource::detectSchema)).setter(setter(Builder::detectSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectSchema").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(CatalogKafkaSource::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(CatalogKafkaSource::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<KafkaStreamingSourceOptions> STREAMING_OPTIONS_FIELD = SdkField
            .<KafkaStreamingSourceOptions> builder(MarshallingType.SDK_POJO).memberName("StreamingOptions")
            .getter(getter(CatalogKafkaSource::streamingOptions)).setter(setter(Builder::streamingOptions))
            .constructor(KafkaStreamingSourceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingOptions").build()).build();

    private static final SdkField<StreamingDataPreviewOptions> DATA_PREVIEW_OPTIONS_FIELD = SdkField
            .<StreamingDataPreviewOptions> builder(MarshallingType.SDK_POJO).memberName("DataPreviewOptions")
            .getter(getter(CatalogKafkaSource::dataPreviewOptions)).setter(setter(Builder::dataPreviewOptions))
            .constructor(StreamingDataPreviewOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreviewOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WINDOW_SIZE_FIELD,
            DETECT_SCHEMA_FIELD, TABLE_FIELD, DATABASE_FIELD, STREAMING_OPTIONS_FIELD, DATA_PREVIEW_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer windowSize;

    private final Boolean detectSchema;

    private final String table;

    private final String database;

    private final KafkaStreamingSourceOptions streamingOptions;

    private final StreamingDataPreviewOptions dataPreviewOptions;

    private CatalogKafkaSource(BuilderImpl builder) {
        this.name = builder.name;
        this.windowSize = builder.windowSize;
        this.detectSchema = builder.detectSchema;
        this.table = builder.table;
        this.database = builder.database;
        this.streamingOptions = builder.streamingOptions;
        this.dataPreviewOptions = builder.dataPreviewOptions;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The amount of time to spend processing each micro batch.
     * </p>
     * 
     * @return The amount of time to spend processing each micro batch.
     */
    public final Integer windowSize() {
        return windowSize;
    }

    /**
     * <p>
     * Whether to automatically determine the schema from the incoming data.
     * </p>
     * 
     * @return Whether to automatically determine the schema from the incoming data.
     */
    public final Boolean detectSchema() {
        return detectSchema;
    }

    /**
     * <p>
     * The name of the table in the database to read from.
     * </p>
     * 
     * @return The name of the table in the database to read from.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The name of the database to read from.
     * </p>
     * 
     * @return The name of the database to read from.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * Specifies the streaming options.
     * </p>
     * 
     * @return Specifies the streaming options.
     */
    public final KafkaStreamingSourceOptions streamingOptions() {
        return streamingOptions;
    }

    /**
     * <p>
     * Specifies options related to data preview for viewing a sample of your data.
     * </p>
     * 
     * @return Specifies options related to data preview for viewing a sample of your data.
     */
    public final StreamingDataPreviewOptions dataPreviewOptions() {
        return dataPreviewOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(windowSize());
        hashCode = 31 * hashCode + Objects.hashCode(detectSchema());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(streamingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataPreviewOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogKafkaSource)) {
            return false;
        }
        CatalogKafkaSource other = (CatalogKafkaSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(windowSize(), other.windowSize())
                && Objects.equals(detectSchema(), other.detectSchema()) && Objects.equals(table(), other.table())
                && Objects.equals(database(), other.database()) && Objects.equals(streamingOptions(), other.streamingOptions())
                && Objects.equals(dataPreviewOptions(), other.dataPreviewOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogKafkaSource").add("Name", name()).add("WindowSize", windowSize())
                .add("DetectSchema", detectSchema()).add("Table", table()).add("Database", database())
                .add("StreamingOptions", streamingOptions()).add("DataPreviewOptions", dataPreviewOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "WindowSize":
            return Optional.ofNullable(clazz.cast(windowSize()));
        case "DetectSchema":
            return Optional.ofNullable(clazz.cast(detectSchema()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "StreamingOptions":
            return Optional.ofNullable(clazz.cast(streamingOptions()));
        case "DataPreviewOptions":
            return Optional.ofNullable(clazz.cast(dataPreviewOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogKafkaSource, T> g) {
        return obj -> g.apply((CatalogKafkaSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogKafkaSource> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param name
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The amount of time to spend processing each micro batch.
         * </p>
         * 
         * @param windowSize
         *        The amount of time to spend processing each micro batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowSize(Integer windowSize);

        /**
         * <p>
         * Whether to automatically determine the schema from the incoming data.
         * </p>
         * 
         * @param detectSchema
         *        Whether to automatically determine the schema from the incoming data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectSchema(Boolean detectSchema);

        /**
         * <p>
         * The name of the table in the database to read from.
         * </p>
         * 
         * @param table
         *        The name of the table in the database to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The name of the database to read from.
         * </p>
         * 
         * @param database
         *        The name of the database to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Specifies the streaming options.
         * </p>
         * 
         * @param streamingOptions
         *        Specifies the streaming options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingOptions(KafkaStreamingSourceOptions streamingOptions);

        /**
         * <p>
         * Specifies the streaming options.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaStreamingSourceOptions.Builder}
         * avoiding the need to create one manually via {@link KafkaStreamingSourceOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaStreamingSourceOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingOptions(KafkaStreamingSourceOptions)}.
         * 
         * @param streamingOptions
         *        a consumer that will call methods on {@link KafkaStreamingSourceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingOptions(KafkaStreamingSourceOptions)
         */
        default Builder streamingOptions(Consumer<KafkaStreamingSourceOptions.Builder> streamingOptions) {
            return streamingOptions(KafkaStreamingSourceOptions.builder().applyMutation(streamingOptions).build());
        }

        /**
         * <p>
         * Specifies options related to data preview for viewing a sample of your data.
         * </p>
         * 
         * @param dataPreviewOptions
         *        Specifies options related to data preview for viewing a sample of your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions);

        /**
         * <p>
         * Specifies options related to data preview for viewing a sample of your data.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingDataPreviewOptions.Builder}
         * avoiding the need to create one manually via {@link StreamingDataPreviewOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDataPreviewOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #dataPreviewOptions(StreamingDataPreviewOptions)}.
         * 
         * @param dataPreviewOptions
         *        a consumer that will call methods on {@link StreamingDataPreviewOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPreviewOptions(StreamingDataPreviewOptions)
         */
        default Builder dataPreviewOptions(Consumer<StreamingDataPreviewOptions.Builder> dataPreviewOptions) {
            return dataPreviewOptions(StreamingDataPreviewOptions.builder().applyMutation(dataPreviewOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer windowSize;

        private Boolean detectSchema;

        private String table;

        private String database;

        private KafkaStreamingSourceOptions streamingOptions;

        private StreamingDataPreviewOptions dataPreviewOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogKafkaSource model) {
            name(model.name);
            windowSize(model.windowSize);
            detectSchema(model.detectSchema);
            table(model.table);
            database(model.database);
            streamingOptions(model.streamingOptions);
            dataPreviewOptions(model.dataPreviewOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getWindowSize() {
            return windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public final Boolean getDetectSchema() {
            return detectSchema;
        }

        public final void setDetectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
        }

        @Override
        public final Builder detectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final KafkaStreamingSourceOptions.Builder getStreamingOptions() {
            return streamingOptions != null ? streamingOptions.toBuilder() : null;
        }

        public final void setStreamingOptions(KafkaStreamingSourceOptions.BuilderImpl streamingOptions) {
            this.streamingOptions = streamingOptions != null ? streamingOptions.build() : null;
        }

        @Override
        public final Builder streamingOptions(KafkaStreamingSourceOptions streamingOptions) {
            this.streamingOptions = streamingOptions;
            return this;
        }

        public final StreamingDataPreviewOptions.Builder getDataPreviewOptions() {
            return dataPreviewOptions != null ? dataPreviewOptions.toBuilder() : null;
        }

        public final void setDataPreviewOptions(StreamingDataPreviewOptions.BuilderImpl dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions != null ? dataPreviewOptions.build() : null;
        }

        @Override
        public final Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions;
            return this;
        }

        @Override
        public CatalogKafkaSource build() {
            return new CatalogKafkaSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
