/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends GlueRequest implements ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LogUri")
            .getter(getter(CreateJobRequest::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateJobRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<ExecutionProperty> EXECUTION_PROPERTY_FIELD = SdkField
            .<ExecutionProperty> builder(MarshallingType.SDK_POJO).memberName("ExecutionProperty")
            .getter(getter(CreateJobRequest::executionProperty)).setter(setter(Builder::executionProperty))
            .constructor(ExecutionProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionProperty").build()).build();

    private static final SdkField<JobCommand> COMMAND_FIELD = SdkField.<JobCommand> builder(MarshallingType.SDK_POJO)
            .memberName("Command").getter(getter(CreateJobRequest::command)).setter(setter(Builder::command))
            .constructor(JobCommand::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()).build();

    private static final SdkField<Map<String, String>> DEFAULT_ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DefaultArguments")
            .getter(getter(CreateJobRequest::defaultArguments))
            .setter(setter(Builder::defaultArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultArguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> NON_OVERRIDABLE_ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("NonOverridableArguments")
            .getter(getter(CreateJobRequest::nonOverridableArguments))
            .setter(setter(Builder::nonOverridableArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonOverridableArguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConnectionsList> CONNECTIONS_FIELD = SdkField
            .<ConnectionsList> builder(MarshallingType.SDK_POJO).memberName("Connections")
            .getter(getter(CreateJobRequest::connections)).setter(setter(Builder::connections))
            .constructor(ConnectionsList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(CreateJobRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedCapacity").getter(getter(CreateJobRequest::allocatedCapacity))
            .setter(setter(Builder::allocatedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CreateJobRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(CreateJobRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(CreateJobRequest::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField
            .<NotificationProperty> builder(MarshallingType.SDK_POJO).memberName("NotificationProperty")
            .getter(getter(CreateJobRequest::notificationProperty)).setter(setter(Builder::notificationProperty))
            .constructor(NotificationProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build())
            .build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(CreateJobRequest::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(CreateJobRequest::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(CreateJobRequest::workerTypeAsString)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<Map<String, CodeGenConfigurationNode>> CODE_GEN_CONFIGURATION_NODES_FIELD = SdkField
            .<Map<String, CodeGenConfigurationNode>> builder(MarshallingType.MAP)
            .memberName("CodeGenConfigurationNodes")
            .getter(getter(CreateJobRequest::codeGenConfigurationNodes))
            .setter(setter(Builder::codeGenConfigurationNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeGenConfigurationNodes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CodeGenConfigurationNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenConfigurationNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionClass").getter(getter(CreateJobRequest::executionClassAsString))
            .setter(setter(Builder::executionClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            LOG_URI_FIELD, ROLE_FIELD, EXECUTION_PROPERTY_FIELD, COMMAND_FIELD, DEFAULT_ARGUMENTS_FIELD,
            NON_OVERRIDABLE_ARGUMENTS_FIELD, CONNECTIONS_FIELD, MAX_RETRIES_FIELD, ALLOCATED_CAPACITY_FIELD, TIMEOUT_FIELD,
            MAX_CAPACITY_FIELD, SECURITY_CONFIGURATION_FIELD, TAGS_FIELD, NOTIFICATION_PROPERTY_FIELD, GLUE_VERSION_FIELD,
            NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD, CODE_GEN_CONFIGURATION_NODES_FIELD, EXECUTION_CLASS_FIELD));

    private final String name;

    private final String description;

    private final String logUri;

    private final String role;

    private final ExecutionProperty executionProperty;

    private final JobCommand command;

    private final Map<String, String> defaultArguments;

    private final Map<String, String> nonOverridableArguments;

    private final ConnectionsList connections;

    private final Integer maxRetries;

    private final Integer allocatedCapacity;

    private final Integer timeout;

    private final Double maxCapacity;

    private final String securityConfiguration;

    private final Map<String, String> tags;

    private final NotificationProperty notificationProperty;

    private final String glueVersion;

    private final Integer numberOfWorkers;

    private final String workerType;

    private final Map<String, CodeGenConfigurationNode> codeGenConfigurationNodes;

    private final String executionClass;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.logUri = builder.logUri;
        this.role = builder.role;
        this.executionProperty = builder.executionProperty;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.nonOverridableArguments = builder.nonOverridableArguments;
        this.connections = builder.connections;
        this.maxRetries = builder.maxRetries;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.timeout = builder.timeout;
        this.maxCapacity = builder.maxCapacity;
        this.securityConfiguration = builder.securityConfiguration;
        this.tags = builder.tags;
        this.notificationProperty = builder.notificationProperty;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
        this.codeGenConfigurationNodes = builder.codeGenConfigurationNodes;
        this.executionClass = builder.executionClass;
    }

    /**
     * <p>
     * The name you assign to this job definition. It must be unique in your account.
     * </p>
     * 
     * @return The name you assign to this job definition. It must be unique in your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the job being defined.
     * </p>
     * 
     * @return Description of the job being defined.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * This field is reserved for future use.
     * </p>
     * 
     * @return This field is reserved for future use.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.
     * </p>
     * 
     * @return An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.
     */
    public final ExecutionProperty executionProperty() {
        return executionProperty;
    }

    /**
     * <p>
     * The <code>JobCommand</code> that runs this job.
     * </p>
     * 
     * @return The <code>JobCommand</code> that runs this job.
     */
    public final JobCommand command() {
        return command;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultArguments() {
        return defaultArguments != null && !(defaultArguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The default arguments for this job.
     * </p>
     * <p>
     * You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue itself
     * consumes.
     * </p>
     * <p>
     * Job arguments may be logged. Do not pass plaintext secrets as arguments. Retrieve secrets from a Glue Connection,
     * Secrets Manager or other secret management mechanism if you intend to keep them within the Job.
     * </p>
     * <p>
     * For information about how to specify and consume your own Job arguments, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in
     * Python</a> topic in the developer guide.
     * </p>
     * <p>
     * For information about the key-value pairs that Glue consumes to set up your job, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters
     * Used by Glue</a> topic in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultArguments} method.
     * </p>
     * 
     * @return The default arguments for this job.</p>
     *         <p>
     *         You can specify arguments here that your own job-execution script consumes, as well as arguments that
     *         Glue itself consumes.
     *         </p>
     *         <p>
     *         Job arguments may be logged. Do not pass plaintext secrets as arguments. Retrieve secrets from a Glue
     *         Connection, Secrets Manager or other secret management mechanism if you intend to keep them within the
     *         Job.
     *         </p>
     *         <p>
     *         For information about how to specify and consume your own Job arguments, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue
     *         APIs in Python</a> topic in the developer guide.
     *         </p>
     *         <p>
     *         For information about the key-value pairs that Glue consumes to set up your job, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
     *         Parameters Used by Glue</a> topic in the developer guide.
     */
    public final Map<String, String> defaultArguments() {
        return defaultArguments;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonOverridableArguments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNonOverridableArguments() {
        return nonOverridableArguments != null && !(nonOverridableArguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Non-overridable arguments for this job, specified as name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonOverridableArguments} method.
     * </p>
     * 
     * @return Non-overridable arguments for this job, specified as name-value pairs.
     */
    public final Map<String, String> nonOverridableArguments() {
        return nonOverridableArguments;
    }

    /**
     * <p>
     * The connections used for this job.
     * </p>
     * 
     * @return The connections used for this job.
     */
    public final ConnectionsList connections() {
        return connections;
    }

    /**
     * <p>
     * The maximum number of times to retry this job if it fails.
     * </p>
     * 
     * @return The maximum number of times to retry this job if it fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * <p>
     * This parameter is deprecated. Use <code>MaxCapacity</code> instead.
     * </p>
     * <p>
     * The number of Glue data processing units (DPUs) to allocate to this Job. You can allocate a minimum of 2 DPUs;
     * the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity
     * and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
     * page</a>.
     * </p>
     * 
     * @return This parameter is deprecated. Use <code>MaxCapacity</code> instead.</p>
     *         <p>
     *         The number of Glue data processing units (DPUs) to allocate to this Job. You can allocate a minimum of 2
     *         DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of
     *         compute capacity and 16 GB of memory. For more information, see the <a
     *         href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
     * @deprecated This property is deprecated, use MaxCapacity instead.
     */
    @Deprecated
    public final Integer allocatedCapacity() {
        return allocatedCapacity;
    }

    /**
     * <p>
     * The job timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated
     * and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The job timeout in minutes. This is the maximum time that a job run can consume resources before it is
     *         terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units
     * (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
     * </p>
     * <p>
     * Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.
     * </p>
     * <p>
     * The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell
     * job or an Apache Spark ETL job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625
     * or 1 DPU. The default is 0.0625 DPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark streaming ETL
     * job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate a minimum of 2 DPUs. The default is 10 DPUs.
     * This job type cannot have a fractional DPU allocation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should
     * specify a <code>Worker type</code> and the <code>Number of workers</code>.
     * </p>
     * 
     * @return For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing
     *         units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power
     *         that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *         href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.</p>
     *         <p>
     *         Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.
     *         </p>
     *         <p>
     *         The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python
     *         shell job or an Apache Spark ETL job:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either
     *         0.0625 or 1 DPU. The default is 0.0625 DPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark
     *         streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate a minimum of 2 DPUs.
     *         The default is 10 DPUs. This job type cannot have a fractional DPU allocation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you
     *         should specify a <code>Worker type</code> and the <code>Number of workers</code>.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used with this job.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used with this job.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to use with this job. You may use tags to limit access to the job. For more information about tags in
     * Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in
     * Glue</a> in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to use with this job. You may use tags to limit access to the job. For more information about
     *         tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web
     *         Services Tags in Glue</a> in the developer guide.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies configuration properties of a job notification.
     * </p>
     * 
     * @return Specifies configuration properties of a job notification.
     */
    public final NotificationProperty notificationProperty() {
        return notificationProperty;
    }

    /**
     * <p>
     * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates
     * the version supported for jobs of type Spark.
     * </p>
     * <p>
     * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * </p>
     * <p>
     * Jobs that are created without specifying a Glue version default to Glue 0.9.
     * </p>
     * 
     * @return Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
     *         indicates the version supported for jobs of type Spark. </p>
     *         <p>
     *         For more information about the available Glue versions and corresponding Spark and Python versions, see
     *         <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer
     *         guide.
     *         </p>
     *         <p>
     *         Jobs that are created without specifying a Glue version default to Glue 0.9.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or
     * G.025X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker type is
     * only available for Glue version 3.0 streaming jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X,
     *         or G.025X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB
     *         disk), and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs.
     *         This worker type is only available for Glue version 3.0 streaming jobs.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or
     * G.025X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker type is
     * only available for Glue version 3.0 streaming jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X,
     *         or G.025X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB
     *         disk), and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs.
     *         This worker type is only available for Glue version 3.0 streaming jobs.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final String workerTypeAsString() {
        return workerType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeGenConfigurationNodes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCodeGenConfigurationNodes() {
        return codeGenConfigurationNodes != null && !(codeGenConfigurationNodes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The representation of a directed acyclic graph on which both the Glue Studio visual component and Glue Studio
     * code generation is based.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeGenConfigurationNodes} method.
     * </p>
     * 
     * @return The representation of a directed acyclic graph on which both the Glue Studio visual component and Glue
     *         Studio code generation is based.
     */
    public final Map<String, CodeGenConfigurationNode> codeGenConfigurationNodes() {
        return codeGenConfigurationNodes;
    }

    /**
     * <p>
     * Indicates whether the job is run with a standard or flexible execution class. The standard execution-class is
     * ideal for time-sensitive workloads that require fast job startup and dedicated resources.
     * </p>
     * <p>
     * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may vary.
     * </p>
     * <p>
     * Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
     * <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionClass}
     * will return {@link ExecutionClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionClassAsString}.
     * </p>
     * 
     * @return Indicates whether the job is run with a standard or flexible execution class. The standard
     *         execution-class is ideal for time-sensitive workloads that require fast job startup and dedicated
     *         resources.</p>
     *         <p>
     *         The flexible execution class is appropriate for time-insensitive jobs whose start and completion times
     *         may vary.
     *         </p>
     *         <p>
     *         Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
     *         <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark
     *         jobs.
     * @see ExecutionClass
     */
    public final ExecutionClass executionClass() {
        return ExecutionClass.fromValue(executionClass);
    }

    /**
     * <p>
     * Indicates whether the job is run with a standard or flexible execution class. The standard execution-class is
     * ideal for time-sensitive workloads that require fast job startup and dedicated resources.
     * </p>
     * <p>
     * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may vary.
     * </p>
     * <p>
     * Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
     * <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionClass}
     * will return {@link ExecutionClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionClassAsString}.
     * </p>
     * 
     * @return Indicates whether the job is run with a standard or flexible execution class. The standard
     *         execution-class is ideal for time-sensitive workloads that require fast job startup and dedicated
     *         resources.</p>
     *         <p>
     *         The flexible execution class is appropriate for time-insensitive jobs whose start and completion times
     *         may vary.
     *         </p>
     *         <p>
     *         Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
     *         <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark
     *         jobs.
     * @see ExecutionClass
     */
    public final String executionClassAsString() {
        return executionClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(executionProperty());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultArguments() ? defaultArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNonOverridableArguments() ? nonOverridableArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connections());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeGenConfigurationNodes() ? codeGenConfigurationNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(logUri(), other.logUri()) && Objects.equals(role(), other.role())
                && Objects.equals(executionProperty(), other.executionProperty()) && Objects.equals(command(), other.command())
                && hasDefaultArguments() == other.hasDefaultArguments()
                && Objects.equals(defaultArguments(), other.defaultArguments())
                && hasNonOverridableArguments() == other.hasNonOverridableArguments()
                && Objects.equals(nonOverridableArguments(), other.nonOverridableArguments())
                && Objects.equals(connections(), other.connections()) && Objects.equals(maxRetries(), other.maxRetries())
                && Objects.equals(allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(securityConfiguration(), other.securityConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(notificationProperty(), other.notificationProperty())
                && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && hasCodeGenConfigurationNodes() == other.hasCodeGenConfigurationNodes()
                && Objects.equals(codeGenConfigurationNodes(), other.codeGenConfigurationNodes())
                && Objects.equals(executionClassAsString(), other.executionClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("Name", name()).add("Description", description()).add("LogUri", logUri())
                .add("Role", role()).add("ExecutionProperty", executionProperty()).add("Command", command())
                .add("DefaultArguments", hasDefaultArguments() ? defaultArguments() : null)
                .add("NonOverridableArguments", hasNonOverridableArguments() ? nonOverridableArguments() : null)
                .add("Connections", connections()).add("MaxRetries", maxRetries()).add("AllocatedCapacity", allocatedCapacity())
                .add("Timeout", timeout()).add("MaxCapacity", maxCapacity())
                .add("SecurityConfiguration", securityConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("NotificationProperty", notificationProperty()).add("GlueVersion", glueVersion())
                .add("NumberOfWorkers", numberOfWorkers()).add("WorkerType", workerTypeAsString())
                .add("CodeGenConfigurationNodes", codeGenConfigurationNodes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExecutionClass", executionClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LogUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "ExecutionProperty":
            return Optional.ofNullable(clazz.cast(executionProperty()));
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "DefaultArguments":
            return Optional.ofNullable(clazz.cast(defaultArguments()));
        case "NonOverridableArguments":
            return Optional.ofNullable(clazz.cast(nonOverridableArguments()));
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "AllocatedCapacity":
            return Optional.ofNullable(clazz.cast(allocatedCapacity()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NotificationProperty":
            return Optional.ofNullable(clazz.cast(notificationProperty()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "CodeGenConfigurationNodes":
            return Optional.ofNullable(clazz.cast(codeGenConfigurationNodes()));
        case "ExecutionClass":
            return Optional.ofNullable(clazz.cast(executionClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * The name you assign to this job definition. It must be unique in your account.
         * </p>
         * 
         * @param name
         *        The name you assign to this job definition. It must be unique in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the job being defined.
         * </p>
         * 
         * @param description
         *        Description of the job being defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * This field is reserved for future use.
         * </p>
         * 
         * @param logUri
         *        This field is reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
         * </p>
         * 
         * @param role
         *        The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.
         * </p>
         * 
         * @param executionProperty
         *        An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionProperty(ExecutionProperty executionProperty);

        /**
         * <p>
         * An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionProperty.Builder} avoiding the
         * need to create one manually via {@link ExecutionProperty#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #executionProperty(ExecutionProperty)}.
         * 
         * @param executionProperty
         *        a consumer that will call methods on {@link ExecutionProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionProperty(ExecutionProperty)
         */
        default Builder executionProperty(Consumer<ExecutionProperty.Builder> executionProperty) {
            return executionProperty(ExecutionProperty.builder().applyMutation(executionProperty).build());
        }

        /**
         * <p>
         * The <code>JobCommand</code> that runs this job.
         * </p>
         * 
         * @param command
         *        The <code>JobCommand</code> that runs this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(JobCommand command);

        /**
         * <p>
         * The <code>JobCommand</code> that runs this job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobCommand.Builder} avoiding the need to
         * create one manually via {@link JobCommand#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobCommand.Builder#build()} is called immediately and its result
         * is passed to {@link #command(JobCommand)}.
         * 
         * @param command
         *        a consumer that will call methods on {@link JobCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #command(JobCommand)
         */
        default Builder command(Consumer<JobCommand.Builder> command) {
            return command(JobCommand.builder().applyMutation(command).build());
        }

        /**
         * <p>
         * The default arguments for this job.
         * </p>
         * <p>
         * You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue
         * itself consumes.
         * </p>
         * <p>
         * Job arguments may be logged. Do not pass plaintext secrets as arguments. Retrieve secrets from a Glue
         * Connection, Secrets Manager or other secret management mechanism if you intend to keep them within the Job.
         * </p>
         * <p>
         * For information about how to specify and consume your own Job arguments, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs
         * in Python</a> topic in the developer guide.
         * </p>
         * <p>
         * For information about the key-value pairs that Glue consumes to set up your job, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         * Parameters Used by Glue</a> topic in the developer guide.
         * </p>
         * 
         * @param defaultArguments
         *        The default arguments for this job.</p>
         *        <p>
         *        You can specify arguments here that your own job-execution script consumes, as well as arguments that
         *        Glue itself consumes.
         *        </p>
         *        <p>
         *        Job arguments may be logged. Do not pass plaintext secrets as arguments. Retrieve secrets from a Glue
         *        Connection, Secrets Manager or other secret management mechanism if you intend to keep them within the
         *        Job.
         *        </p>
         *        <p>
         *        For information about how to specify and consume your own Job arguments, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling
         *        Glue APIs in Python</a> topic in the developer guide.
         *        </p>
         *        <p>
         *        For information about the key-value pairs that Glue consumes to set up your job, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         *        Parameters Used by Glue</a> topic in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultArguments(Map<String, String> defaultArguments);

        /**
         * <p>
         * Non-overridable arguments for this job, specified as name-value pairs.
         * </p>
         * 
         * @param nonOverridableArguments
         *        Non-overridable arguments for this job, specified as name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonOverridableArguments(Map<String, String> nonOverridableArguments);

        /**
         * <p>
         * The connections used for this job.
         * </p>
         * 
         * @param connections
         *        The connections used for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(ConnectionsList connections);

        /**
         * <p>
         * The connections used for this job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionsList.Builder} avoiding the
         * need to create one manually via {@link ConnectionsList#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionsList.Builder#build()} is called immediately and its
         * result is passed to {@link #connections(ConnectionsList)}.
         * 
         * @param connections
         *        a consumer that will call methods on {@link ConnectionsList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(ConnectionsList)
         */
        default Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return connections(ConnectionsList.builder().applyMutation(connections).build());
        }

        /**
         * <p>
         * The maximum number of times to retry this job if it fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry this job if it fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * This parameter is deprecated. Use <code>MaxCapacity</code> instead.
         * </p>
         * <p>
         * The number of Glue data processing units (DPUs) to allocate to this Job. You can allocate a minimum of 2
         * DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute
         * capacity and 16 GB of memory. For more information, see the <a
         * href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
         * </p>
         * 
         * @param allocatedCapacity
         *        This parameter is deprecated. Use <code>MaxCapacity</code> instead.</p>
         *        <p>
         *        The number of Glue data processing units (DPUs) to allocate to this Job. You can allocate a minimum of
         *        2 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of
         *        compute capacity and 16 GB of memory. For more information, see the <a
         *        href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated, use MaxCapacity instead.
         */
        @Deprecated
        Builder allocatedCapacity(Integer allocatedCapacity);

        /**
         * <p>
         * The job timeout in minutes. This is the maximum time that a job run can consume resources before it is
         * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The job timeout in minutes. This is the maximum time that a job run can consume resources before it is
         *        terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing
         * units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that
         * consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
         * href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
         * </p>
         * <p>
         * Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.
         * </p>
         * <p>
         * The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python
         * shell job or an Apache Spark ETL job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either
         * 0.0625 or 1 DPU. The default is 0.0625 DPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark streaming
         * ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate a minimum of 2 DPUs. The default is
         * 10 DPUs. This job type cannot have a fractional DPU allocation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should
         * specify a <code>Worker type</code> and the <code>Number of workers</code>.
         * </p>
         * 
         * @param maxCapacity
         *        For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data
         *        processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of
         *        processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
         *        information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.</p>
         *        <p>
         *        Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>
         *        .
         *        </p>
         *        <p>
         *        The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a
         *        Python shell job or an Apache Spark ETL job:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate
         *        either 0.0625 or 1 DPU. The default is 0.0625 DPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark
         *        streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate a minimum of 2
         *        DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you
         *        should specify a <code>Worker type</code> and the <code>Number of workers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used with this job.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The tags to use with this job. You may use tags to limit access to the job. For more information about tags
         * in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags
         * in Glue</a> in the developer guide.
         * </p>
         * 
         * @param tags
         *        The tags to use with this job. You may use tags to limit access to the job. For more information about
         *        tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web
         *        Services Tags in Glue</a> in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies configuration properties of a job notification.
         * </p>
         * 
         * @param notificationProperty
         *        Specifies configuration properties of a job notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationProperty(NotificationProperty notificationProperty);

        /**
         * <p>
         * Specifies configuration properties of a job notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationProperty.Builder} avoiding
         * the need to create one manually via {@link NotificationProperty#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationProperty(NotificationProperty)}.
         * 
         * @param notificationProperty
         *        a consumer that will call methods on {@link NotificationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationProperty(NotificationProperty)
         */
        default Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return notificationProperty(NotificationProperty.builder().applyMutation(notificationProperty).build());
        }

        /**
         * <p>
         * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         * indicates the version supported for jobs of type Spark.
         * </p>
         * <p>
         * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         * </p>
         * <p>
         * Jobs that are created without specifying a Glue version default to Glue 0.9.
         * </p>
         * 
         * @param glueVersion
         *        Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         *        indicates the version supported for jobs of type Spark. </p>
         *        <p>
         *        For more information about the available Glue versions and corresponding Spark and Python versions,
         *        see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the
         *        developer guide.
         *        </p>
         *        <p>
         *        Jobs that are created without specifying a Glue version default to Glue 0.9.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or
         * G.025X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk),
         * and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker
         * type is only available for Glue version 3.0 streaming jobs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X,
         *        G.2X, or G.025X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for low volume streaming
         *        jobs. This worker type is only available for Glue version 3.0 streaming jobs.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or
         * G.025X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk),
         * and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker
         * type is only available for Glue version 3.0 streaming jobs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X,
         *        G.2X, or G.025X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for low volume streaming
         *        jobs. This worker type is only available for Glue version 3.0 streaming jobs.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * The representation of a directed acyclic graph on which both the Glue Studio visual component and Glue Studio
         * code generation is based.
         * </p>
         * 
         * @param codeGenConfigurationNodes
         *        The representation of a directed acyclic graph on which both the Glue Studio visual component and Glue
         *        Studio code generation is based.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeGenConfigurationNodes(Map<String, CodeGenConfigurationNode> codeGenConfigurationNodes);

        /**
         * <p>
         * Indicates whether the job is run with a standard or flexible execution class. The standard execution-class is
         * ideal for time-sensitive workloads that require fast job startup and dedicated resources.
         * </p>
         * <p>
         * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may
         * vary.
         * </p>
         * <p>
         * Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
         * <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark jobs.
         * </p>
         * 
         * @param executionClass
         *        Indicates whether the job is run with a standard or flexible execution class. The standard
         *        execution-class is ideal for time-sensitive workloads that require fast job startup and dedicated
         *        resources.</p>
         *        <p>
         *        The flexible execution class is appropriate for time-insensitive jobs whose start and completion times
         *        may vary.
         *        </p>
         *        <p>
         *        Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
         *        <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark
         *        jobs.
         * @see ExecutionClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionClass
         */
        Builder executionClass(String executionClass);

        /**
         * <p>
         * Indicates whether the job is run with a standard or flexible execution class. The standard execution-class is
         * ideal for time-sensitive workloads that require fast job startup and dedicated resources.
         * </p>
         * <p>
         * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may
         * vary.
         * </p>
         * <p>
         * Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
         * <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark jobs.
         * </p>
         * 
         * @param executionClass
         *        Indicates whether the job is run with a standard or flexible execution class. The standard
         *        execution-class is ideal for time-sensitive workloads that require fast job startup and dedicated
         *        resources.</p>
         *        <p>
         *        The flexible execution class is appropriate for time-insensitive jobs whose start and completion times
         *        may vary.
         *        </p>
         *        <p>
         *        Only jobs with Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set
         *        <code>ExecutionClass</code> to <code>FLEX</code>. The flexible execution class is available for Spark
         *        jobs.
         * @see ExecutionClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionClass
         */
        Builder executionClass(ExecutionClass executionClass);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String logUri;

        private String role;

        private ExecutionProperty executionProperty;

        private JobCommand command;

        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> nonOverridableArguments = DefaultSdkAutoConstructMap.getInstance();

        private ConnectionsList connections;

        private Integer maxRetries;

        private Integer allocatedCapacity;

        private Integer timeout;

        private Double maxCapacity;

        private String securityConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private NotificationProperty notificationProperty;

        private String glueVersion;

        private Integer numberOfWorkers;

        private String workerType;

        private Map<String, CodeGenConfigurationNode> codeGenConfigurationNodes = DefaultSdkAutoConstructMap.getInstance();

        private String executionClass;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            logUri(model.logUri);
            role(model.role);
            executionProperty(model.executionProperty);
            command(model.command);
            defaultArguments(model.defaultArguments);
            nonOverridableArguments(model.nonOverridableArguments);
            connections(model.connections);
            maxRetries(model.maxRetries);
            allocatedCapacity(model.allocatedCapacity);
            timeout(model.timeout);
            maxCapacity(model.maxCapacity);
            securityConfiguration(model.securityConfiguration);
            tags(model.tags);
            notificationProperty(model.notificationProperty);
            glueVersion(model.glueVersion);
            numberOfWorkers(model.numberOfWorkers);
            workerType(model.workerType);
            codeGenConfigurationNodes(model.codeGenConfigurationNodes);
            executionClass(model.executionClass);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final ExecutionProperty.Builder getExecutionProperty() {
            return executionProperty != null ? executionProperty.toBuilder() : null;
        }

        public final void setExecutionProperty(ExecutionProperty.BuilderImpl executionProperty) {
            this.executionProperty = executionProperty != null ? executionProperty.build() : null;
        }

        @Override
        public final Builder executionProperty(ExecutionProperty executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        public final JobCommand.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        public final void setCommand(JobCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(JobCommand command) {
            this.command = command;
            return this;
        }

        public final Map<String, String> getDefaultArguments() {
            if (defaultArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return defaultArguments;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
            return this;
        }

        public final Map<String, String> getNonOverridableArguments() {
            if (nonOverridableArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return nonOverridableArguments;
        }

        public final void setNonOverridableArguments(Map<String, String> nonOverridableArguments) {
            this.nonOverridableArguments = GenericMapCopier.copy(nonOverridableArguments);
        }

        @Override
        public final Builder nonOverridableArguments(Map<String, String> nonOverridableArguments) {
            this.nonOverridableArguments = GenericMapCopier.copy(nonOverridableArguments);
            return this;
        }

        public final ConnectionsList.Builder getConnections() {
            return connections != null ? connections.toBuilder() : null;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Deprecated
        public final Integer getAllocatedCapacity() {
            return allocatedCapacity;
        }

        @Deprecated
        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        @Override
        @Deprecated
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return notificationProperty != null ? notificationProperty.toBuilder() : null;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final Map<String, CodeGenConfigurationNode.Builder> getCodeGenConfigurationNodes() {
            Map<String, CodeGenConfigurationNode.Builder> result = CodeGenConfigurationNodesCopier
                    .copyToBuilder(this.codeGenConfigurationNodes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCodeGenConfigurationNodes(Map<String, CodeGenConfigurationNode.BuilderImpl> codeGenConfigurationNodes) {
            this.codeGenConfigurationNodes = CodeGenConfigurationNodesCopier.copyFromBuilder(codeGenConfigurationNodes);
        }

        @Override
        public final Builder codeGenConfigurationNodes(Map<String, CodeGenConfigurationNode> codeGenConfigurationNodes) {
            this.codeGenConfigurationNodes = CodeGenConfigurationNodesCopier.copy(codeGenConfigurationNodes);
            return this;
        }

        public final String getExecutionClass() {
            return executionClass;
        }

        public final void setExecutionClass(String executionClass) {
            this.executionClass = executionClass;
        }

        @Override
        public final Builder executionClass(String executionClass) {
            this.executionClass = executionClass;
            return this;
        }

        @Override
        public final Builder executionClass(ExecutionClass executionClass) {
            this.executionClass(executionClass == null ? null : executionClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
