/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that uses custom code you provide to perform the data transformation. The output is a
 * collection of DynamicFrames.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomCode implements SdkPojo, Serializable, ToCopyableBuilder<CustomCode.Builder, CustomCode> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomCode::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(CustomCode::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(CustomCode::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClassName").getter(getter(CustomCode::className)).setter(setter(Builder::className))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(CustomCode::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            CODE_FIELD, CLASS_NAME_FIELD, OUTPUT_SCHEMAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String code;

    private final String className;

    private final List<GlueSchema> outputSchemas;

    private CustomCode(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.code = builder.code;
        this.className = builder.className;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The custom code that is used to perform the data transformation.
     * </p>
     * 
     * @return The custom code that is used to perform the data transformation.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The name defined for the custom code node class.
     * </p>
     * 
     * @return The name defined for the custom code node class.
     */
    public final String className() {
        return className;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the custom code transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the custom code transform.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(className());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCode)) {
            return false;
        }
        CustomCode other = (CustomCode) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(code(), other.code())
                && Objects.equals(className(), other.className()) && hasOutputSchemas() == other.hasOutputSchemas()
                && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomCode").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Code", code()).add("ClassName", className())
                .add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "ClassName":
            return Optional.ofNullable(clazz.cast(className()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomCode, T> g) {
        return obj -> g.apply((CustomCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomCode> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The custom code that is used to perform the data transformation.
         * </p>
         * 
         * @param code
         *        The custom code that is used to perform the data transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The name defined for the custom code node class.
         * </p>
         * 
         * @param className
         *        The name defined for the custom code node class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder className(String className);

        /**
         * <p>
         * Specifies the data schema for the custom code transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the custom code transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the custom code transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the custom code transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the custom code transform.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GlueSchema>.Builder} avoiding the
         * need to create one manually via {@link List<GlueSchema>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlueSchema>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on {@link List<GlueSchema>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(List<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String code;

        private String className;

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomCode model) {
            name(model.name);
            inputs(model.inputs);
            code(model.code);
            className(model.className);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getClassName() {
            return className;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomCode build() {
            return new CustomCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
