/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a direct Amazon Kinesis data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectKinesisSource implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectKinesisSource.Builder, DirectKinesisSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DirectKinesisSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WindowSize").getter(getter(DirectKinesisSource::windowSize)).setter(setter(Builder::windowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()).build();

    private static final SdkField<Boolean> DETECT_SCHEMA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetectSchema").getter(getter(DirectKinesisSource::detectSchema)).setter(setter(Builder::detectSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectSchema").build()).build();

    private static final SdkField<KinesisStreamingSourceOptions> STREAMING_OPTIONS_FIELD = SdkField
            .<KinesisStreamingSourceOptions> builder(MarshallingType.SDK_POJO).memberName("StreamingOptions")
            .getter(getter(DirectKinesisSource::streamingOptions)).setter(setter(Builder::streamingOptions))
            .constructor(KinesisStreamingSourceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingOptions").build()).build();

    private static final SdkField<StreamingDataPreviewOptions> DATA_PREVIEW_OPTIONS_FIELD = SdkField
            .<StreamingDataPreviewOptions> builder(MarshallingType.SDK_POJO).memberName("DataPreviewOptions")
            .getter(getter(DirectKinesisSource::dataPreviewOptions)).setter(setter(Builder::dataPreviewOptions))
            .constructor(StreamingDataPreviewOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreviewOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WINDOW_SIZE_FIELD,
            DETECT_SCHEMA_FIELD, STREAMING_OPTIONS_FIELD, DATA_PREVIEW_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer windowSize;

    private final Boolean detectSchema;

    private final KinesisStreamingSourceOptions streamingOptions;

    private final StreamingDataPreviewOptions dataPreviewOptions;

    private DirectKinesisSource(BuilderImpl builder) {
        this.name = builder.name;
        this.windowSize = builder.windowSize;
        this.detectSchema = builder.detectSchema;
        this.streamingOptions = builder.streamingOptions;
        this.dataPreviewOptions = builder.dataPreviewOptions;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The amount of time to spend processing each micro batch.
     * </p>
     * 
     * @return The amount of time to spend processing each micro batch.
     */
    public final Integer windowSize() {
        return windowSize;
    }

    /**
     * <p>
     * Whether to automatically determine the schema from the incoming data.
     * </p>
     * 
     * @return Whether to automatically determine the schema from the incoming data.
     */
    public final Boolean detectSchema() {
        return detectSchema;
    }

    /**
     * <p>
     * Additional options for the Kinesis streaming data source.
     * </p>
     * 
     * @return Additional options for the Kinesis streaming data source.
     */
    public final KinesisStreamingSourceOptions streamingOptions() {
        return streamingOptions;
    }

    /**
     * <p>
     * Additional options for data preview.
     * </p>
     * 
     * @return Additional options for data preview.
     */
    public final StreamingDataPreviewOptions dataPreviewOptions() {
        return dataPreviewOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(windowSize());
        hashCode = 31 * hashCode + Objects.hashCode(detectSchema());
        hashCode = 31 * hashCode + Objects.hashCode(streamingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataPreviewOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectKinesisSource)) {
            return false;
        }
        DirectKinesisSource other = (DirectKinesisSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(windowSize(), other.windowSize())
                && Objects.equals(detectSchema(), other.detectSchema())
                && Objects.equals(streamingOptions(), other.streamingOptions())
                && Objects.equals(dataPreviewOptions(), other.dataPreviewOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectKinesisSource").add("Name", name()).add("WindowSize", windowSize())
                .add("DetectSchema", detectSchema()).add("StreamingOptions", streamingOptions())
                .add("DataPreviewOptions", dataPreviewOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "WindowSize":
            return Optional.ofNullable(clazz.cast(windowSize()));
        case "DetectSchema":
            return Optional.ofNullable(clazz.cast(detectSchema()));
        case "StreamingOptions":
            return Optional.ofNullable(clazz.cast(streamingOptions()));
        case "DataPreviewOptions":
            return Optional.ofNullable(clazz.cast(dataPreviewOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectKinesisSource, T> g) {
        return obj -> g.apply((DirectKinesisSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectKinesisSource> {
        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The amount of time to spend processing each micro batch.
         * </p>
         * 
         * @param windowSize
         *        The amount of time to spend processing each micro batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowSize(Integer windowSize);

        /**
         * <p>
         * Whether to automatically determine the schema from the incoming data.
         * </p>
         * 
         * @param detectSchema
         *        Whether to automatically determine the schema from the incoming data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectSchema(Boolean detectSchema);

        /**
         * <p>
         * Additional options for the Kinesis streaming data source.
         * </p>
         * 
         * @param streamingOptions
         *        Additional options for the Kinesis streaming data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingOptions(KinesisStreamingSourceOptions streamingOptions);

        /**
         * <p>
         * Additional options for the Kinesis streaming data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamingSourceOptions.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamingSourceOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamingSourceOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingOptions(KinesisStreamingSourceOptions)}.
         * 
         * @param streamingOptions
         *        a consumer that will call methods on {@link KinesisStreamingSourceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingOptions(KinesisStreamingSourceOptions)
         */
        default Builder streamingOptions(Consumer<KinesisStreamingSourceOptions.Builder> streamingOptions) {
            return streamingOptions(KinesisStreamingSourceOptions.builder().applyMutation(streamingOptions).build());
        }

        /**
         * <p>
         * Additional options for data preview.
         * </p>
         * 
         * @param dataPreviewOptions
         *        Additional options for data preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions);

        /**
         * <p>
         * Additional options for data preview.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingDataPreviewOptions.Builder}
         * avoiding the need to create one manually via {@link StreamingDataPreviewOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDataPreviewOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #dataPreviewOptions(StreamingDataPreviewOptions)}.
         * 
         * @param dataPreviewOptions
         *        a consumer that will call methods on {@link StreamingDataPreviewOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPreviewOptions(StreamingDataPreviewOptions)
         */
        default Builder dataPreviewOptions(Consumer<StreamingDataPreviewOptions.Builder> dataPreviewOptions) {
            return dataPreviewOptions(StreamingDataPreviewOptions.builder().applyMutation(dataPreviewOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer windowSize;

        private Boolean detectSchema;

        private KinesisStreamingSourceOptions streamingOptions;

        private StreamingDataPreviewOptions dataPreviewOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectKinesisSource model) {
            name(model.name);
            windowSize(model.windowSize);
            detectSchema(model.detectSchema);
            streamingOptions(model.streamingOptions);
            dataPreviewOptions(model.dataPreviewOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getWindowSize() {
            return windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public final Boolean getDetectSchema() {
            return detectSchema;
        }

        public final void setDetectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
        }

        @Override
        public final Builder detectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
            return this;
        }

        public final KinesisStreamingSourceOptions.Builder getStreamingOptions() {
            return streamingOptions != null ? streamingOptions.toBuilder() : null;
        }

        public final void setStreamingOptions(KinesisStreamingSourceOptions.BuilderImpl streamingOptions) {
            this.streamingOptions = streamingOptions != null ? streamingOptions.build() : null;
        }

        @Override
        public final Builder streamingOptions(KinesisStreamingSourceOptions streamingOptions) {
            this.streamingOptions = streamingOptions;
            return this;
        }

        public final StreamingDataPreviewOptions.Builder getDataPreviewOptions() {
            return dataPreviewOptions != null ? dataPreviewOptions.toBuilder() : null;
        }

        public final void setDataPreviewOptions(StreamingDataPreviewOptions.BuilderImpl dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions != null ? dataPreviewOptions.build() : null;
        }

        @Override
        public final Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions;
            return this;
        }

        @Override
        public DirectKinesisSource build() {
            return new DirectKinesisSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
