/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredTableMetadataRequest extends GlueRequest implements
        ToCopyableBuilder<GetUnfilteredTableMetadataRequest.Builder, GetUnfilteredTableMetadataRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetUnfilteredTableMetadataRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetUnfilteredTableMetadataRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetUnfilteredTableMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.<AuditContext> builder(MarshallingType.SDK_POJO)
            .memberName("AuditContext").getter(getter(GetUnfilteredTableMetadataRequest::auditContext))
            .setter(setter(Builder::auditContext)).constructor(AuditContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()).build();

    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedPermissionTypes")
            .getter(getter(GetUnfilteredTableMetadataRequest::supportedPermissionTypesAsStrings))
            .setter(setter(Builder::supportedPermissionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, NAME_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String name;

    private final AuditContext auditContext;

    private final List<String> supportedPermissionTypes;

    private GetUnfilteredTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
    }

    /**
     * Returns the value of the CatalogId property for this object.
     * 
     * @return The value of the CatalogId property for this object.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * Returns the value of the DatabaseName property for this object.
     * 
     * @return The value of the DatabaseName property for this object.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the AuditContext property for this object.
     * 
     * @return The value of the AuditContext property for this object.
     */
    public final AuditContext auditContext() {
        return auditContext;
    }

    /**
     * Returns the value of the SupportedPermissionTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return The value of the SupportedPermissionTypes property for this object.
     */
    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(supportedPermissionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedPermissionTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedPermissionTypes() {
        return supportedPermissionTypes != null && !(supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SupportedPermissionTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return The value of the SupportedPermissionTypes property for this object.
     */
    public final List<String> supportedPermissionTypesAsStrings() {
        return supportedPermissionTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataRequest)) {
            return false;
        }
        GetUnfilteredTableMetadataRequest other = (GetUnfilteredTableMetadataRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(name(), other.name()) && Objects.equals(auditContext(), other.auditContext())
                && hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes()
                && Objects.equals(supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredTableMetadataRequest").add("CatalogId", catalogId())
                .add("DatabaseName", databaseName()).add("Name", name()).add("AuditContext", auditContext())
                .add("SupportedPermissionTypes", hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AuditContext":
            return Optional.ofNullable(clazz.cast(auditContext()));
        case "SupportedPermissionTypes":
            return Optional.ofNullable(clazz.cast(supportedPermissionTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataRequest, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUnfilteredTableMetadataRequest> {
        /**
         * Sets the value of the CatalogId property for this object.
         *
         * @param catalogId
         *        The new value for the CatalogId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * Sets the value of the DatabaseName property for this object.
         *
         * @param databaseName
         *        The new value for the DatabaseName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the AuditContext property for this object.
         *
         * @param auditContext
         *        The new value for the AuditContext property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditContext(AuditContext auditContext);

        /**
         * Sets the value of the AuditContext property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AuditContext.Builder} avoiding the need
         * to create one manually via {@link AuditContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuditContext.Builder#build()} is called immediately and its
         * result is passed to {@link #auditContext(AuditContext)}.
         * 
         * @param auditContext
         *        a consumer that will call methods on {@link AuditContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditContext(AuditContext)
         */
        default Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return auditContext(AuditContext.builder().applyMutation(auditContext).build());
        }

        /**
         * Sets the value of the SupportedPermissionTypes property for this object.
         *
         * @param supportedPermissionTypes
         *        The new value for the SupportedPermissionTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes);

        /**
         * Sets the value of the SupportedPermissionTypes property for this object.
         *
         * @param supportedPermissionTypes
         *        The new value for the SupportedPermissionTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes);

        /**
         * Sets the value of the SupportedPermissionTypes property for this object.
         *
         * @param supportedPermissionTypes
         *        The new value for the SupportedPermissionTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes);

        /**
         * Sets the value of the SupportedPermissionTypes property for this object.
         *
         * @param supportedPermissionTypes
         *        The new value for the SupportedPermissionTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String name;

        private AuditContext auditContext;

        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            name(model.name);
            auditContext(model.auditContext);
            supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return auditContext != null ? auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes) {
            supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes) {
            supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataRequest build() {
            return new GetUnfilteredTableMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
