/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the predicate of the trigger, which determines when it fires.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Predicate implements SdkPojo, Serializable, ToCopyableBuilder<Predicate.Builder, Predicate> {
    private static final SdkField<String> LOGICAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Logical")
            .getter(getter(Predicate::logicalAsString)).setter(setter(Builder::logical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logical").build()).build();

    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField
            .<List<Condition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(Predicate::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_FIELD,
            CONDITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logical;

    private final List<Condition> conditions;

    private Predicate(BuilderImpl builder) {
        this.logical = builder.logical;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * An optional field if only one condition is listed. If multiple conditions are listed, then this field is
     * required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logical} will
     * return {@link Logical#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logicalAsString}.
     * </p>
     * 
     * @return An optional field if only one condition is listed. If multiple conditions are listed, then this field is
     *         required.
     * @see Logical
     */
    public final Logical logical() {
        return Logical.fromValue(logical);
    }

    /**
     * <p>
     * An optional field if only one condition is listed. If multiple conditions are listed, then this field is
     * required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logical} will
     * return {@link Logical#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logicalAsString}.
     * </p>
     * 
     * @return An optional field if only one condition is listed. If multiple conditions are listed, then this field is
     *         required.
     * @see Logical
     */
    public final String logicalAsString() {
        return logical;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the conditions that determine when the trigger will fire.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return A list of the conditions that determine when the trigger will fire.
     */
    public final List<Condition> conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate) obj;
        return Objects.equals(logicalAsString(), other.logicalAsString()) && hasConditions() == other.hasConditions()
                && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Predicate").add("Logical", logicalAsString())
                .add("Conditions", hasConditions() ? conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Logical":
            return Optional.ofNullable(clazz.cast(logicalAsString()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Predicate> {
        /**
         * <p>
         * An optional field if only one condition is listed. If multiple conditions are listed, then this field is
         * required.
         * </p>
         * 
         * @param logical
         *        An optional field if only one condition is listed. If multiple conditions are listed, then this field
         *        is required.
         * @see Logical
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logical
         */
        Builder logical(String logical);

        /**
         * <p>
         * An optional field if only one condition is listed. If multiple conditions are listed, then this field is
         * required.
         * </p>
         * 
         * @param logical
         *        An optional field if only one condition is listed. If multiple conditions are listed, then this field
         *        is required.
         * @see Logical
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logical
         */
        Builder logical(Logical logical);

        /**
         * <p>
         * A list of the conditions that determine when the trigger will fire.
         * </p>
         * 
         * @param conditions
         *        A list of the conditions that determine when the trigger will fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<Condition> conditions);

        /**
         * <p>
         * A list of the conditions that determine when the trigger will fire.
         * </p>
         * 
         * @param conditions
         *        A list of the conditions that determine when the trigger will fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Condition... conditions);

        /**
         * <p>
         * A list of the conditions that determine when the trigger will fire.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Condition>.Builder} avoiding the
         * need to create one manually via {@link List<Condition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Condition>.Builder#build()} is called immediately and its
         * result is passed to {@link #conditions(List<Condition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<Condition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<Condition>)
         */
        Builder conditions(Consumer<Condition.Builder>... conditions);
    }

    static final class BuilderImpl implements Builder {
        private String logical;

        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            logical(model.logical);
            conditions(model.conditions);
        }

        public final String getLogical() {
            return logical;
        }

        public final void setLogical(String logical) {
            this.logical = logical;
        }

        @Override
        public final Builder logical(String logical) {
            this.logical = logical;
            return this;
        }

        @Override
        public final Builder logical(Logical logical) {
            this.logical(logical == null ? null : logical.toString());
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> Condition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Predicate build() {
            return new Predicate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
