/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The period in which a remote Spark runtime environment is running.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Session::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedOn").getter(getter(Session::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Session::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(Session::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Session::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(Session::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<SessionCommand> COMMAND_FIELD = SdkField.<SessionCommand> builder(MarshallingType.SDK_POJO)
            .memberName("Command").getter(getter(Session::command)).setter(setter(Builder::command))
            .constructor(SessionCommand::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()).build();

    private static final SdkField<Map<String, String>> DEFAULT_ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DefaultArguments")
            .getter(getter(Session::defaultArguments))
            .setter(setter(Builder::defaultArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultArguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConnectionsList> CONNECTIONS_FIELD = SdkField
            .<ConnectionsList> builder(MarshallingType.SDK_POJO).memberName("Connections").getter(getter(Session::connections))
            .setter(setter(Builder::connections)).constructor(ConnectionsList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build()).build();

    private static final SdkField<Double> PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Progress").getter(getter(Session::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(Session::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(Session::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(Session::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATED_ON_FIELD,
            STATUS_FIELD, ERROR_MESSAGE_FIELD, DESCRIPTION_FIELD, ROLE_FIELD, COMMAND_FIELD, DEFAULT_ARGUMENTS_FIELD,
            CONNECTIONS_FIELD, PROGRESS_FIELD, MAX_CAPACITY_FIELD, SECURITY_CONFIGURATION_FIELD, GLUE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant createdOn;

    private final String status;

    private final String errorMessage;

    private final String description;

    private final String role;

    private final SessionCommand command;

    private final Map<String, String> defaultArguments;

    private final ConnectionsList connections;

    private final Double progress;

    private final Double maxCapacity;

    private final String securityConfiguration;

    private final String glueVersion;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.createdOn = builder.createdOn;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.description = builder.description;
        this.role = builder.role;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.connections = builder.connections;
        this.progress = builder.progress;
        this.maxCapacity = builder.maxCapacity;
        this.securityConfiguration = builder.securityConfiguration;
        this.glueVersion = builder.glueVersion;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time and date when the session was created.
     * </p>
     * 
     * @return The time and date when the session was created.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The session status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The session status.
     * @see SessionStatus
     */
    public final SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The session status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The session status.
     * @see SessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message displayed during the session.
     * </p>
     * 
     * @return The error message displayed during the session.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The description of the session.
     * </p>
     * 
     * @return The description of the session.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role associated with the Session.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role associated with the Session.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The command object.See SessionCommand.
     * </p>
     * 
     * @return The command object.See SessionCommand.
     */
    public final SessionCommand command() {
        return command;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultArguments() {
        return defaultArguments != null && !(defaultArguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map array of key-value pairs. Max is 75 pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultArguments} method.
     * </p>
     * 
     * @return A map array of key-value pairs. Max is 75 pairs.
     */
    public final Map<String, String> defaultArguments() {
        return defaultArguments;
    }

    /**
     * <p>
     * The number of connections used for the session.
     * </p>
     * 
     * @return The number of connections used for the session.
     */
    public final ConnectionsList connections() {
        return connections;
    }

    /**
     * <p>
     * The code execution progress of the session.
     * </p>
     * 
     * @return The code execution progress of the session.
     */
    public final Double progress() {
        return progress;
    }

    /**
     * <p>
     * The number of Glue data processing units (DPUs) that can be allocated when the job runs. A DPU is a relative
     * measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB memory.
     * </p>
     * 
     * @return The number of Glue data processing units (DPUs) that can be allocated when the job runs. A DPU is a
     *         relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB memory.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The name of the SecurityConfiguration structure to be used with the session.
     * </p>
     * 
     * @return The name of the SecurityConfiguration structure to be used with the session.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * The Glue version determines the versions of Apache Spark and Python that Glue supports. The GlueVersion must be
     * greater than 2.0.
     * </p>
     * 
     * @return The Glue version determines the versions of Apache Spark and Python that Glue supports. The GlueVersion
     *         must be greater than 2.0.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultArguments() ? defaultArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connections());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(createdOn(), other.createdOn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(description(), other.description())
                && Objects.equals(role(), other.role()) && Objects.equals(command(), other.command())
                && hasDefaultArguments() == other.hasDefaultArguments()
                && Objects.equals(defaultArguments(), other.defaultArguments())
                && Objects.equals(connections(), other.connections()) && Objects.equals(progress(), other.progress())
                && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(glueVersion(), other.glueVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Session").add("Id", id()).add("CreatedOn", createdOn()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("Description", description()).add("Role", role())
                .add("Command", command()).add("DefaultArguments", hasDefaultArguments() ? defaultArguments() : null)
                .add("Connections", connections()).add("Progress", progress()).add("MaxCapacity", maxCapacity())
                .add("SecurityConfiguration", securityConfiguration()).add("GlueVersion", glueVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatedOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "DefaultArguments":
            return Optional.ofNullable(clazz.cast(defaultArguments()));
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param id
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time and date when the session was created.
         * </p>
         * 
         * @param createdOn
         *        The time and date when the session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The session status.
         * </p>
         * 
         * @param status
         *        The session status.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The session status.
         * </p>
         * 
         * @param status
         *        The session status.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * The error message displayed during the session.
         * </p>
         * 
         * @param errorMessage
         *        The error message displayed during the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The description of the session.
         * </p>
         * 
         * @param description
         *        The description of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role associated with the Session.
         * </p>
         * 
         * @param role
         *        The name or Amazon Resource Name (ARN) of the IAM role associated with the Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The command object.See SessionCommand.
         * </p>
         * 
         * @param command
         *        The command object.See SessionCommand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(SessionCommand command);

        /**
         * <p>
         * The command object.See SessionCommand.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionCommand.Builder} avoiding the need
         * to create one manually via {@link SessionCommand#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionCommand.Builder#build()} is called immediately and its
         * result is passed to {@link #command(SessionCommand)}.
         * 
         * @param command
         *        a consumer that will call methods on {@link SessionCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #command(SessionCommand)
         */
        default Builder command(Consumer<SessionCommand.Builder> command) {
            return command(SessionCommand.builder().applyMutation(command).build());
        }

        /**
         * <p>
         * A map array of key-value pairs. Max is 75 pairs.
         * </p>
         * 
         * @param defaultArguments
         *        A map array of key-value pairs. Max is 75 pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultArguments(Map<String, String> defaultArguments);

        /**
         * <p>
         * The number of connections used for the session.
         * </p>
         * 
         * @param connections
         *        The number of connections used for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(ConnectionsList connections);

        /**
         * <p>
         * The number of connections used for the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionsList.Builder} avoiding the
         * need to create one manually via {@link ConnectionsList#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionsList.Builder#build()} is called immediately and its
         * result is passed to {@link #connections(ConnectionsList)}.
         * 
         * @param connections
         *        a consumer that will call methods on {@link ConnectionsList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(ConnectionsList)
         */
        default Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return connections(ConnectionsList.builder().applyMutation(connections).build());
        }

        /**
         * <p>
         * The code execution progress of the session.
         * </p>
         * 
         * @param progress
         *        The code execution progress of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Double progress);

        /**
         * <p>
         * The number of Glue data processing units (DPUs) that can be allocated when the job runs. A DPU is a relative
         * measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB memory.
         * </p>
         * 
         * @param maxCapacity
         *        The number of Glue data processing units (DPUs) that can be allocated when the job runs. A DPU is a
         *        relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The name of the SecurityConfiguration structure to be used with the session.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the SecurityConfiguration structure to be used with the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The Glue version determines the versions of Apache Spark and Python that Glue supports. The GlueVersion must
         * be greater than 2.0.
         * </p>
         * 
         * @param glueVersion
         *        The Glue version determines the versions of Apache Spark and Python that Glue supports. The
         *        GlueVersion must be greater than 2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant createdOn;

        private String status;

        private String errorMessage;

        private String description;

        private String role;

        private SessionCommand command;

        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();

        private ConnectionsList connections;

        private Double progress;

        private Double maxCapacity;

        private String securityConfiguration;

        private String glueVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            id(model.id);
            createdOn(model.createdOn);
            status(model.status);
            errorMessage(model.errorMessage);
            description(model.description);
            role(model.role);
            command(model.command);
            defaultArguments(model.defaultArguments);
            connections(model.connections);
            progress(model.progress);
            maxCapacity(model.maxCapacity);
            securityConfiguration(model.securityConfiguration);
            glueVersion(model.glueVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final SessionCommand.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        public final void setCommand(SessionCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(SessionCommand command) {
            this.command = command;
            return this;
        }

        public final Map<String, String> getDefaultArguments() {
            if (defaultArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return defaultArguments;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
            return this;
        }

        public final ConnectionsList.Builder getConnections() {
            return connections != null ? connections.toBuilder() : null;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final Double getProgress() {
            return progress;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
