/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statement or request for a particular action to occur in a session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statement implements SdkPojo, Serializable, ToCopyableBuilder<Statement.Builder, Statement> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(Statement::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(Statement::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Statement::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<StatementOutput> OUTPUT_FIELD = SdkField.<StatementOutput> builder(MarshallingType.SDK_POJO)
            .memberName("Output").getter(getter(Statement::output)).setter(setter(Builder::output))
            .constructor(StatementOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<Double> PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Progress").getter(getter(Statement::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final SdkField<Long> STARTED_ON_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("StartedOn")
            .getter(getter(Statement::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Long> COMPLETED_ON_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CompletedOn").getter(getter(Statement::completedOn)).setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CODE_FIELD,
            STATE_FIELD, OUTPUT_FIELD, PROGRESS_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String code;

    private final String state;

    private final StatementOutput output;

    private final Double progress;

    private final Long startedOn;

    private final Long completedOn;

    private Statement(BuilderImpl builder) {
        this.id = builder.id;
        this.code = builder.code;
        this.state = builder.state;
        this.output = builder.output;
        this.progress = builder.progress;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
    }

    /**
     * <p>
     * The ID of the statement.
     * </p>
     * 
     * @return The ID of the statement.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The execution code of the statement.
     * </p>
     * 
     * @return The execution code of the statement.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The state while request is actioned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StatementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state while request is actioned.
     * @see StatementState
     */
    public final StatementState state() {
        return StatementState.fromValue(state);
    }

    /**
     * <p>
     * The state while request is actioned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StatementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state while request is actioned.
     * @see StatementState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The output in JSON.
     * </p>
     * 
     * @return The output in JSON.
     */
    public final StatementOutput output() {
        return output;
    }

    /**
     * <p>
     * The code execution progress.
     * </p>
     * 
     * @return The code execution progress.
     */
    public final Double progress() {
        return progress;
    }

    /**
     * <p>
     * The unix time and date that the job definition was started.
     * </p>
     * 
     * @return The unix time and date that the job definition was started.
     */
    public final Long startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The unix time and date that the job definition was completed.
     * </p>
     * 
     * @return The unix time and date that the job definition was completed.
     */
    public final Long completedOn() {
        return completedOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(code(), other.code())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(output(), other.output())
                && Objects.equals(progress(), other.progress()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(completedOn(), other.completedOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statement").add("Id", id()).add("Code", code()).add("State", stateAsString())
                .add("Output", output()).add("Progress", progress()).add("StartedOn", startedOn())
                .add("CompletedOn", completedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statement, T> g) {
        return obj -> g.apply((Statement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statement> {
        /**
         * <p>
         * The ID of the statement.
         * </p>
         * 
         * @param id
         *        The ID of the statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The execution code of the statement.
         * </p>
         * 
         * @param code
         *        The execution code of the statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The state while request is actioned.
         * </p>
         * 
         * @param state
         *        The state while request is actioned.
         * @see StatementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementState
         */
        Builder state(String state);

        /**
         * <p>
         * The state while request is actioned.
         * </p>
         * 
         * @param state
         *        The state while request is actioned.
         * @see StatementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementState
         */
        Builder state(StatementState state);

        /**
         * <p>
         * The output in JSON.
         * </p>
         * 
         * @param output
         *        The output in JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(StatementOutput output);

        /**
         * <p>
         * The output in JSON.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatementOutput.Builder} avoiding the
         * need to create one manually via {@link StatementOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatementOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #output(StatementOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link StatementOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(StatementOutput)
         */
        default Builder output(Consumer<StatementOutput.Builder> output) {
            return output(StatementOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * The code execution progress.
         * </p>
         * 
         * @param progress
         *        The code execution progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Double progress);

        /**
         * <p>
         * The unix time and date that the job definition was started.
         * </p>
         * 
         * @param startedOn
         *        The unix time and date that the job definition was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Long startedOn);

        /**
         * <p>
         * The unix time and date that the job definition was completed.
         * </p>
         * 
         * @param completedOn
         *        The unix time and date that the job definition was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Long completedOn);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String code;

        private String state;

        private StatementOutput output;

        private Double progress;

        private Long startedOn;

        private Long completedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            id(model.id);
            code(model.code);
            state(model.state);
            output(model.output);
            progress(model.progress);
            startedOn(model.startedOn);
            completedOn(model.completedOn);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StatementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StatementOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(StatementOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(StatementOutput output) {
            this.output = output;
            return this;
        }

        public final Double getProgress() {
            return progress;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final Long getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Long startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Long startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Long getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Long completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Long completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        @Override
        public Statement build() {
            return new Statement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
