/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueprintDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<BlueprintDetails.Builder, BlueprintDetails> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintName").getter(getter(BlueprintDetails::blueprintName)).setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(BlueprintDetails::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD,
            RUN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blueprintName;

    private final String runId;

    private BlueprintDetails(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The run ID for this blueprint.
     * </p>
     * 
     * @return The run ID for this blueprint.
     */
    public final String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintDetails)) {
            return false;
        }
        BlueprintDetails other = (BlueprintDetails) obj;
        return Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(runId(), other.runId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueprintDetails").add("BlueprintName", blueprintName()).add("RunId", runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlueprintDetails, T> g) {
        return obj -> g.apply((BlueprintDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueprintDetails> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param blueprintName
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The run ID for this blueprint.
         * </p>
         * 
         * @param runId
         *        The run ID for this blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintName;

        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintDetails model) {
            blueprintName(model.blueprintName);
            runId(model.runId);
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        @Transient
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        @Transient
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public BlueprintDetails build() {
            return new BlueprintDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
