/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the individual types of column statistics data. Only one data object should be set and indicated by the
 * <code>Type</code> attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatisticsData.Builder, ColumnStatisticsData> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ColumnStatisticsData::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<BooleanColumnStatisticsData> BOOLEAN_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<BooleanColumnStatisticsData> builder(MarshallingType.SDK_POJO)
            .memberName("BooleanColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::booleanColumnStatisticsData))
            .setter(setter(Builder::booleanColumnStatisticsData))
            .constructor(BooleanColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanColumnStatisticsData")
                    .build()).build();

    private static final SdkField<DateColumnStatisticsData> DATE_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<DateColumnStatisticsData> builder(MarshallingType.SDK_POJO).memberName("DateColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::dateColumnStatisticsData)).setter(setter(Builder::dateColumnStatisticsData))
            .constructor(DateColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateColumnStatisticsData").build())
            .build();

    private static final SdkField<DecimalColumnStatisticsData> DECIMAL_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<DecimalColumnStatisticsData> builder(MarshallingType.SDK_POJO)
            .memberName("DecimalColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::decimalColumnStatisticsData))
            .setter(setter(Builder::decimalColumnStatisticsData))
            .constructor(DecimalColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalColumnStatisticsData")
                    .build()).build();

    private static final SdkField<DoubleColumnStatisticsData> DOUBLE_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<DoubleColumnStatisticsData> builder(MarshallingType.SDK_POJO)
            .memberName("DoubleColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::doubleColumnStatisticsData))
            .setter(setter(Builder::doubleColumnStatisticsData))
            .constructor(DoubleColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleColumnStatisticsData").build())
            .build();

    private static final SdkField<LongColumnStatisticsData> LONG_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<LongColumnStatisticsData> builder(MarshallingType.SDK_POJO).memberName("LongColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::longColumnStatisticsData)).setter(setter(Builder::longColumnStatisticsData))
            .constructor(LongColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongColumnStatisticsData").build())
            .build();

    private static final SdkField<StringColumnStatisticsData> STRING_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<StringColumnStatisticsData> builder(MarshallingType.SDK_POJO)
            .memberName("StringColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::stringColumnStatisticsData))
            .setter(setter(Builder::stringColumnStatisticsData))
            .constructor(StringColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringColumnStatisticsData").build())
            .build();

    private static final SdkField<BinaryColumnStatisticsData> BINARY_COLUMN_STATISTICS_DATA_FIELD = SdkField
            .<BinaryColumnStatisticsData> builder(MarshallingType.SDK_POJO)
            .memberName("BinaryColumnStatisticsData")
            .getter(getter(ColumnStatisticsData::binaryColumnStatisticsData))
            .setter(setter(Builder::binaryColumnStatisticsData))
            .constructor(BinaryColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryColumnStatisticsData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            BOOLEAN_COLUMN_STATISTICS_DATA_FIELD, DATE_COLUMN_STATISTICS_DATA_FIELD, DECIMAL_COLUMN_STATISTICS_DATA_FIELD,
            DOUBLE_COLUMN_STATISTICS_DATA_FIELD, LONG_COLUMN_STATISTICS_DATA_FIELD, STRING_COLUMN_STATISTICS_DATA_FIELD,
            BINARY_COLUMN_STATISTICS_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final BooleanColumnStatisticsData booleanColumnStatisticsData;

    private final DateColumnStatisticsData dateColumnStatisticsData;

    private final DecimalColumnStatisticsData decimalColumnStatisticsData;

    private final DoubleColumnStatisticsData doubleColumnStatisticsData;

    private final LongColumnStatisticsData longColumnStatisticsData;

    private final StringColumnStatisticsData stringColumnStatisticsData;

    private final BinaryColumnStatisticsData binaryColumnStatisticsData;

    private ColumnStatisticsData(BuilderImpl builder) {
        this.type = builder.type;
        this.booleanColumnStatisticsData = builder.booleanColumnStatisticsData;
        this.dateColumnStatisticsData = builder.dateColumnStatisticsData;
        this.decimalColumnStatisticsData = builder.decimalColumnStatisticsData;
        this.doubleColumnStatisticsData = builder.doubleColumnStatisticsData;
        this.longColumnStatisticsData = builder.longColumnStatisticsData;
        this.stringColumnStatisticsData = builder.stringColumnStatisticsData;
        this.binaryColumnStatisticsData = builder.binaryColumnStatisticsData;
    }

    /**
     * <p>
     * The type of column statistics data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ColumnStatisticsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of column statistics data.
     * @see ColumnStatisticsType
     */
    public final ColumnStatisticsType type() {
        return ColumnStatisticsType.fromValue(type);
    }

    /**
     * <p>
     * The type of column statistics data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ColumnStatisticsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of column statistics data.
     * @see ColumnStatisticsType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Boolean column statistics data.
     * </p>
     * 
     * @return Boolean column statistics data.
     */
    public final BooleanColumnStatisticsData booleanColumnStatisticsData() {
        return booleanColumnStatisticsData;
    }

    /**
     * <p>
     * Date column statistics data.
     * </p>
     * 
     * @return Date column statistics data.
     */
    public final DateColumnStatisticsData dateColumnStatisticsData() {
        return dateColumnStatisticsData;
    }

    /**
     * <p>
     * Decimal column statistics data.
     * </p>
     * 
     * @return Decimal column statistics data.
     */
    public final DecimalColumnStatisticsData decimalColumnStatisticsData() {
        return decimalColumnStatisticsData;
    }

    /**
     * <p>
     * Double column statistics data.
     * </p>
     * 
     * @return Double column statistics data.
     */
    public final DoubleColumnStatisticsData doubleColumnStatisticsData() {
        return doubleColumnStatisticsData;
    }

    /**
     * <p>
     * Long column statistics data.
     * </p>
     * 
     * @return Long column statistics data.
     */
    public final LongColumnStatisticsData longColumnStatisticsData() {
        return longColumnStatisticsData;
    }

    /**
     * <p>
     * String column statistics data.
     * </p>
     * 
     * @return String column statistics data.
     */
    public final StringColumnStatisticsData stringColumnStatisticsData() {
        return stringColumnStatisticsData;
    }

    /**
     * <p>
     * Binary column statistics data.
     * </p>
     * 
     * @return Binary column statistics data.
     */
    public final BinaryColumnStatisticsData binaryColumnStatisticsData() {
        return binaryColumnStatisticsData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(booleanColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(dateColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(decimalColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(doubleColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(longColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(stringColumnStatisticsData());
        hashCode = 31 * hashCode + Objects.hashCode(binaryColumnStatisticsData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsData)) {
            return false;
        }
        ColumnStatisticsData other = (ColumnStatisticsData) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(booleanColumnStatisticsData(), other.booleanColumnStatisticsData())
                && Objects.equals(dateColumnStatisticsData(), other.dateColumnStatisticsData())
                && Objects.equals(decimalColumnStatisticsData(), other.decimalColumnStatisticsData())
                && Objects.equals(doubleColumnStatisticsData(), other.doubleColumnStatisticsData())
                && Objects.equals(longColumnStatisticsData(), other.longColumnStatisticsData())
                && Objects.equals(stringColumnStatisticsData(), other.stringColumnStatisticsData())
                && Objects.equals(binaryColumnStatisticsData(), other.binaryColumnStatisticsData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatisticsData").add("Type", typeAsString())
                .add("BooleanColumnStatisticsData", booleanColumnStatisticsData())
                .add("DateColumnStatisticsData", dateColumnStatisticsData())
                .add("DecimalColumnStatisticsData", decimalColumnStatisticsData())
                .add("DoubleColumnStatisticsData", doubleColumnStatisticsData())
                .add("LongColumnStatisticsData", longColumnStatisticsData())
                .add("StringColumnStatisticsData", stringColumnStatisticsData())
                .add("BinaryColumnStatisticsData", binaryColumnStatisticsData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "BooleanColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(booleanColumnStatisticsData()));
        case "DateColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(dateColumnStatisticsData()));
        case "DecimalColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(decimalColumnStatisticsData()));
        case "DoubleColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(doubleColumnStatisticsData()));
        case "LongColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(longColumnStatisticsData()));
        case "StringColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(stringColumnStatisticsData()));
        case "BinaryColumnStatisticsData":
            return Optional.ofNullable(clazz.cast(binaryColumnStatisticsData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsData, T> g) {
        return obj -> g.apply((ColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatisticsData> {
        /**
         * <p>
         * The type of column statistics data.
         * </p>
         * 
         * @param type
         *        The type of column statistics data.
         * @see ColumnStatisticsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnStatisticsType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of column statistics data.
         * </p>
         * 
         * @param type
         *        The type of column statistics data.
         * @see ColumnStatisticsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnStatisticsType
         */
        Builder type(ColumnStatisticsType type);

        /**
         * <p>
         * Boolean column statistics data.
         * </p>
         * 
         * @param booleanColumnStatisticsData
         *        Boolean column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanColumnStatisticsData(BooleanColumnStatisticsData booleanColumnStatisticsData);

        /**
         * <p>
         * Boolean column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link BooleanColumnStatisticsData.Builder} avoiding
         * the need to create one manually via {@link BooleanColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link BooleanColumnStatisticsData.Builder#build()} is called
         * immediately and its result is passed to {@link #booleanColumnStatisticsData(BooleanColumnStatisticsData)}.
         * 
         * @param booleanColumnStatisticsData
         *        a consumer that will call methods on {@link BooleanColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanColumnStatisticsData(BooleanColumnStatisticsData)
         */
        default Builder booleanColumnStatisticsData(Consumer<BooleanColumnStatisticsData.Builder> booleanColumnStatisticsData) {
            return booleanColumnStatisticsData(BooleanColumnStatisticsData.builder().applyMutation(booleanColumnStatisticsData)
                    .build());
        }

        /**
         * <p>
         * Date column statistics data.
         * </p>
         * 
         * @param dateColumnStatisticsData
         *        Date column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateColumnStatisticsData(DateColumnStatisticsData dateColumnStatisticsData);

        /**
         * <p>
         * Date column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link DateColumnStatisticsData.Builder} avoiding the
         * need to create one manually via {@link DateColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateColumnStatisticsData.Builder#build()} is called immediately
         * and its result is passed to {@link #dateColumnStatisticsData(DateColumnStatisticsData)}.
         * 
         * @param dateColumnStatisticsData
         *        a consumer that will call methods on {@link DateColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateColumnStatisticsData(DateColumnStatisticsData)
         */
        default Builder dateColumnStatisticsData(Consumer<DateColumnStatisticsData.Builder> dateColumnStatisticsData) {
            return dateColumnStatisticsData(DateColumnStatisticsData.builder().applyMutation(dateColumnStatisticsData).build());
        }

        /**
         * <p>
         * Decimal column statistics data.
         * </p>
         * 
         * @param decimalColumnStatisticsData
         *        Decimal column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalColumnStatisticsData(DecimalColumnStatisticsData decimalColumnStatisticsData);

        /**
         * <p>
         * Decimal column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link DecimalColumnStatisticsData.Builder} avoiding
         * the need to create one manually via {@link DecimalColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link DecimalColumnStatisticsData.Builder#build()} is called
         * immediately and its result is passed to {@link #decimalColumnStatisticsData(DecimalColumnStatisticsData)}.
         * 
         * @param decimalColumnStatisticsData
         *        a consumer that will call methods on {@link DecimalColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalColumnStatisticsData(DecimalColumnStatisticsData)
         */
        default Builder decimalColumnStatisticsData(Consumer<DecimalColumnStatisticsData.Builder> decimalColumnStatisticsData) {
            return decimalColumnStatisticsData(DecimalColumnStatisticsData.builder().applyMutation(decimalColumnStatisticsData)
                    .build());
        }

        /**
         * <p>
         * Double column statistics data.
         * </p>
         * 
         * @param doubleColumnStatisticsData
         *        Double column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleColumnStatisticsData(DoubleColumnStatisticsData doubleColumnStatisticsData);

        /**
         * <p>
         * Double column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link DoubleColumnStatisticsData.Builder} avoiding the
         * need to create one manually via {@link DoubleColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link DoubleColumnStatisticsData.Builder#build()} is called immediately
         * and its result is passed to {@link #doubleColumnStatisticsData(DoubleColumnStatisticsData)}.
         * 
         * @param doubleColumnStatisticsData
         *        a consumer that will call methods on {@link DoubleColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #doubleColumnStatisticsData(DoubleColumnStatisticsData)
         */
        default Builder doubleColumnStatisticsData(Consumer<DoubleColumnStatisticsData.Builder> doubleColumnStatisticsData) {
            return doubleColumnStatisticsData(DoubleColumnStatisticsData.builder().applyMutation(doubleColumnStatisticsData)
                    .build());
        }

        /**
         * <p>
         * Long column statistics data.
         * </p>
         * 
         * @param longColumnStatisticsData
         *        Long column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longColumnStatisticsData(LongColumnStatisticsData longColumnStatisticsData);

        /**
         * <p>
         * Long column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link LongColumnStatisticsData.Builder} avoiding the
         * need to create one manually via {@link LongColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link LongColumnStatisticsData.Builder#build()} is called immediately
         * and its result is passed to {@link #longColumnStatisticsData(LongColumnStatisticsData)}.
         * 
         * @param longColumnStatisticsData
         *        a consumer that will call methods on {@link LongColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #longColumnStatisticsData(LongColumnStatisticsData)
         */
        default Builder longColumnStatisticsData(Consumer<LongColumnStatisticsData.Builder> longColumnStatisticsData) {
            return longColumnStatisticsData(LongColumnStatisticsData.builder().applyMutation(longColumnStatisticsData).build());
        }

        /**
         * <p>
         * String column statistics data.
         * </p>
         * 
         * @param stringColumnStatisticsData
         *        String column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringColumnStatisticsData(StringColumnStatisticsData stringColumnStatisticsData);

        /**
         * <p>
         * String column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link StringColumnStatisticsData.Builder} avoiding the
         * need to create one manually via {@link StringColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link StringColumnStatisticsData.Builder#build()} is called immediately
         * and its result is passed to {@link #stringColumnStatisticsData(StringColumnStatisticsData)}.
         * 
         * @param stringColumnStatisticsData
         *        a consumer that will call methods on {@link StringColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringColumnStatisticsData(StringColumnStatisticsData)
         */
        default Builder stringColumnStatisticsData(Consumer<StringColumnStatisticsData.Builder> stringColumnStatisticsData) {
            return stringColumnStatisticsData(StringColumnStatisticsData.builder().applyMutation(stringColumnStatisticsData)
                    .build());
        }

        /**
         * <p>
         * Binary column statistics data.
         * </p>
         * 
         * @param binaryColumnStatisticsData
         *        Binary column statistics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryColumnStatisticsData(BinaryColumnStatisticsData binaryColumnStatisticsData);

        /**
         * <p>
         * Binary column statistics data.
         * </p>
         * This is a convenience that creates an instance of the {@link BinaryColumnStatisticsData.Builder} avoiding the
         * need to create one manually via {@link BinaryColumnStatisticsData#builder()}.
         *
         * When the {@link Consumer} completes, {@link BinaryColumnStatisticsData.Builder#build()} is called immediately
         * and its result is passed to {@link #binaryColumnStatisticsData(BinaryColumnStatisticsData)}.
         * 
         * @param binaryColumnStatisticsData
         *        a consumer that will call methods on {@link BinaryColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binaryColumnStatisticsData(BinaryColumnStatisticsData)
         */
        default Builder binaryColumnStatisticsData(Consumer<BinaryColumnStatisticsData.Builder> binaryColumnStatisticsData) {
            return binaryColumnStatisticsData(BinaryColumnStatisticsData.builder().applyMutation(binaryColumnStatisticsData)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private BooleanColumnStatisticsData booleanColumnStatisticsData;

        private DateColumnStatisticsData dateColumnStatisticsData;

        private DecimalColumnStatisticsData decimalColumnStatisticsData;

        private DoubleColumnStatisticsData doubleColumnStatisticsData;

        private LongColumnStatisticsData longColumnStatisticsData;

        private StringColumnStatisticsData stringColumnStatisticsData;

        private BinaryColumnStatisticsData binaryColumnStatisticsData;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsData model) {
            type(model.type);
            booleanColumnStatisticsData(model.booleanColumnStatisticsData);
            dateColumnStatisticsData(model.dateColumnStatisticsData);
            decimalColumnStatisticsData(model.decimalColumnStatisticsData);
            doubleColumnStatisticsData(model.doubleColumnStatisticsData);
            longColumnStatisticsData(model.longColumnStatisticsData);
            stringColumnStatisticsData(model.stringColumnStatisticsData);
            binaryColumnStatisticsData(model.binaryColumnStatisticsData);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ColumnStatisticsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final BooleanColumnStatisticsData.Builder getBooleanColumnStatisticsData() {
            return booleanColumnStatisticsData != null ? booleanColumnStatisticsData.toBuilder() : null;
        }

        public final void setBooleanColumnStatisticsData(BooleanColumnStatisticsData.BuilderImpl booleanColumnStatisticsData) {
            this.booleanColumnStatisticsData = booleanColumnStatisticsData != null ? booleanColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder booleanColumnStatisticsData(BooleanColumnStatisticsData booleanColumnStatisticsData) {
            this.booleanColumnStatisticsData = booleanColumnStatisticsData;
            return this;
        }

        public final DateColumnStatisticsData.Builder getDateColumnStatisticsData() {
            return dateColumnStatisticsData != null ? dateColumnStatisticsData.toBuilder() : null;
        }

        public final void setDateColumnStatisticsData(DateColumnStatisticsData.BuilderImpl dateColumnStatisticsData) {
            this.dateColumnStatisticsData = dateColumnStatisticsData != null ? dateColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder dateColumnStatisticsData(DateColumnStatisticsData dateColumnStatisticsData) {
            this.dateColumnStatisticsData = dateColumnStatisticsData;
            return this;
        }

        public final DecimalColumnStatisticsData.Builder getDecimalColumnStatisticsData() {
            return decimalColumnStatisticsData != null ? decimalColumnStatisticsData.toBuilder() : null;
        }

        public final void setDecimalColumnStatisticsData(DecimalColumnStatisticsData.BuilderImpl decimalColumnStatisticsData) {
            this.decimalColumnStatisticsData = decimalColumnStatisticsData != null ? decimalColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder decimalColumnStatisticsData(DecimalColumnStatisticsData decimalColumnStatisticsData) {
            this.decimalColumnStatisticsData = decimalColumnStatisticsData;
            return this;
        }

        public final DoubleColumnStatisticsData.Builder getDoubleColumnStatisticsData() {
            return doubleColumnStatisticsData != null ? doubleColumnStatisticsData.toBuilder() : null;
        }

        public final void setDoubleColumnStatisticsData(DoubleColumnStatisticsData.BuilderImpl doubleColumnStatisticsData) {
            this.doubleColumnStatisticsData = doubleColumnStatisticsData != null ? doubleColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder doubleColumnStatisticsData(DoubleColumnStatisticsData doubleColumnStatisticsData) {
            this.doubleColumnStatisticsData = doubleColumnStatisticsData;
            return this;
        }

        public final LongColumnStatisticsData.Builder getLongColumnStatisticsData() {
            return longColumnStatisticsData != null ? longColumnStatisticsData.toBuilder() : null;
        }

        public final void setLongColumnStatisticsData(LongColumnStatisticsData.BuilderImpl longColumnStatisticsData) {
            this.longColumnStatisticsData = longColumnStatisticsData != null ? longColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder longColumnStatisticsData(LongColumnStatisticsData longColumnStatisticsData) {
            this.longColumnStatisticsData = longColumnStatisticsData;
            return this;
        }

        public final StringColumnStatisticsData.Builder getStringColumnStatisticsData() {
            return stringColumnStatisticsData != null ? stringColumnStatisticsData.toBuilder() : null;
        }

        public final void setStringColumnStatisticsData(StringColumnStatisticsData.BuilderImpl stringColumnStatisticsData) {
            this.stringColumnStatisticsData = stringColumnStatisticsData != null ? stringColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder stringColumnStatisticsData(StringColumnStatisticsData stringColumnStatisticsData) {
            this.stringColumnStatisticsData = stringColumnStatisticsData;
            return this;
        }

        public final BinaryColumnStatisticsData.Builder getBinaryColumnStatisticsData() {
            return binaryColumnStatisticsData != null ? binaryColumnStatisticsData.toBuilder() : null;
        }

        public final void setBinaryColumnStatisticsData(BinaryColumnStatisticsData.BuilderImpl binaryColumnStatisticsData) {
            this.binaryColumnStatisticsData = binaryColumnStatisticsData != null ? binaryColumnStatisticsData.build() : null;
        }

        @Override
        @Transient
        public final Builder binaryColumnStatisticsData(BinaryColumnStatisticsData binaryColumnStatisticsData) {
            this.binaryColumnStatisticsData = binaryColumnStatisticsData;
            return this;
        }

        @Override
        public ColumnStatisticsData build() {
            return new ColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
