/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionsRequest extends GlueRequest implements
        ToCopyableBuilder<GetConnectionsRequest.Builder, GetConnectionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetConnectionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<GetConnectionsFilter> FILTER_FIELD = SdkField
            .<GetConnectionsFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(GetConnectionsRequest::filter)).setter(setter(Builder::filter))
            .constructor(GetConnectionsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<Boolean> HIDE_PASSWORD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HidePassword").getter(getter(GetConnectionsRequest::hidePassword)).setter(setter(Builder::hidePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HidePassword").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConnectionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetConnectionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            FILTER_FIELD, HIDE_PASSWORD_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String catalogId;

    private final GetConnectionsFilter filter;

    private final Boolean hidePassword;

    private final String nextToken;

    private final Integer maxResults;

    private GetConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.filter = builder.filter;
        this.hidePassword = builder.hidePassword;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services account
     * ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
     *         account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A filter that controls which connections are returned.
     * </p>
     * 
     * @return A filter that controls which connections are returned.
     */
    public final GetConnectionsFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console
     * uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller
     * might not have permission to use the KMS key to decrypt the password, but it does have permission to access the
     * rest of the connection properties.
     * </p>
     * 
     * @return Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue
     *         console uses this flag to retrieve the connection, and does not display the password. Set this parameter
     *         when the caller might not have permission to use the KMS key to decrypt the password, but it does have
     *         permission to access the rest of the connection properties.
     */
    public final Boolean hidePassword() {
        return hidePassword;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of connections to return in one response.
     * </p>
     * 
     * @return The maximum number of connections to return in one response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hidePassword());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsRequest)) {
            return false;
        }
        GetConnectionsRequest other = (GetConnectionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(filter(), other.filter())
                && Objects.equals(hidePassword(), other.hidePassword()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionsRequest").add("CatalogId", catalogId()).add("Filter", filter())
                .add("HidePassword", hidePassword()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "HidePassword":
            return Optional.ofNullable(clazz.cast(hidePassword()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionsRequest, T> g) {
        return obj -> g.apply((GetConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectionsRequest> {
        /**
         * <p>
         * The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
         * account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web
         *        Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A filter that controls which connections are returned.
         * </p>
         * 
         * @param filter
         *        A filter that controls which connections are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(GetConnectionsFilter filter);

        /**
         * <p>
         * A filter that controls which connections are returned.
         * </p>
         * This is a convenience that creates an instance of the {@link GetConnectionsFilter.Builder} avoiding the need
         * to create one manually via {@link GetConnectionsFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link GetConnectionsFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(GetConnectionsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link GetConnectionsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(GetConnectionsFilter)
         */
        default Builder filter(Consumer<GetConnectionsFilter.Builder> filter) {
            return filter(GetConnectionsFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue
         * console uses this flag to retrieve the connection, and does not display the password. Set this parameter when
         * the caller might not have permission to use the KMS key to decrypt the password, but it does have permission
         * to access the rest of the connection properties.
         * </p>
         * 
         * @param hidePassword
         *        Allows you to retrieve the connection metadata without returning the password. For instance, the AWS
         *        Glue console uses this flag to retrieve the connection, and does not display the password. Set this
         *        parameter when the caller might not have permission to use the KMS key to decrypt the password, but it
         *        does have permission to access the rest of the connection properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hidePassword(Boolean hidePassword);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of connections to return in one response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of connections to return in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private GetConnectionsFilter filter;

        private Boolean hidePassword;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            filter(model.filter);
            hidePassword(model.hidePassword);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final GetConnectionsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(GetConnectionsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(GetConnectionsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getHidePassword() {
            return hidePassword;
        }

        public final void setHidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
        }

        @Override
        @Transient
        public final Builder hidePassword(Boolean hidePassword) {
            this.hidePassword = hidePassword;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectionsRequest build() {
            return new GetConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
