/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaVersionResponse extends GlueResponse implements
        ToCopyableBuilder<GetSchemaVersionResponse.Builder, GetSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(GetSchemaVersionResponse::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaDefinition").getter(getter(GetSchemaVersionResponse::schemaDefinition))
            .setter(setter(Builder::schemaDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(GetSchemaVersionResponse::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(GetSchemaVersionResponse::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(GetSchemaVersionResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSchemaVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(GetSchemaVersionResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SCHEMA_VERSION_ID_FIELD, SCHEMA_DEFINITION_FIELD, DATA_FORMAT_FIELD,
                    SCHEMA_ARN_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, CREATED_TIME_FIELD));

    private final String schemaVersionId;

    private final String schemaDefinition;

    private final String dataFormat;

    private final String schemaArn;

    private final Long versionNumber;

    private final String status;

    private final String createdTime;

    private GetSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionId = builder.schemaVersionId;
        this.schemaDefinition = builder.schemaDefinition;
        this.dataFormat = builder.dataFormat;
        this.schemaArn = builder.schemaArn;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The <code>SchemaVersionId</code> of the schema version.
     * </p>
     * 
     * @return The <code>SchemaVersionId</code> of the schema version.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * The schema definition for the schema ID.
     * </p>
     * 
     * @return The schema definition for the schema ID.
     */
    public final String schemaDefinition() {
        return schemaDefinition;
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
     *         supported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
     *         supported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schema.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The status of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema version.
     * @see SchemaVersionStatus
     */
    public final SchemaVersionStatus status() {
        return SchemaVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema version.
     * @see SchemaVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the schema version was created.
     * </p>
     * 
     * @return The date and time the schema version was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionResponse)) {
            return false;
        }
        GetSchemaVersionResponse other = (GetSchemaVersionResponse) obj;
        return Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(schemaDefinition(), other.schemaDefinition())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaVersionResponse").add("SchemaVersionId", schemaVersionId())
                .add("SchemaDefinition", schemaDefinition()).add("DataFormat", dataFormatAsString())
                .add("SchemaArn", schemaArn()).add("VersionNumber", versionNumber()).add("Status", statusAsString())
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "SchemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionResponse, T> g) {
        return obj -> g.apply((GetSchemaVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaVersionResponse> {
        /**
         * <p>
         * The <code>SchemaVersionId</code> of the schema version.
         * </p>
         * 
         * @param schemaVersionId
         *        The <code>SchemaVersionId</code> of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * The schema definition for the schema ID.
         * </p>
         * 
         * @param schemaDefinition
         *        The schema definition for the schema ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(String schemaDefinition);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
         *        supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.
         * </p>
         * 
         * @param dataFormat
         *        The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are
         *        supported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The status of the schema version.
         * </p>
         * 
         * @param status
         *        The status of the schema version.
         * @see SchemaVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the schema version.
         * </p>
         * 
         * @param status
         *        The status of the schema version.
         * @see SchemaVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionStatus
         */
        Builder status(SchemaVersionStatus status);

        /**
         * <p>
         * The date and time the schema version was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the schema version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String schemaVersionId;

        private String schemaDefinition;

        private String dataFormat;

        private String schemaArn;

        private Long versionNumber;

        private String status;

        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionResponse model) {
            super(model);
            schemaVersionId(model.schemaVersionId);
            schemaDefinition(model.schemaDefinition);
            dataFormat(model.dataFormat);
            schemaArn(model.schemaArn);
            versionNumber(model.versionNumber);
            status(model.status);
            createdTime(model.createdTime);
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        @Transient
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final String getSchemaDefinition() {
            return schemaDefinition;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        @Transient
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        @Transient
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        @Transient
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SchemaVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public GetSchemaVersionResponse build() {
            return new GetSchemaVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
