/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Blueprint implements SdkPojo, Serializable, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Blueprint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Blueprint::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedOn").getter(getter(Blueprint::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(Blueprint::lastModifiedOn)).setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<String> PARAMETER_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterSpec").getter(getter(Blueprint::parameterSpec)).setter(setter(Builder::parameterSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterSpec").build()).build();

    private static final SdkField<String> BLUEPRINT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintLocation").getter(getter(Blueprint::blueprintLocation))
            .setter(setter(Builder::blueprintLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintLocation").build()).build();

    private static final SdkField<String> BLUEPRINT_SERVICE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintServiceLocation").getter(getter(Blueprint::blueprintServiceLocation))
            .setter(setter(Builder::blueprintServiceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintServiceLocation").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Blueprint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(Blueprint::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<LastActiveDefinition> LAST_ACTIVE_DEFINITION_FIELD = SdkField
            .<LastActiveDefinition> builder(MarshallingType.SDK_POJO).memberName("LastActiveDefinition")
            .getter(getter(Blueprint::lastActiveDefinition)).setter(setter(Builder::lastActiveDefinition))
            .constructor(LastActiveDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActiveDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, PARAMETER_SPEC_FIELD, BLUEPRINT_LOCATION_FIELD,
            BLUEPRINT_SERVICE_LOCATION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, LAST_ACTIVE_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final Instant createdOn;

    private final Instant lastModifiedOn;

    private final String parameterSpec;

    private final String blueprintLocation;

    private final String blueprintServiceLocation;

    private final String status;

    private final String errorMessage;

    private final LastActiveDefinition lastActiveDefinition;

    private Blueprint(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.parameterSpec = builder.parameterSpec;
        this.blueprintLocation = builder.blueprintLocation;
        this.blueprintServiceLocation = builder.blueprintServiceLocation;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.lastActiveDefinition = builder.lastActiveDefinition;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the blueprint.
     * </p>
     * 
     * @return The description of the blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the blueprint was registered.
     * </p>
     * 
     * @return The date and time the blueprint was registered.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The date and time the blueprint was last modified.
     * </p>
     * 
     * @return The date and time the blueprint was last modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * A JSON string that indicates the list of parameter specifications for the blueprint.
     * </p>
     * 
     * @return A JSON string that indicates the list of parameter specifications for the blueprint.
     */
    public final String parameterSpec() {
        return parameterSpec;
    }

    /**
     * <p>
     * Specifies the path in Amazon S3 where the blueprint is published.
     * </p>
     * 
     * @return Specifies the path in Amazon S3 where the blueprint is published.
     */
    public final String blueprintLocation() {
        return blueprintLocation;
    }

    /**
     * <p>
     * Specifies a path in Amazon S3 where the blueprint is copied when you call
     * <code>CreateBlueprint/UpdateBlueprint</code> to register the blueprint in Glue.
     * </p>
     * 
     * @return Specifies a path in Amazon S3 where the blueprint is copied when you call
     *         <code>CreateBlueprint/UpdateBlueprint</code> to register the blueprint in Glue.
     */
    public final String blueprintServiceLocation() {
        return blueprintServiceLocation;
    }

    /**
     * <p>
     * The status of the blueprint registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating — The blueprint registration is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Active — The blueprint has been successfully registered.
     * </p>
     * </li>
     * <li>
     * <p>
     * Updating — An update to the blueprint registration is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed — The blueprint registration failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlueprintStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the blueprint registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating — The blueprint registration is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Active — The blueprint has been successfully registered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Updating — An update to the blueprint registration is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed — The blueprint registration failed.
     *         </p>
     *         </li>
     * @see BlueprintStatus
     */
    public final BlueprintStatus status() {
        return BlueprintStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the blueprint registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating — The blueprint registration is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Active — The blueprint has been successfully registered.
     * </p>
     * </li>
     * <li>
     * <p>
     * Updating — An update to the blueprint registration is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed — The blueprint registration failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BlueprintStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the blueprint registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating — The blueprint registration is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Active — The blueprint has been successfully registered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Updating — An update to the blueprint registration is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed — The blueprint registration failed.
     *         </p>
     *         </li>
     * @see BlueprintStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error message.
     * </p>
     * 
     * @return An error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * When there are multiple versions of a blueprint and the latest version has some errors, this attribute indicates
     * the last successful blueprint definition that is available with the service.
     * </p>
     * 
     * @return When there are multiple versions of a blueprint and the latest version has some errors, this attribute
     *         indicates the last successful blueprint definition that is available with the service.
     */
    public final LastActiveDefinition lastActiveDefinition() {
        return lastActiveDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSpec());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintLocation());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintServiceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastActiveDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdOn(), other.createdOn()) && Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && Objects.equals(parameterSpec(), other.parameterSpec())
                && Objects.equals(blueprintLocation(), other.blueprintLocation())
                && Objects.equals(blueprintServiceLocation(), other.blueprintServiceLocation())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lastActiveDefinition(), other.lastActiveDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Blueprint").add("Name", name()).add("Description", description()).add("CreatedOn", createdOn())
                .add("LastModifiedOn", lastModifiedOn()).add("ParameterSpec", parameterSpec())
                .add("BlueprintLocation", blueprintLocation()).add("BlueprintServiceLocation", blueprintServiceLocation())
                .add("Status", statusAsString()).add("ErrorMessage", errorMessage())
                .add("LastActiveDefinition", lastActiveDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "ParameterSpec":
            return Optional.ofNullable(clazz.cast(parameterSpec()));
        case "BlueprintLocation":
            return Optional.ofNullable(clazz.cast(blueprintLocation()));
        case "BlueprintServiceLocation":
            return Optional.ofNullable(clazz.cast(blueprintServiceLocation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LastActiveDefinition":
            return Optional.ofNullable(clazz.cast(lastActiveDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Blueprint> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param name
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the blueprint.
         * </p>
         * 
         * @param description
         *        The description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the blueprint was registered.
         * </p>
         * 
         * @param createdOn
         *        The date and time the blueprint was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The date and time the blueprint was last modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        The date and time the blueprint was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * A JSON string that indicates the list of parameter specifications for the blueprint.
         * </p>
         * 
         * @param parameterSpec
         *        A JSON string that indicates the list of parameter specifications for the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSpec(String parameterSpec);

        /**
         * <p>
         * Specifies the path in Amazon S3 where the blueprint is published.
         * </p>
         * 
         * @param blueprintLocation
         *        Specifies the path in Amazon S3 where the blueprint is published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintLocation(String blueprintLocation);

        /**
         * <p>
         * Specifies a path in Amazon S3 where the blueprint is copied when you call
         * <code>CreateBlueprint/UpdateBlueprint</code> to register the blueprint in Glue.
         * </p>
         * 
         * @param blueprintServiceLocation
         *        Specifies a path in Amazon S3 where the blueprint is copied when you call
         *        <code>CreateBlueprint/UpdateBlueprint</code> to register the blueprint in Glue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintServiceLocation(String blueprintServiceLocation);

        /**
         * <p>
         * The status of the blueprint registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Creating — The blueprint registration is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Active — The blueprint has been successfully registered.
         * </p>
         * </li>
         * <li>
         * <p>
         * Updating — An update to the blueprint registration is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed — The blueprint registration failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the blueprint registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Creating — The blueprint registration is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Active — The blueprint has been successfully registered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Updating — An update to the blueprint registration is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed — The blueprint registration failed.
         *        </p>
         *        </li>
         * @see BlueprintStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the blueprint registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Creating — The blueprint registration is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Active — The blueprint has been successfully registered.
         * </p>
         * </li>
         * <li>
         * <p>
         * Updating — An update to the blueprint registration is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed — The blueprint registration failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the blueprint registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Creating — The blueprint registration is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Active — The blueprint has been successfully registered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Updating — An update to the blueprint registration is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed — The blueprint registration failed.
         *        </p>
         *        </li>
         * @see BlueprintStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStatus
         */
        Builder status(BlueprintStatus status);

        /**
         * <p>
         * An error message.
         * </p>
         * 
         * @param errorMessage
         *        An error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * When there are multiple versions of a blueprint and the latest version has some errors, this attribute
         * indicates the last successful blueprint definition that is available with the service.
         * </p>
         * 
         * @param lastActiveDefinition
         *        When there are multiple versions of a blueprint and the latest version has some errors, this attribute
         *        indicates the last successful blueprint definition that is available with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActiveDefinition(LastActiveDefinition lastActiveDefinition);

        /**
         * <p>
         * When there are multiple versions of a blueprint and the latest version has some errors, this attribute
         * indicates the last successful blueprint definition that is available with the service.
         * </p>
         * This is a convenience that creates an instance of the {@link LastActiveDefinition.Builder} avoiding the need
         * to create one manually via {@link LastActiveDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastActiveDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #lastActiveDefinition(LastActiveDefinition)}.
         * 
         * @param lastActiveDefinition
         *        a consumer that will call methods on {@link LastActiveDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastActiveDefinition(LastActiveDefinition)
         */
        default Builder lastActiveDefinition(Consumer<LastActiveDefinition.Builder> lastActiveDefinition) {
            return lastActiveDefinition(LastActiveDefinition.builder().applyMutation(lastActiveDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private Instant createdOn;

        private Instant lastModifiedOn;

        private String parameterSpec;

        private String blueprintLocation;

        private String blueprintServiceLocation;

        private String status;

        private String errorMessage;

        private LastActiveDefinition lastActiveDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            name(model.name);
            description(model.description);
            createdOn(model.createdOn);
            lastModifiedOn(model.lastModifiedOn);
            parameterSpec(model.parameterSpec);
            blueprintLocation(model.blueprintLocation);
            blueprintServiceLocation(model.blueprintServiceLocation);
            status(model.status);
            errorMessage(model.errorMessage);
            lastActiveDefinition(model.lastActiveDefinition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        @Transient
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        @Transient
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getParameterSpec() {
            return parameterSpec;
        }

        public final void setParameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
        }

        @Override
        @Transient
        public final Builder parameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public final String getBlueprintLocation() {
            return blueprintLocation;
        }

        public final void setBlueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
        }

        @Override
        @Transient
        public final Builder blueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
            return this;
        }

        public final String getBlueprintServiceLocation() {
            return blueprintServiceLocation;
        }

        public final void setBlueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
        }

        @Override
        @Transient
        public final Builder blueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(BlueprintStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final LastActiveDefinition.Builder getLastActiveDefinition() {
            return lastActiveDefinition != null ? lastActiveDefinition.toBuilder() : null;
        }

        public final void setLastActiveDefinition(LastActiveDefinition.BuilderImpl lastActiveDefinition) {
            this.lastActiveDefinition = lastActiveDefinition != null ? lastActiveDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder lastActiveDefinition(LastActiveDefinition lastActiveDefinition) {
            this.lastActiveDefinition = lastActiveDefinition;
            return this;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
