/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An edge represents a directed connection between two components on a workflow graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Edge implements SdkPojo, Serializable, ToCopyableBuilder<Edge.Builder, Edge> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceId").getter(getter(Edge::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(Edge::destinationId)).setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD,
            DESTINATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceId;

    private final String destinationId;

    private Edge(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.destinationId = builder.destinationId;
    }

    /**
     * <p>
     * The unique of the node within the workflow where the edge starts.
     * </p>
     * 
     * @return The unique of the node within the workflow where the edge starts.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The unique of the node within the workflow where the edge ends.
     * </p>
     * 
     * @return The unique of the node within the workflow where the edge ends.
     */
    public final String destinationId() {
        return destinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge) obj;
        return Objects.equals(sourceId(), other.sourceId()) && Objects.equals(destinationId(), other.destinationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Edge").add("SourceId", sourceId()).add("DestinationId", destinationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Edge> {
        /**
         * <p>
         * The unique of the node within the workflow where the edge starts.
         * </p>
         * 
         * @param sourceId
         *        The unique of the node within the workflow where the edge starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The unique of the node within the workflow where the edge ends.
         * </p>
         * 
         * @param destinationId
         *        The unique of the node within the workflow where the edge ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);
    }

    static final class BuilderImpl implements Builder {
        private String sourceId;

        private String destinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            sourceId(model.sourceId);
            destinationId(model.destinationId);
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        @Transient
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        @Transient
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Override
        public Edge build() {
            return new Edge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
