/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatabasesRequest extends GlueRequest implements
        ToCopyableBuilder<GetDatabasesRequest.Builder, GetDatabasesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetDatabasesRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDatabasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetDatabasesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceShareType").getter(getter(GetDatabasesRequest::resourceShareTypeAsString))
            .setter(setter(Builder::resourceShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_SHARE_TYPE_FIELD));

    private final String catalogId;

    private final String nextToken;

    private final Integer maxResults;

    private final String resourceShareType;

    private GetDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceShareType = builder.resourceShareType;
    }

    /**
     * <p>
     * The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon Web
     * Services account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon
     *         Web Services account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of databases to return in one response.
     * </p>
     * 
     * @return The maximum number of databases to return in one response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Allows you to specify that you want to list the databases shared with your account. The allowable values are
     * <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will list the databases shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
     * local account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to list the databases shared with your account. The allowable values
     *         are <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will list the databases shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in
     *         yor local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public final ResourceShareType resourceShareType() {
        return ResourceShareType.fromValue(resourceShareType);
    }

    /**
     * <p>
     * Allows you to specify that you want to list the databases shared with your account. The allowable values are
     * <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will list the databases shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
     * local account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to list the databases shared with your account. The allowable values
     *         are <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will list the databases shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in
     *         yor local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public final String resourceShareTypeAsString() {
        return resourceShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesRequest)) {
            return false;
        }
        GetDatabasesRequest other = (GetDatabasesRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resourceShareTypeAsString(), other.resourceShareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatabasesRequest").add("CatalogId", catalogId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("ResourceShareType", resourceShareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResourceShareType":
            return Optional.ofNullable(clazz.cast(resourceShareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatabasesRequest, T> g) {
        return obj -> g.apply((GetDatabasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDatabasesRequest> {
        /**
         * <p>
         * The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon Web
         * Services account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the
         *        Amazon Web Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of databases to return in one response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of databases to return in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Allows you to specify that you want to list the databases shared with your account. The allowable values are
         * <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will list the databases shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to list the databases shared with your account. The allowable
         *        values are <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will list the databases shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases
         *        in yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(String resourceShareType);

        /**
         * <p>
         * Allows you to specify that you want to list the databases shared with your account. The allowable values are
         * <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will list the databases shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to list the databases shared with your account. The allowable
         *        values are <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will list the databases shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases
         *        in yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(ResourceShareType resourceShareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String nextToken;

        private Integer maxResults;

        private String resourceShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesRequest model) {
            super(model);
            catalogId(model.catalogId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resourceShareType(model.resourceShareType);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceShareType() {
            return resourceShareType;
        }

        public final void setResourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
        }

        @Override
        @Transient
        public final Builder resourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceShareType(ResourceShareType resourceShareType) {
            this.resourceShareType(resourceShareType == null ? null : resourceShareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabasesRequest build() {
            return new GetDatabasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
