/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlTransformsRequest extends GlueRequest implements
        ToCopyableBuilder<GetMlTransformsRequest.Builder, GetMlTransformsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMlTransformsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetMlTransformsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<TransformFilterCriteria> FILTER_FIELD = SdkField
            .<TransformFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(GetMlTransformsRequest::filter)).setter(setter(Builder::filter))
            .constructor(TransformFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<TransformSortCriteria> SORT_FIELD = SdkField
            .<TransformSortCriteria> builder(MarshallingType.SDK_POJO).memberName("Sort")
            .getter(getter(GetMlTransformsRequest::sort)).setter(setter(Builder::sort))
            .constructor(TransformSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTER_FIELD, SORT_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final TransformFilterCriteria filter;

    private final TransformSortCriteria sort;

    private GetMlTransformsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * A paginated token to offset the results.
     * </p>
     * 
     * @return A paginated token to offset the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The filter transformation criteria.
     * </p>
     * 
     * @return The filter transformation criteria.
     */
    public final TransformFilterCriteria filter() {
        return filter;
    }

    /**
     * <p>
     * The sorting criteria.
     * </p>
     * 
     * @return The sorting criteria.
     */
    public final TransformSortCriteria sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTransformsRequest)) {
            return false;
        }
        GetMlTransformsRequest other = (GetMlTransformsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filter(), other.filter()) && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlTransformsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filter", filter()).add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTransformsRequest, T> g) {
        return obj -> g.apply((GetMlTransformsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMlTransformsRequest> {
        /**
         * <p>
         * A paginated token to offset the results.
         * </p>
         * 
         * @param nextToken
         *        A paginated token to offset the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The filter transformation criteria.
         * </p>
         * 
         * @param filter
         *        The filter transformation criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(TransformFilterCriteria filter);

        /**
         * <p>
         * The filter transformation criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformFilterCriteria.Builder} avoiding the
         * need to create one manually via {@link TransformFilterCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #filter(TransformFilterCriteria)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link TransformFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(TransformFilterCriteria)
         */
        default Builder filter(Consumer<TransformFilterCriteria.Builder> filter) {
            return filter(TransformFilterCriteria.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The sorting criteria.
         * </p>
         * 
         * @param sort
         *        The sorting criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(TransformSortCriteria sort);

        /**
         * <p>
         * The sorting criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformSortCriteria.Builder} avoiding the need
         * to create one manually via {@link TransformSortCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformSortCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #sort(TransformSortCriteria)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link TransformSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(TransformSortCriteria)
         */
        default Builder sort(Consumer<TransformSortCriteria.Builder> sort) {
            return sort(TransformSortCriteria.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private TransformFilterCriteria filter;

        private TransformSortCriteria sort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTransformsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filter(model.filter);
            sort(model.sort);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TransformFilterCriteria.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(TransformFilterCriteria.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(TransformFilterCriteria filter) {
            this.filter = filter;
            return this;
        }

        public final TransformSortCriteria.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(TransformSortCriteria.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        @Transient
        public final Builder sort(TransformSortCriteria sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMlTransformsRequest build() {
            return new GetMlTransformsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
