/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPartitionsRequest extends GlueRequest implements
        ToCopyableBuilder<GetPartitionsRequest.Builder, GetPartitionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetPartitionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetPartitionsRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(GetPartitionsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(GetPartitionsRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetPartitionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.<Segment> builder(MarshallingType.SDK_POJO)
            .memberName("Segment").getter(getter(GetPartitionsRequest::segment)).setter(setter(Builder::segment))
            .constructor(Segment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetPartitionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> EXCLUDE_COLUMN_SCHEMA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeColumnSchema").getter(getter(GetPartitionsRequest::excludeColumnSchema))
            .setter(setter(Builder::excludeColumnSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeColumnSchema").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, EXPRESSION_FIELD, NEXT_TOKEN_FIELD, SEGMENT_FIELD, MAX_RESULTS_FIELD,
            EXCLUDE_COLUMN_SCHEMA_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String expression;

    private final String nextToken;

    private final Segment segment;

    private final Integer maxResults;

    private final Boolean excludeColumnSchema;

    private GetPartitionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.expression = builder.expression;
        this.nextToken = builder.nextToken;
        this.segment = builder.segment;
        this.maxResults = builder.maxResults;
        this.excludeColumnSchema = builder.excludeColumnSchema;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is provided, the Amazon Web Services
     * account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the partitions in question reside. If none is provided, the Amazon Web
     *         Services account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @return The name of the catalog database where the partitions reside.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the partitions' table.
     * </p>
     * 
     * @return The name of the partitions' table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * An expression that filters the partitions to be returned.
     * </p>
     * <p>
     * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a
     * href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     * </p>
     * <p>
     * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
     * </p>
     * <dl>
     * <dt>=</dt>
     * <dd>
     * <p>
     * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     * </p>
     * <p>
     * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     * </p>
     * <p>
     * (a = b) is not true.
     * </p>
     * </dd>
     * <dt>&lt; &gt;</dt>
     * <dd>
     * <p>
     * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
     * true.
     * </p>
     * <p>
     * Example: (a &lt; &gt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt; b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt;= b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt;= b) is true.
     * </p>
     * </dd>
     * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     * <dd>
     * <p>
     * Logical operators.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>date</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>int</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bigint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>long</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tinyint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>smallint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>decimal</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If an type is encountered that is not valid, an exception is thrown.
     * </p>
     * <p>
     * The following list shows the valid operators on each type. When you define a crawler, the
     * <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog partitions.
     * </p>
     * <p>
     * <i>Sample API Call</i>:
     * </p>
     * 
     * @return An expression that filters the partitions to be returned.</p>
     *         <p>
     *         The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement
     *         parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     *         </p>
     *         <p>
     *         <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API
     *         call:
     *         </p>
     *         <dl>
     *         <dt>=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     *         </p>
     *         <p>
     *         (a = b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt; &gt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the values of two operands are equal; if the values are not equal, then the condition
     *         becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt; &gt; b) is true.
     *         </p>
     *         </dd>
     *         <dt>&gt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is greater than the value of the right operand; if yes, then
     *         the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &gt; b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is less than the value of the right operand; if yes, then
     *         the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt; b) is true.
     *         </p>
     *         </dd>
     *         <dt>&gt;=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is greater than or equal to the value of the right operand;
     *         if yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &gt;= b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt;=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is less than or equal to the value of the right operand; if
     *         yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt;= b) is true.
     *         </p>
     *         </dd>
     *         <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     *         <dd>
     *         <p>
     *         Logical operators.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>string</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>date</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>timestamp</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>int</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bigint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>long</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tinyint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>smallint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>decimal</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If an type is encountered that is not valid, an exception is thrown.
     *         </p>
     *         <p>
     *         The following list shows the valid operators on each type. When you define a crawler, the
     *         <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog
     *         partitions.
     *         </p>
     *         <p>
     *         <i>Sample API Call</i>:
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these partitions.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve these partitions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The segment of the table's partitions to scan in this request.
     * </p>
     * 
     * @return The segment of the table's partitions to scan in this request.
     */
    public final Segment segment() {
        return segment;
    }

    /**
     * <p>
     * The maximum number of partitions to return in a single response.
     * </p>
     * 
     * @return The maximum number of partitions to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When true, specifies not returning the partition column schema. Useful when you are interested only in other
     * partition attributes such as partition values or location. This approach avoids the problem of a large response
     * by not returning duplicate data.
     * </p>
     * 
     * @return When true, specifies not returning the partition column schema. Useful when you are interested only in
     *         other partition attributes such as partition values or location. This approach avoids the problem of a
     *         large response by not returning duplicate data.
     */
    public final Boolean excludeColumnSchema() {
        return excludeColumnSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(excludeColumnSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsRequest)) {
            return false;
        }
        GetPartitionsRequest other = (GetPartitionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(expression(), other.expression())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(segment(), other.segment())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(excludeColumnSchema(), other.excludeColumnSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPartitionsRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("Expression", expression()).add("NextToken", nextToken())
                .add("Segment", segment()).add("MaxResults", maxResults()).add("ExcludeColumnSchema", excludeColumnSchema())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ExcludeColumnSchema":
            return Optional.ofNullable(clazz.cast(excludeColumnSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartitionsRequest, T> g) {
        return obj -> g.apply((GetPartitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPartitionsRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the partitions in question reside. If none is provided, the Amazon Web
         * Services account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the partitions in question reside. If none is provided, the Amazon
         *        Web Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database where the partitions reside.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database where the partitions reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the partitions' table.
         * </p>
         * 
         * @param tableName
         *        The name of the partitions' table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * An expression that filters the partitions to be returned.
         * </p>
         * <p>
         * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser
         * <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
         * </p>
         * <p>
         * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
         * </p>
         * <dl>
         * <dt>=</dt>
         * <dd>
         * <p>
         * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
         * </p>
         * <p>
         * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
         * </p>
         * <p>
         * (a = b) is not true.
         * </p>
         * </dd>
         * <dt>&lt; &gt;</dt>
         * <dd>
         * <p>
         * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
         * true.
         * </p>
         * <p>
         * Example: (a &lt; &gt; b) is true.
         * </p>
         * </dd>
         * <dt>&gt;</dt>
         * <dd>
         * <p>
         * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
         * condition becomes true.
         * </p>
         * <p>
         * Example: (a &gt; b) is not true.
         * </p>
         * </dd>
         * <dt>&lt;</dt>
         * <dd>
         * <p>
         * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
         * condition becomes true.
         * </p>
         * <p>
         * Example: (a &lt; b) is true.
         * </p>
         * </dd>
         * <dt>&gt;=</dt>
         * <dd>
         * <p>
         * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if
         * yes, then the condition becomes true.
         * </p>
         * <p>
         * Example: (a &gt;= b) is not true.
         * </p>
         * </dd>
         * <dt>&lt;=</dt>
         * <dd>
         * <p>
         * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
         * then the condition becomes true.
         * </p>
         * <p>
         * Example: (a &lt;= b) is true.
         * </p>
         * </dd>
         * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
         * <dd>
         * <p>
         * Logical operators.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>string</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>date</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>int</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bigint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>long</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tinyint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>smallint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>decimal</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If an type is encountered that is not valid, an exception is thrown.
         * </p>
         * <p>
         * The following list shows the valid operators on each type. When you define a crawler, the
         * <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog
         * partitions.
         * </p>
         * <p>
         * <i>Sample API Call</i>:
         * </p>
         * 
         * @param expression
         *        An expression that filters the partitions to be returned.</p>
         *        <p>
         *        The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement
         *        parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
         *        </p>
         *        <p>
         *        <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API
         *        call:
         *        </p>
         *        <dl>
         *        <dt>=</dt>
         *        <dd>
         *        <p>
         *        Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
         *        </p>
         *        <p>
         *        Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
         *        </p>
         *        <p>
         *        (a = b) is not true.
         *        </p>
         *        </dd>
         *        <dt>&lt; &gt;</dt>
         *        <dd>
         *        <p>
         *        Checks whether the values of two operands are equal; if the values are not equal, then the condition
         *        becomes true.
         *        </p>
         *        <p>
         *        Example: (a &lt; &gt; b) is true.
         *        </p>
         *        </dd>
         *        <dt>&gt;</dt>
         *        <dd>
         *        <p>
         *        Checks whether the value of the left operand is greater than the value of the right operand; if yes,
         *        then the condition becomes true.
         *        </p>
         *        <p>
         *        Example: (a &gt; b) is not true.
         *        </p>
         *        </dd>
         *        <dt>&lt;</dt>
         *        <dd>
         *        <p>
         *        Checks whether the value of the left operand is less than the value of the right operand; if yes, then
         *        the condition becomes true.
         *        </p>
         *        <p>
         *        Example: (a &lt; b) is true.
         *        </p>
         *        </dd>
         *        <dt>&gt;=</dt>
         *        <dd>
         *        <p>
         *        Checks whether the value of the left operand is greater than or equal to the value of the right
         *        operand; if yes, then the condition becomes true.
         *        </p>
         *        <p>
         *        Example: (a &gt;= b) is not true.
         *        </p>
         *        </dd>
         *        <dt>&lt;=</dt>
         *        <dd>
         *        <p>
         *        Checks whether the value of the left operand is less than or equal to the value of the right operand;
         *        if yes, then the condition becomes true.
         *        </p>
         *        <p>
         *        Example: (a &lt;= b) is true.
         *        </p>
         *        </dd>
         *        <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
         *        <dd>
         *        <p>
         *        Logical operators.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        <i>Supported Partition Key Types</i>: The following are the supported partition keys.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>string</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>date</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>timestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>int</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bigint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>long</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tinyint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>smallint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>decimal</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If an type is encountered that is not valid, an exception is thrown.
         *        </p>
         *        <p>
         *        The following list shows the valid operators on each type. When you define a crawler, the
         *        <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog
         *        partitions.
         *        </p>
         *        <p>
         *        <i>Sample API Call</i>:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve these partitions.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve these partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The segment of the table's partitions to scan in this request.
         * </p>
         * 
         * @param segment
         *        The segment of the table's partitions to scan in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Segment segment);

        /**
         * <p>
         * The segment of the table's partitions to scan in this request.
         * </p>
         * This is a convenience that creates an instance of the {@link Segment.Builder} avoiding the need to create one
         * manually via {@link Segment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Segment.Builder#build()} is called immediately and its result is
         * passed to {@link #segment(Segment)}.
         * 
         * @param segment
         *        a consumer that will call methods on {@link Segment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segment(Segment)
         */
        default Builder segment(Consumer<Segment.Builder> segment) {
            return segment(Segment.builder().applyMutation(segment).build());
        }

        /**
         * <p>
         * The maximum number of partitions to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of partitions to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When true, specifies not returning the partition column schema. Useful when you are interested only in other
         * partition attributes such as partition values or location. This approach avoids the problem of a large
         * response by not returning duplicate data.
         * </p>
         * 
         * @param excludeColumnSchema
         *        When true, specifies not returning the partition column schema. Useful when you are interested only in
         *        other partition attributes such as partition values or location. This approach avoids the problem of a
         *        large response by not returning duplicate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeColumnSchema(Boolean excludeColumnSchema);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String expression;

        private String nextToken;

        private Segment segment;

        private Integer maxResults;

        private Boolean excludeColumnSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            expression(model.expression);
            nextToken(model.nextToken);
            segment(model.segment);
            maxResults(model.maxResults);
            excludeColumnSchema(model.excludeColumnSchema);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        @Transient
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Segment.Builder getSegment() {
            return segment != null ? segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        @Transient
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getExcludeColumnSchema() {
            return excludeColumnSchema;
        }

        public final void setExcludeColumnSchema(Boolean excludeColumnSchema) {
            this.excludeColumnSchema = excludeColumnSchema;
        }

        @Override
        @Transient
        public final Builder excludeColumnSchema(Boolean excludeColumnSchema) {
            this.excludeColumnSchema = excludeColumnSchema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPartitionsRequest build() {
            return new GetPartitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
