/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaVersionRequest extends GlueRequest implements
        ToCopyableBuilder<GetSchemaVersionRequest.Builder, GetSchemaVersionRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(GetSchemaVersionRequest::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(GetSchemaVersionRequest::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<SchemaVersionNumber> SCHEMA_VERSION_NUMBER_FIELD = SdkField
            .<SchemaVersionNumber> builder(MarshallingType.SDK_POJO).memberName("SchemaVersionNumber")
            .getter(getter(GetSchemaVersionRequest::schemaVersionNumber)).setter(setter(Builder::schemaVersionNumber))
            .constructor(SchemaVersionNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            SCHEMA_VERSION_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD));

    private final SchemaId schemaId;

    private final String schemaVersionId;

    private final SchemaVersionNumber schemaVersionNumber;

    private GetSchemaVersionRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaVersionId = builder.schemaVersionId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
    }

    /**
     * <p>
     * This is a wrapper structure to contain schema identity fields. The structure contains:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
     * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
     * <code>RegistryName</code> has to be provided.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This is a wrapper structure to contain schema identity fields. The structure contains:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
     *         <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
     *         <code>RegistryName</code> has to be provided.
     *         </p>
     *         </li>
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema ID. Either
     * this or the <code>SchemaId</code> wrapper has to be provided.
     * </p>
     * 
     * @return The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema ID.
     *         Either this or the <code>SchemaId</code> wrapper has to be provided.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final SchemaVersionNumber schemaVersionNumber() {
        return schemaVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionRequest)) {
            return false;
        }
        GetSchemaVersionRequest other = (GetSchemaVersionRequest) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(schemaVersionNumber(), other.schemaVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaVersionRequest").add("SchemaId", schemaId()).add("SchemaVersionId", schemaVersionId())
                .add("SchemaVersionNumber", schemaVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "SchemaVersionNumber":
            return Optional.ofNullable(clazz.cast(schemaVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionRequest, T> g) {
        return obj -> g.apply((GetSchemaVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaVersionRequest> {
        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
         * <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schemaId
         *        This is a wrapper structure to contain schema identity fields. The structure contains:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         *        <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code>
         *        and <code>RegistryName</code> has to be provided.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
         * <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link SchemaId.Builder} avoiding the need to create
         * one manually via {@link SchemaId#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema ID.
         * Either this or the <code>SchemaId</code> wrapper has to be provided.
         * </p>
         * 
         * @param schemaVersionId
         *        The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema
         *        ID. Either this or the <code>SchemaId</code> wrapper has to be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param schemaVersionNumber
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaVersionNumber.Builder} avoiding the need
         * to create one manually via {@link SchemaVersionNumber#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaVersionNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #schemaVersionNumber(SchemaVersionNumber)}.
         * 
         * @param schemaVersionNumber
         *        a consumer that will call methods on {@link SchemaVersionNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersionNumber(SchemaVersionNumber)
         */
        default Builder schemaVersionNumber(Consumer<SchemaVersionNumber.Builder> schemaVersionNumber) {
            return schemaVersionNumber(SchemaVersionNumber.builder().applyMutation(schemaVersionNumber).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private SchemaId schemaId;

        private String schemaVersionId;

        private SchemaVersionNumber schemaVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionRequest model) {
            super(model);
            schemaId(model.schemaId);
            schemaVersionId(model.schemaVersionId);
            schemaVersionNumber(model.schemaVersionNumber);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        @Transient
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        @Transient
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final SchemaVersionNumber.Builder getSchemaVersionNumber() {
            return schemaVersionNumber != null ? schemaVersionNumber.toBuilder() : null;
        }

        public final void setSchemaVersionNumber(SchemaVersionNumber.BuilderImpl schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber != null ? schemaVersionNumber.build() : null;
        }

        @Override
        @Transient
        public final Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaVersionRequest build() {
            return new GetSchemaVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
