/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration properties for an importing labels task run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportLabelsTaskRunProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportLabelsTaskRunProperties.Builder, ImportLabelsTaskRunProperties> {
    private static final SdkField<String> INPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputS3Path").getter(getter(ImportLabelsTaskRunProperties::inputS3Path))
            .setter(setter(Builder::inputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputS3Path").build()).build();

    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Replace").getter(getter(ImportLabelsTaskRunProperties::replace)).setter(setter(Builder::replace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_S3_PATH_FIELD,
            REPLACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputS3Path;

    private final Boolean replace;

    private ImportLabelsTaskRunProperties(BuilderImpl builder) {
        this.inputS3Path = builder.inputS3Path;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path from where you will import the labels.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path from where you will import the labels.
     */
    public final String inputS3Path() {
        return inputS3Path;
    }

    /**
     * <p>
     * Indicates whether to overwrite your existing labels.
     * </p>
     * 
     * @return Indicates whether to overwrite your existing labels.
     */
    public final Boolean replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportLabelsTaskRunProperties)) {
            return false;
        }
        ImportLabelsTaskRunProperties other = (ImportLabelsTaskRunProperties) obj;
        return Objects.equals(inputS3Path(), other.inputS3Path()) && Objects.equals(replace(), other.replace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportLabelsTaskRunProperties").add("InputS3Path", inputS3Path()).add("Replace", replace())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputS3Path":
            return Optional.ofNullable(clazz.cast(inputS3Path()));
        case "Replace":
            return Optional.ofNullable(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportLabelsTaskRunProperties, T> g) {
        return obj -> g.apply((ImportLabelsTaskRunProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportLabelsTaskRunProperties> {
        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path from where you will import the labels.
         * </p>
         * 
         * @param inputS3Path
         *        The Amazon Simple Storage Service (Amazon S3) path from where you will import the labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Path(String inputS3Path);

        /**
         * <p>
         * Indicates whether to overwrite your existing labels.
         * </p>
         * 
         * @param replace
         *        Indicates whether to overwrite your existing labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);
    }

    static final class BuilderImpl implements Builder {
        private String inputS3Path;

        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportLabelsTaskRunProperties model) {
            inputS3Path(model.inputS3Path);
            replace(model.replace);
        }

        public final String getInputS3Path() {
            return inputS3Path;
        }

        public final void setInputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
        }

        @Override
        @Transient
        public final Builder inputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
            return this;
        }

        public final Boolean getReplace() {
            return replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        @Transient
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public ImportLabelsTaskRunProperties build() {
            return new ImportLabelsTaskRunProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
