/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CatalogTablesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogTarget> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CatalogTarget.getter(CatalogTarget::databaseName)).setter(CatalogTarget.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<List<String>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tables").getter(CatalogTarget.getter(CatalogTarget::tables)).setter(CatalogTarget.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final List<String> tables;

    private CatalogTarget(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tables = builder.tables;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public final List<String> tables() {
        return this.tables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogTarget)) {
            return false;
        }
        CatalogTarget other = (CatalogTarget)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogTarget").add("DatabaseName", (Object)this.databaseName()).add("Tables", this.hasTables() ? this.tables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogTarget, T> g) {
        return obj -> g.apply((CatalogTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private List<String> tables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogTarget model) {
            this.databaseName(model.databaseName);
            this.tables(model.tables);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Collection<String> getTables() {
            if (this.tables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tables;
        }

        public final void setTables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
        }

        @Override
        @Transient
        public final Builder tables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tables(String ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        public CatalogTarget build() {
            return new CatalogTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogTarget> {
        public Builder databaseName(String var1);

        public Builder tables(Collection<String> var1);

        public Builder tables(String ... var1);
    }
}

