/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.ListBlueprintsResponse;

public class ListBlueprintsIterable
implements SdkIterable<ListBlueprintsResponse> {
    private final GlueClient client;
    private final ListBlueprintsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBlueprintsIterable(GlueClient client, ListBlueprintsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBlueprintsResponseFetcher();
    }

    public Iterator<ListBlueprintsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBlueprintsResponseFetcher
    implements SyncPageFetcher<ListBlueprintsResponse> {
        private ListBlueprintsResponseFetcher() {
        }

        public boolean hasNextPage(ListBlueprintsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBlueprintsResponse nextPage(ListBlueprintsResponse previousPage) {
            if (previousPage == null) {
                return ListBlueprintsIterable.this.client.listBlueprints(ListBlueprintsIterable.this.firstRequest);
            }
            return ListBlueprintsIterable.this.client.listBlueprints((ListBlueprintsRequest)((Object)ListBlueprintsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

