/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDataQualityResultResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetDataQualityResultResponse.Builder, BatchGetDataQualityResultResponse> {
    private static final SdkField<List<DataQualityResult>> RESULTS_FIELD = SdkField
            .<List<DataQualityResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(BatchGetDataQualityResultResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQualityResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQualityResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESULTS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResultsNotFound")
            .getter(getter(BatchGetDataQualityResultResponse::resultsNotFound))
            .setter(setter(Builder::resultsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            RESULTS_NOT_FOUND_FIELD));

    private final List<DataQualityResult> results;

    private final List<String> resultsNotFound;

    private BatchGetDataQualityResultResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.resultsNotFound = builder.resultsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataQualityResult</code> objects representing the data quality results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A list of <code>DataQualityResult</code> objects representing the data quality results.
     */
    public final List<DataQualityResult> results() {
        return results;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultsNotFound property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultsNotFound() {
        return resultsNotFound != null && !(resultsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of result IDs for which results were not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultsNotFound} method.
     * </p>
     * 
     * @return A list of result IDs for which results were not found.
     */
    public final List<String> resultsNotFound() {
        return resultsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultsNotFound() ? resultsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDataQualityResultResponse)) {
            return false;
        }
        BatchGetDataQualityResultResponse other = (BatchGetDataQualityResultResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && hasResultsNotFound() == other.hasResultsNotFound()
                && Objects.equals(resultsNotFound(), other.resultsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDataQualityResultResponse").add("Results", hasResults() ? results() : null)
                .add("ResultsNotFound", hasResultsNotFound() ? resultsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "ResultsNotFound":
            return Optional.ofNullable(clazz.cast(resultsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDataQualityResultResponse, T> g) {
        return obj -> g.apply((BatchGetDataQualityResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDataQualityResultResponse> {
        /**
         * <p>
         * A list of <code>DataQualityResult</code> objects representing the data quality results.
         * </p>
         * 
         * @param results
         *        A list of <code>DataQualityResult</code> objects representing the data quality results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<DataQualityResult> results);

        /**
         * <p>
         * A list of <code>DataQualityResult</code> objects representing the data quality results.
         * </p>
         * 
         * @param results
         *        A list of <code>DataQualityResult</code> objects representing the data quality results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(DataQualityResult... results);

        /**
         * <p>
         * A list of <code>DataQualityResult</code> objects representing the data quality results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DataQualityResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.DataQualityResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DataQualityResult.Builder#build()} is called immediately
         * and its result is passed to {@link #results(List<DataQualityResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DataQualityResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<DataQualityResult>)
         */
        Builder results(Consumer<DataQualityResult.Builder>... results);

        /**
         * <p>
         * A list of result IDs for which results were not found.
         * </p>
         * 
         * @param resultsNotFound
         *        A list of result IDs for which results were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsNotFound(Collection<String> resultsNotFound);

        /**
         * <p>
         * A list of result IDs for which results were not found.
         * </p>
         * 
         * @param resultsNotFound
         *        A list of result IDs for which results were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsNotFound(String... resultsNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<DataQualityResult> results = DefaultSdkAutoConstructList.getInstance();

        private List<String> resultsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDataQualityResultResponse model) {
            super(model);
            results(model.results);
            resultsNotFound(model.resultsNotFound);
        }

        public final List<DataQualityResult.Builder> getResults() {
            List<DataQualityResult.Builder> result = DataQualityResultsListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<DataQualityResult.BuilderImpl> results) {
            this.results = DataQualityResultsListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<DataQualityResult> results) {
            this.results = DataQualityResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(DataQualityResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<DataQualityResult.Builder>... results) {
            results(Stream.of(results).map(c -> DataQualityResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getResultsNotFound() {
            if (resultsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return resultsNotFound;
        }

        public final void setResultsNotFound(Collection<String> resultsNotFound) {
            this.resultsNotFound = DataQualityResultIdsCopier.copy(resultsNotFound);
        }

        @Override
        public final Builder resultsNotFound(Collection<String> resultsNotFound) {
            this.resultsNotFound = DataQualityResultIdsCopier.copy(resultsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsNotFound(String... resultsNotFound) {
            resultsNotFound(Arrays.asList(resultsNotFound));
            return this;
        }

        @Override
        public BatchGetDataQualityResultResponse build() {
            return new BatchGetDataQualityResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
