/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Criteria used to return data quality results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityResultFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityResultFilterCriteria.Builder, DataQualityResultFilterCriteria> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DataQualityResultFilterCriteria::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(DataQualityResultFilterCriteria::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobRunId").getter(getter(DataQualityResultFilterCriteria::jobRunId)).setter(setter(Builder::jobRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()).build();

    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAfter").getter(getter(DataQualityResultFilterCriteria::startedAfter))
            .setter(setter(Builder::startedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAfter").build()).build();

    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedBefore").getter(getter(DataQualityResultFilterCriteria::startedBefore))
            .setter(setter(Builder::startedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBefore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            JOB_NAME_FIELD, JOB_RUN_ID_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataSource dataSource;

    private final String jobName;

    private final String jobRunId;

    private final Instant startedAfter;

    private final Instant startedBefore;

    private DataQualityResultFilterCriteria(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
    }

    /**
     * <p>
     * Filter results by the specified data source. For example, retrieving all results for an Glue table.
     * </p>
     * 
     * @return Filter results by the specified data source. For example, retrieving all results for an Glue table.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * Filter results by the specified job name.
     * </p>
     * 
     * @return Filter results by the specified job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Filter results by the specified job run ID.
     * </p>
     * 
     * @return Filter results by the specified job run ID.
     */
    public final String jobRunId() {
        return jobRunId;
    }

    /**
     * <p>
     * Filter results by runs that started after this time.
     * </p>
     * 
     * @return Filter results by runs that started after this time.
     */
    public final Instant startedAfter() {
        return startedAfter;
    }

    /**
     * <p>
     * Filter results by runs that started before this time.
     * </p>
     * 
     * @return Filter results by runs that started before this time.
     */
    public final Instant startedBefore() {
        return startedBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(startedBefore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityResultFilterCriteria)) {
            return false;
        }
        DataQualityResultFilterCriteria other = (DataQualityResultFilterCriteria) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobRunId(), other.jobRunId()) && Objects.equals(startedAfter(), other.startedAfter())
                && Objects.equals(startedBefore(), other.startedBefore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityResultFilterCriteria").add("DataSource", dataSource()).add("JobName", jobName())
                .add("JobRunId", jobRunId()).add("StartedAfter", startedAfter()).add("StartedBefore", startedBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobRunId":
            return Optional.ofNullable(clazz.cast(jobRunId()));
        case "StartedAfter":
            return Optional.ofNullable(clazz.cast(startedAfter()));
        case "StartedBefore":
            return Optional.ofNullable(clazz.cast(startedBefore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityResultFilterCriteria, T> g) {
        return obj -> g.apply((DataQualityResultFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityResultFilterCriteria> {
        /**
         * <p>
         * Filter results by the specified data source. For example, retrieving all results for an Glue table.
         * </p>
         * 
         * @param dataSource
         *        Filter results by the specified data source. For example, retrieving all results for an Glue table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * Filter results by the specified data source. For example, retrieving all results for an Glue table.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * Filter results by the specified job name.
         * </p>
         * 
         * @param jobName
         *        Filter results by the specified job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Filter results by the specified job run ID.
         * </p>
         * 
         * @param jobRunId
         *        Filter results by the specified job run ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunId(String jobRunId);

        /**
         * <p>
         * Filter results by runs that started after this time.
         * </p>
         * 
         * @param startedAfter
         *        Filter results by runs that started after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAfter(Instant startedAfter);

        /**
         * <p>
         * Filter results by runs that started before this time.
         * </p>
         * 
         * @param startedBefore
         *        Filter results by runs that started before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBefore(Instant startedBefore);
    }

    static final class BuilderImpl implements Builder {
        private DataSource dataSource;

        private String jobName;

        private String jobRunId;

        private Instant startedAfter;

        private Instant startedBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityResultFilterCriteria model) {
            dataSource(model.dataSource);
            jobName(model.jobName);
            jobRunId(model.jobRunId);
            startedAfter(model.startedAfter);
            startedBefore(model.startedBefore);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Instant getStartedAfter() {
            return startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        @Override
        public DataQualityResultFilterCriteria build() {
            return new DataQualityResultFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
