/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.PartitionIndexDescriptor;

public class GetPartitionIndexesPublisher
implements SdkPublisher<GetPartitionIndexesResponse> {
    private final GlueAsyncClient client;
    private final GetPartitionIndexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPartitionIndexesPublisher(GlueAsyncClient client, GetPartitionIndexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPartitionIndexesPublisher(GlueAsyncClient client, GetPartitionIndexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPartitionIndexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPartitionIndexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PartitionIndexDescriptor> partitionIndexDescriptorList() {
        Function<GetPartitionIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.partitionIndexDescriptorList() != null) {
                return response.partitionIndexDescriptorList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetPartitionIndexesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetPartitionIndexesResponseFetcher
    implements AsyncPageFetcher<GetPartitionIndexesResponse> {
        private GetPartitionIndexesResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPartitionIndexesResponse> nextPage(GetPartitionIndexesResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionIndexesPublisher.this.client.getPartitionIndexes(GetPartitionIndexesPublisher.this.firstRequest);
            }
            return GetPartitionIndexesPublisher.this.client.getPartitionIndexes((GetPartitionIndexesRequest)((Object)GetPartitionIndexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

